/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.tracing;

import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.tracing.MethodInstrumenter;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public final class ClassIDs {
    private static Pattern spacePattern = Pattern.compile(" ");
    private final TIntHashSet subclassesOfTextualOutputProducers;
    private final HashMap<QualifiedClassName, ClassID> classesByName = new HashMap(10000);
    private final TIntObjectHashMap<ClassID> classesByID = new TIntObjectHashMap(10000);
    private final File classIDFile;
    private int nextClassID = 1;
    private final TIntObjectHashMap<TIntHashSet> subclassesBySuperclass = new TIntObjectHashMap(100);

    public ClassIDs(File classIDsFile) throws IOException {
        this.classIDFile = classIDsFile;
        BufferedReader reader = null;
        if (this.classIDFile.isFile()) {
            reader = new BufferedReader(new FileReader(this.classIDFile));
            if (this.classIDFile.length() > 0L) {
                String entry;
                while ((entry = reader.readLine()) != null) {
                    ClassID id = new ClassID(entry);
                    if (this.classesByID.containsKey(id.id)) {
                        throw new RuntimeException("This classid cache is corrupt! " + this.classesByID.get(id.id) + " is already assigned id " + id);
                    }
                    this.classesByName.put(id.name, id);
                    this.classesByID.put(id.id, id);
                    if (id.id <= this.nextClassID) continue;
                    this.nextClassID = id.id;
                }
                ++this.nextClassID;
            }
        } else {
            throw new IOException("Couldn't find file " + classIDsFile);
        }
        reader.close();
        this.subclassesOfTextualOutputProducers = new TIntHashSet();
        this.subclassesOfTextualOutputProducers.add(QualifiedClassName.STRING_BUILDER.getID());
        this.subclassesOfTextualOutputProducers.addAll(this.getSubclassesOf(QualifiedClassName.STRING_BUILDER).toArray());
        this.subclassesOfTextualOutputProducers.add(QualifiedClassName.OUTPUT_STREAM.getID());
        this.subclassesOfTextualOutputProducers.addAll(this.getSubclassesOf(QualifiedClassName.OUTPUT_STREAM).toArray());
        this.subclassesOfTextualOutputProducers.add(QualifiedClassName.WRITER.getID());
        this.subclassesOfTextualOutputProducers.addAll(this.getSubclassesOf(QualifiedClassName.WRITER).toArray());
    }

    public boolean isOrIsSubclassOfTextualOutputProducer(QualifiedClassName name) {
        return this.subclassesOfTextualOutputProducers.contains(name.getID());
    }

    private ClassID getClassID(QualifiedClassName classname) {
        ClassID classID = this.classesByName.get(classname);
        if (classID == null) {
            int id = this.nextClassID++;
            if (this.nextClassID > MethodInstrumenter.MAXIMUM_CLASS_IDS) {
                throw new RuntimeException("Surpassed maximum number of classes supported by the Whyline: " + MethodInstrumenter.MAXIMUM_CLASS_IDS);
            }
            classID = new ClassID(classname, id);
            this.classesByName.put(classname, classID);
            this.classesByID.put(classID.id, classID);
        }
        return classID;
    }

    public void markClassnameAsInstrumented(QualifiedClassName classname) {
        this.getClassID((QualifiedClassName)classname).instrumented = true;
    }

    public void markMethodAsNotInstrumented(QualifiedClassName classname, String methodNameAndDescriptor) {
        ClassID classID = this.getClassID(classname);
        classID.uninstrumentedMethods.add(methodNameAndDescriptor);
    }

    public void markClassnameModificationDate(QualifiedClassName classname, long modificationDate) {
        ClassID classID = this.getClassID(classname);
        classID.updateModificationDate(modificationDate);
    }

    public long getModificationDateOfClassname(QualifiedClassName classname) {
        return this.getClassID(classname).lastModified;
    }

    public boolean classHasBeenUpdated(QualifiedClassName classname) {
        return this.getClassID((QualifiedClassName)classname).updated;
    }

    public QualifiedClassName getNameOfClassID(int classID) {
        return this.classesByID.get((int)classID).name;
    }

    public int getNumberOfClasses() {
        return this.nextClassID;
    }

    public synchronized int getIDOfClassname(QualifiedClassName classname) {
        return this.getClassID((QualifiedClassName)classname).id;
    }

    public boolean classWasInstrumented(QualifiedClassName classname) {
        return this.getClassID((QualifiedClassName)classname).instrumented;
    }

    public boolean methodWasInstrumented(QualifiedClassName classname, String methodNameAndDescriptor) {
        return !this.getClassID((QualifiedClassName)classname).uninstrumentedMethods.contains(methodNameAndDescriptor);
    }

    public void includeClassName(QualifiedClassName classname) {
        if (classname == null) {
            throw new NullPointerException("Can't get the class id of null");
        }
        this.getClassID(classname);
    }

    public void markSuperclass(QualifiedClassName classname, QualifiedClassName superclass) {
        this.getClassID((QualifiedClassName)classname).superclass = superclass;
    }

    public QualifiedClassName getBaseClassOf(QualifiedClassName name) {
        ClassID cid = this.getClassID(name);
        return cid == null || cid.superclass == null || cid.superclass == QualifiedClassName.JAVA_LANG_OBJECT ? name : this.getBaseClassOf(cid.superclass);
    }

    public TIntHashSet getSubclassesOf(QualifiedClassName superclass) {
        TIntHashSet subclasses = this.subclassesBySuperclass.get(superclass.getID());
        if (subclasses == null) {
            subclasses = new TIntHashSet(7);
            this.subclassesBySuperclass.put(superclass.getID(), subclasses);
            Object[] objectArray = this.classesByID.getValues();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                ClassID classID = (ClassID)o;
                if (this.isOrIsSubclassOfHelper(classID.name, superclass)) {
                    subclasses.add(classID.name.getID());
                }
                ++n2;
            }
        }
        return subclasses;
    }

    private boolean isOrIsSubclassOfHelper(QualifiedClassName name, QualifiedClassName potentialSuperclass) {
        if (name == null) {
            return false;
        }
        if (name == potentialSuperclass) {
            return true;
        }
        return this.isOrIsSubclassOfHelper(this.getClassID((QualifiedClassName)name).superclass, potentialSuperclass);
    }

    public boolean isOrIsSubclassOf(QualifiedClassName name, QualifiedClassName superclass) {
        if (name == null) {
            return false;
        }
        if (name == superclass) {
            return true;
        }
        TIntHashSet subclasses = this.getSubclassesOf(superclass);
        return subclasses.contains(name.getID());
    }

    public synchronized void write() throws IOException {
        if (this.classIDFile.exists() && !this.classIDFile.delete()) {
            throw new IOException("Unable to delete the class IDs file.");
        }
        this.classIDFile.createNewFile();
        FileWriter writer = new FileWriter(this.classIDFile);
        try {
            for (ClassID classID : this.classesByName.values()) {
                writer.write(classID.toString());
                writer.write("\n");
            }
            writer.close();
        }
        finally {
            writer.close();
        }
    }

    private class ClassID {
        public final QualifiedClassName name;
        public QualifiedClassName superclass = null;
        public final int id;
        private long lastModified = 0L;
        public boolean updated = false;
        public boolean instrumented = false;
        public final Set<String> uninstrumentedMethods = new HashSet<String>();

        public ClassID(QualifiedClassName name, int id) {
            this.name = name;
            this.id = id;
        }

        public ClassID(String line) throws IOException {
            String[] breaks = spacePattern.split(line);
            if (breaks.length < 5) {
                throw new IOException("Class ID format error; there was missing data at line " + line);
            }
            this.name = QualifiedClassName.get(breaks[0]);
            this.superclass = breaks[1].equals("null") ? null : QualifiedClassName.get(breaks[1]);
            this.id = Integer.parseInt(breaks[2]);
            this.instrumented = Boolean.parseBoolean(breaks[3]);
            this.lastModified = Long.parseLong(breaks[4]);
            int i = 5;
            while (i < breaks.length) {
                this.uninstrumentedMethods.add(breaks[i]);
                ++i;
            }
        }

        public void updateModificationDate(long time) {
            if (this.lastModified != time) {
                this.updated = true;
            }
            this.lastModified = time;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.name.getText());
            builder.append(" ");
            builder.append(this.superclass == null ? "null" : this.superclass.getText());
            builder.append(" ");
            builder.append(this.id);
            builder.append(" ");
            builder.append(this.instrumented);
            builder.append(" ");
            builder.append(this.lastModified);
            for (String method : this.uninstrumentedMethods) {
                builder.append(" ");
                builder.append(method);
            }
            return builder.toString();
        }
    }
}

