/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.tracing;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class AgentOptions {
    public static String REPLACEMENT_FOR_SPACES_IN_AGENT_OPTIONS = "#space#";
    public static String REPLACEMENT_FOR_COMMAS_IN_AGENT_OPTIONS = "#comma#";
    public static String REPLACEMENT_FOR_NEWLINES_IN_AGENT_OPTIONS = "#newline#";
    private final Map<Option, Object> options = new HashMap<Option, Object>();

    public AgentOptions(String projectPath, String classPaths, String sourcePaths) {
        this.setOption(Option.PROJECT, projectPath);
        this.setOption(Option.CLASSES, classPaths);
        this.setOption(Option.SOURCE, sourcePaths);
    }

    public AgentOptions(String optionsString) {
        if (optionsString != null && optionsString.length() > 0) {
            String[] options;
            String[] stringArray = options = optionsString.split(",");
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                String optionString = stringArray[n2];
                String[] propertyValuePair = optionString.split("=");
                assert (propertyValuePair.length == 2) : "This agent options string is corruped; this text, " + optionString + ", has more than two = signs.";
                Option option = Option.valueOf(propertyValuePair[0]);
                assert (option != null) : "Don't know of an option named " + propertyValuePair[0];
                String valueString = propertyValuePair.length > 1 ? propertyValuePair[1] : "";
                valueString = valueString.replace(REPLACEMENT_FOR_SPACES_IN_AGENT_OPTIONS, " ");
                valueString = valueString.replace(REPLACEMENT_FOR_COMMAS_IN_AGENT_OPTIONS, ",");
                valueString = valueString.replace(REPLACEMENT_FOR_NEWLINES_IN_AGENT_OPTIONS, "\n");
                Object value = null;
                if (option.type == String.class) {
                    value = valueString;
                } else if (option.type == Boolean.class) {
                    value = Boolean.parseBoolean(valueString);
                } else {
                    throw new RuntimeException("Only support Booleans and Strings for property values, but you gave me " + value);
                }
                this.setOption(option, value);
                ++n2;
            }
        }
    }

    public void setOption(Option option, Object value) {
        if (option.type != Object.class && !option.type.isAssignableFrom(value.getClass())) {
            throw new RuntimeException("Illegal value for option named " + (Object)((Object)option) + "; it expects a " + option.type);
        }
        this.options.put(option, value);
    }

    public Object getOption(Option option) {
        if (!this.options.containsKey((Object)option)) {
            throw new RuntimeException("The agent option " + (Object)((Object)option) + " hasn't been passed in. It's purpose is " + option.purpose);
        }
        return this.options.get((Object)option);
    }

    public boolean declaresOption(Option option) {
        return this.options.containsKey((Object)option);
    }

    public String getOptionsAsValidCommandLineArgument() {
        StringBuilder optionsString = new StringBuilder();
        Iterator<Option> optionIterator = this.options.keySet().iterator();
        while (optionIterator.hasNext()) {
            Option option = optionIterator.next();
            optionsString.append(option.toString());
            optionsString.append("=");
            Object value = this.options.get((Object)option);
            String valueString = "" + value;
            valueString = valueString.replace(" ", REPLACEMENT_FOR_SPACES_IN_AGENT_OPTIONS);
            valueString = valueString.replace(",", REPLACEMENT_FOR_COMMAS_IN_AGENT_OPTIONS);
            valueString = valueString.replace("\n", REPLACEMENT_FOR_NEWLINES_IN_AGENT_OPTIONS);
            optionsString.append(valueString);
            if (!optionIterator.hasNext()) continue;
            optionsString.append(',');
        }
        return optionsString.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        PROJECT(String.class, "The root folder for the project being recorded, containing the classes and source. It's used to help specify other paths in the agent options relatively rather than absolutely."),
        CLASSES(String.class, "The path to the root of the recorded program's classes (or jar file)"),
        SOURCE(String.class, "The path to the root of the recorded program's source"),
        SKIP(String.class, "A list of#newline# separated package and class name prefixes (since newlines aren't allowed in the command line string)"),
        PRINT_INSTRUMENTATION_EVENTS(Boolean.class, "optional flag to print debug info for instrumentation events"),
        PRINT_INSTRUMENTATION_SUMMARY(Boolean.class, "optional flag to print summaries for each instrumented class"),
        PRINT_METHODS_BEFORE_AND_AFTER(Boolean.class, "optional flag to print before and after events for each instrument");

        public final Class<?> type;
        public final String purpose;

        private Option(Class<?> type, String purpose) {
            this.type = type;
            this.purpose = purpose;
        }

        public final String toString() {
            return super.toString();
        }
    }
}

