/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace.nodes;

import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.trace.nodes.DynamicNode;
import edu.cmu.hcii.whyline.trace.nodes.FrameState;
import gnu.trove.TIntObjectHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadState
extends DynamicNode<FrameState>
implements Comparable<ThreadState> {
    private final TIntObjectHashMap<FrameState> frames = new TIntObjectHashMap();
    private final Trace trace;
    private final int threadID;
    private int currentEventID = -1;

    public ThreadState(Trace trace, int threadID) {
        this.trace = trace;
        this.threadID = threadID;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.trace.getThreadName(this.threadID);
    }

    @Override
    public int compareTo(ThreadState object) {
        int names = this.getName().compareTo(object.getName());
        if (this.currentEventID < 0) {
            return names;
        }
        if (this.trace.getThreadID(this.currentEventID) == this.threadID) {
            return Integer.MIN_VALUE;
        }
        return names;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    private FrameState createFrame(int startID, int invocationID) {
        FrameState frame = this.frames.get(startID);
        if (frame == null) {
            frame = new FrameState(this.trace, startID, invocationID);
            this.frames.put(startID, frame);
        }
        return frame;
    }

    @Override
    protected void determineChildren() {
        int eventID = this.currentEventID;
        eventID = this.trace.getThreadEventIDNearest(this.threadID, eventID);
        while (eventID >= 0) {
            int invocationID;
            int startID = this.trace.getStartID(eventID);
            if (startID < 0) break;
            FrameState frame = this.createFrame(startID, eventID);
            frame.showEventID(this.currentEventID);
            this.addChild(frame);
            eventID = invocationID = this.trace.getStartIDsInvocationID(startID);
        }
    }

    public int getThreadID() {
        return this.threadID;
    }

    public void showEventID(int eventID) {
        if (this.currentEventID != eventID) {
            this.currentEventID = eventID;
            this.resetChildren();
            for (FrameState frame : this.getChildren()) {
                frame.showEventID(eventID);
            }
        }
    }

    public FrameState getFrameFor(int eventID) {
        return this.frames.get(this.trace.getStartID(eventID));
    }

    @Override
    public int getAssociatedEventID() {
        return this.trace.getThreadFirstEventID(this.threadID);
    }

    @Override
    public String getAssociatedEventIDDescription() {
        return "thread start";
    }

    @Override
    protected boolean performUpdate() {
        return false;
    }
}

