/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace.nodes;

import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.trace.Value;
import edu.cmu.hcii.whyline.trace.nodes.ArrayElementSeriesState;
import edu.cmu.hcii.whyline.trace.nodes.ReferenceState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayElementState
extends ReferenceState
implements Comparable<ArrayElementState> {
    private final ArrayElementSeriesState series;
    private final int index;
    private int definitionID;
    private long valueID = 0L;
    private Value currentValue = null;

    public ArrayElementState(ArrayElementSeriesState series, int index) {
        super(series.getTrace(), series.getArrayID());
        this.series = series;
        this.index = index;
    }

    @Override
    public long getObjectIDForChildren() {
        if (this.isPrimitiveArray()) {
            return 0L;
        }
        int assignmentID = this.trace.getArrayAssignmentHistory().getIndexAssignmentBefore(this.series.getArrayID(), this.index, this.currentEventID);
        if (assignmentID < 0) {
            return 0L;
        }
        Value value = this.trace.getDefinitionValueSet(assignmentID);
        if (value == null || value.getLong() == 0L) {
            return 0L;
        }
        return value.getLong();
    }

    @Override
    public boolean isLeaf() {
        return this.getObjectIDForChildren() <= 0L;
    }

    public boolean isPrimitiveArray() {
        return this.series.getType().getArrayElementClassname().isPrimitive();
    }

    @Override
    protected boolean performUpdate() {
        EventKind kind;
        long oldValueID = this.valueID;
        this.currentValue = null;
        this.valueID = -1L;
        this.definitionID = this.trace.getArrayAssignmentHistory().getIndexAssignmentBefore(this.series.getArrayID(), this.index, this.currentEventID);
        if (this.definitionID > 0 && (kind = this.trace.getKind(this.definitionID)) == EventKind.SETARRAY) {
            this.currentValue = this.trace.getDefinitionValueSet(this.definitionID);
        }
        if (this.valueID != oldValueID) {
            this.resetChildren();
        }
        return true;
    }

    @Override
    public int getAssociatedEventID() {
        return -1;
    }

    @Override
    public String getAssociatedEventIDDescription() {
        return "value";
    }

    @Override
    public int compareTo(ArrayElementState o) {
        return this.index - o.index;
    }

    @Override
    public String toString() {
        String name = "[" + this.index + "]";
        if (!this.isInstantiated()) {
            return "<html><strike>" + name + "</strike>";
        }
        String value = this.isUpdated() ? (this.currentValue == null ? "<b>default</b>" : "<b>" + this.currentValue.getDisplayName(true) + "</b>") : "...";
        return "<html>" + name + " = " + value;
    }
}

