/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace;

import edu.cmu.hcii.whyline.qa.Answer;
import edu.cmu.hcii.whyline.qa.NoExplanationAnswer;
import edu.cmu.hcii.whyline.qa.Question;
import edu.cmu.hcii.whyline.trace.NoValueException;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.trace.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnknownValue
extends Value {
    private final int consumerID;
    private final Reason reason;

    public UnknownValue(Trace trace, int consumerID, Reason reason) {
        super(trace);
        this.consumerID = consumerID;
        this.reason = reason;
    }

    @Override
    public boolean getBoolean() throws NoValueException {
        throw new NoValueException(this.trace, this.consumerID, "");
    }

    @Override
    public int getInteger() throws NoValueException {
        throw new NoValueException(this.trace, this.consumerID, "");
    }

    @Override
    public long getLong() {
        return -1L;
    }

    @Override
    public float getFloat() throws NoValueException {
        throw new NoValueException(this.trace, this.consumerID, "");
    }

    @Override
    public double getDouble() throws NoValueException {
        throw new NoValueException(this.trace, this.consumerID, "");
    }

    @Override
    public Object getValue() throws NoValueException {
        throw new NoValueException(this.trace, this.consumerID, "");
    }

    @Override
    public Object getImmutable() throws NoValueException {
        throw new NoValueException(this.trace, this.consumerID, "");
    }

    @Override
    public boolean isObject() {
        return false;
    }

    @Override
    public String getVerbalExplanation() {
        return "<b>[unknown]</b>";
    }

    @Override
    public String getDisplayName(boolean html) {
        return "[unknown]";
    }

    public String getReasonNotFound() {
        return this.reason.reason;
    }

    @Override
    public int getEventID() {
        return -1;
    }

    @Override
    public boolean hasEventID() {
        return false;
    }

    public String toString() {
        return "UnknownStackValue " + (Object)((Object)this.reason);
    }

    @Override
    public Answer getAnswer(Question<?> q) {
        return new NoExplanationAnswer(q, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Reason {
        JSR_ARGUMENT("Value is address pushed by JSR"),
        THIS_NOT_RECORDED("Couldn't find set argument event for 'this' , or the argument passed in."),
        PLACEHOLDER_WITH_NO_VALUE("Found placeholder event but it didn't have a value for some reason."),
        PLACEHOLDER_WITH_NO_CORRESPONDING("Found placeholder event  but didn't find corresponding instantiation."),
        NO_PLACEHOLDER("Couldn't find placeholder for instantion: "),
        NO_INVOCATION_INSTANCE("Found the invocation, but didn't find the producer of the first argument."),
        UNKNOWN("Don't know a reason whyline I couldn't explain."),
        NO_EXCEPTION_SOURCE("Couldn't find source of exception."),
        NO_INCREMENT("Couldn't find increment value.");

        private final String reason;

        private Reason(String reason) {
            this.reason = reason;
        }
    }
}

