/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace;

import edu.cmu.hcii.whyline.Whyline;
import edu.cmu.hcii.whyline.analysis.AffectsOutputAnalyzer;
import edu.cmu.hcii.whyline.analysis.AnalysisException;
import edu.cmu.hcii.whyline.bytecode.ALOAD_0;
import edu.cmu.hcii.whyline.bytecode.Branch;
import edu.cmu.hcii.whyline.bytecode.ClassInfo;
import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.CodeAttribute;
import edu.cmu.hcii.whyline.bytecode.ConstantPoolInfo;
import edu.cmu.hcii.whyline.bytecode.Definition;
import edu.cmu.hcii.whyline.bytecode.Duplication;
import edu.cmu.hcii.whyline.bytecode.ExceptionHandler;
import edu.cmu.hcii.whyline.bytecode.FieldInfo;
import edu.cmu.hcii.whyline.bytecode.FieldrefContainer;
import edu.cmu.hcii.whyline.bytecode.FieldrefInfo;
import edu.cmu.hcii.whyline.bytecode.GETFIELD;
import edu.cmu.hcii.whyline.bytecode.GETSTATIC;
import edu.cmu.hcii.whyline.bytecode.GetArrayValue;
import edu.cmu.hcii.whyline.bytecode.GetLocal;
import edu.cmu.hcii.whyline.bytecode.IADD;
import edu.cmu.hcii.whyline.bytecode.IINC;
import edu.cmu.hcii.whyline.bytecode.INVOKEINTERFACE;
import edu.cmu.hcii.whyline.bytecode.INVOKESPECIAL;
import edu.cmu.hcii.whyline.bytecode.INVOKESTATIC;
import edu.cmu.hcii.whyline.bytecode.INVOKEVIRTUAL;
import edu.cmu.hcii.whyline.bytecode.Instantiation;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.bytecode.JSR;
import edu.cmu.hcii.whyline.bytecode.JSR_W;
import edu.cmu.hcii.whyline.bytecode.JavaSpecificationViolation;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.MethodrefInfo;
import edu.cmu.hcii.whyline.bytecode.NEW;
import edu.cmu.hcii.whyline.bytecode.PUTFIELD;
import edu.cmu.hcii.whyline.bytecode.PUTSTATIC;
import edu.cmu.hcii.whyline.bytecode.PushConstant;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.bytecode.RETURN;
import edu.cmu.hcii.whyline.bytecode.SetLocal;
import edu.cmu.hcii.whyline.bytecode.StackDependencies;
import edu.cmu.hcii.whyline.bytecode.StackDependenciesCache;
import edu.cmu.hcii.whyline.bytecode.Use;
import edu.cmu.hcii.whyline.io.CreateGraphicsParser;
import edu.cmu.hcii.whyline.io.GetGraphicsParser;
import edu.cmu.hcii.whyline.io.GraphicalOutputEvent;
import edu.cmu.hcii.whyline.io.GraphicalOutputParser;
import edu.cmu.hcii.whyline.io.IOEvent;
import edu.cmu.hcii.whyline.io.IOHistory;
import edu.cmu.hcii.whyline.io.InputEvent;
import edu.cmu.hcii.whyline.io.KeyInputParser;
import edu.cmu.hcii.whyline.io.KeyStateInputEvent;
import edu.cmu.hcii.whyline.io.MouseInputParser;
import edu.cmu.hcii.whyline.io.MouseStateInputEvent;
import edu.cmu.hcii.whyline.io.OutputEvent;
import edu.cmu.hcii.whyline.io.RenderEvent;
import edu.cmu.hcii.whyline.io.TextualOutputEvent;
import edu.cmu.hcii.whyline.io.TextualOutputParser;
import edu.cmu.hcii.whyline.io.WindowParser;
import edu.cmu.hcii.whyline.io.WindowState;
import edu.cmu.hcii.whyline.io.WindowVisibilityOutputEvent;
import edu.cmu.hcii.whyline.qa.Explanation;
import edu.cmu.hcii.whyline.source.JavaSourceFile;
import edu.cmu.hcii.whyline.trace.ArrayHistory;
import edu.cmu.hcii.whyline.trace.CallStack;
import edu.cmu.hcii.whyline.trace.ClassInitializationHistory;
import edu.cmu.hcii.whyline.trace.ConstantValue;
import edu.cmu.hcii.whyline.trace.CreateGraphicsArguments;
import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.trace.ExceptionHistory;
import edu.cmu.hcii.whyline.trace.FieldAssignmentHistory;
import edu.cmu.hcii.whyline.trace.ImageData;
import edu.cmu.hcii.whyline.trace.ImmutableKind;
import edu.cmu.hcii.whyline.trace.IncrementValue;
import edu.cmu.hcii.whyline.trace.InstantiationHistory;
import edu.cmu.hcii.whyline.trace.InvocationHistory;
import edu.cmu.hcii.whyline.trace.JDKSource;
import edu.cmu.hcii.whyline.trace.KeyArguments;
import edu.cmu.hcii.whyline.trace.MouseArguments;
import edu.cmu.hcii.whyline.trace.NoValueException;
import edu.cmu.hcii.whyline.trace.RepaintArguments;
import edu.cmu.hcii.whyline.trace.StaticVariableAssignmentHistory;
import edu.cmu.hcii.whyline.trace.ThreadMetaData;
import edu.cmu.hcii.whyline.trace.ThreadStartHistory;
import edu.cmu.hcii.whyline.trace.TraceListener;
import edu.cmu.hcii.whyline.trace.TraceMetaData;
import edu.cmu.hcii.whyline.trace.TraceValue;
import edu.cmu.hcii.whyline.trace.UnknownValue;
import edu.cmu.hcii.whyline.trace.Value;
import edu.cmu.hcii.whyline.trace.nodes.FieldState;
import edu.cmu.hcii.whyline.trace.nodes.ObjectState;
import edu.cmu.hcii.whyline.tracing.ClassIDs;
import edu.cmu.hcii.whyline.util.IntegerRange;
import edu.cmu.hcii.whyline.util.IntegerVector;
import edu.cmu.hcii.whyline.util.Saveable;
import edu.cmu.hcii.whyline.util.Util;
import gnu.trove.TIntByteHashMap;
import gnu.trove.TIntDoubleHashMap;
import gnu.trove.TIntFloatHashMap;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntLongHashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import gnu.trove.TIntShortHashMap;
import gnu.trove.TLongIntHashMap;
import gnu.trove.TLongObjectHashMap;
import gnu.trove.TLongObjectIterator;
import gnu.trove.TObjectLongHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Trace {
    private static final boolean PRINT_PERF = false;
    private static final int EVENTS_PER_BLOCK = 4096;
    private static final int STACK_DEPENDENCIES_CACHE_SIZE = 8192;
    private static final int BYTES_PER_EVENT = 7;
    private static final double FRACTION_OF_MEMORY_FOR_BLOCKS = 0.25;
    private static final int THREAD_ID_CACHE_SIZE = Short.MAX_VALUE;
    private final File TRACE_FOLDER;
    private final File IDS_FOLDER;
    private final File CALLS_FOLDER;
    private final File VALUES_FOLDER;
    private final File SERIAL_THREAD_TRACES_FOLDER;
    private final File SOURCE_FOLDER;
    private final File CLASSNAMES;
    private final File IMMUTABLES;
    private final File META;
    private final File CLASSIDS;
    private final File OBJECTTYPES;
    private final File CALL_GRAPH;
    private final boolean callGraphIsCached;
    private final File OUTPUT;
    private final boolean outputIsCached;
    private boolean doneLoading = false;
    private boolean isLoadingSerial = true;
    private boolean canceled = false;
    private TraceMetaData metadata;
    private final ClassIDs classIDs;
    private final Map<QualifiedClassName, Classfile> classesByName = new HashMap<QualifiedClassName, Classfile>();
    private TIntObjectHashMap<Classfile> classfilesByID;
    private final HashSet<String> familiarMethods = new HashSet();
    private final HashSet<String> familiarFields = new HashSet();
    private final HashSet<QualifiedClassName> familiarClasses = new HashSet();
    private final SortedSet<String> userSourceFiles = new TreeSet<String>();
    private final Map<String, MethodInfo[]> methodsByQualifiedSignature = new HashMap<String, MethodInfo[]>();
    private final Map<String, JavaSourceFile> sourceByQualifiedName = new TreeMap<String, JavaSourceFile>();
    private final Map<String, Set<Classfile>> classesWaitingForSourceByQualifiedSourceFileName = new HashMap<String, Set<Classfile>>();
    private ThreadTrace[] threads;
    private Blocks<IDBlock> idBlocks;
    private Blocks<ValueBlock> valueBlocks;
    private Blocks<CallsBlock> callBlocks;
    private final TLongObjectHashMap<ImageData> imageData = new TLongObjectHashMap();
    private final TIntObjectHashMap<KeyArguments> keyArguments = new TIntObjectHashMap();
    private final TIntObjectHashMap<MouseArguments> mouseArguments = new TIntObjectHashMap();
    private final TIntObjectHashMap<RepaintArguments> repaintArguments = new TIntObjectHashMap();
    private final TIntObjectHashMap<CreateGraphicsArguments> createGraphicsArguments = new TIntObjectHashMap();
    private final TLongObjectHashMap<Object> immutablesByID = new TLongObjectHashMap(10000);
    private final TObjectLongHashMap<Object> idsOfImmutables = new TObjectLongHashMap(10000);
    private TLongIntHashMap objectTypes;
    private final ExceptionHistory exceptionHistory = new ExceptionHistory(this);
    private final StaticVariableAssignmentHistory staticAssignmentHistory = new StaticVariableAssignmentHistory(this);
    private final FieldAssignmentHistory fieldAssignmentHistory = new FieldAssignmentHistory(this);
    private final ArrayHistory arrayHistory = new ArrayHistory(this);
    private InstantiationHistory instantiationHistory;
    private final ClassInitializationHistory initializationHistory = new ClassInitializationHistory(this);
    private final ThreadStartHistory runHistory = new ThreadStartHistory(this);
    private InvocationHistory invocationHistory;
    private final TLongObjectHashMap<ObjectState> objects = new TLongObjectHashMap();
    private final TLongObjectHashMap<Map<String, FieldState>> fields = new TLongObjectHashMap();
    private final ArrayList<Instruction> textualOutput = new ArrayList(1000);
    private final ArrayList<Instruction> graphicalOutput = new ArrayList(1000);
    private SortedSet<Classfile> windowClasses;
    private Map<Classfile, Map<MethodInfo, Set<Instruction>>> textualOutputByMethodByClass = new HashMap<Classfile, Map<MethodInfo, Set<Instruction>>>();
    private Map<Classfile, Map<MethodInfo, Set<Instruction>>> graphicalOutputByMethodByClass = new HashMap<Classfile, Map<MethodInfo, Set<Instruction>>>();
    private Collection<FieldInfo> outputAffectingFields;
    private Collection<MethodInfo> outputAffectingMethods;
    private Collection<MethodInfo> outputInvokingMethods;
    private Set<Classfile> outputInvokingClasses = new HashSet<Classfile>(10);
    private Map<QualifiedClassName, List<Instantiation>> allocationsByClass = new HashMap<QualifiedClassName, List<Instantiation>>(1000);
    private ArrayList<Invoke> invocations = new ArrayList(10000);
    private int numberOfMethods = 0;
    private int numberOfFields = 0;
    private int numberOfInvocationInstructions = 0;
    private int numberOfInstructions = 0;
    private IOHistory<IOEvent> ioHistory = new IOHistory(null, this);
    private IOHistory<InputEvent> inputHistory = new IOHistory<IOEvent>(this.ioHistory, this);
    private IOHistory<OutputEvent> outputHistory = new IOHistory<IOEvent>(this.ioHistory, this);
    private IOHistory<GraphicalOutputEvent> graphicsHistory = new IOHistory<OutputEvent>(this.outputHistory, this);
    private IOHistory<RenderEvent> renderHistory = new IOHistory<GraphicalOutputEvent>(this.graphicsHistory, this);
    private IOHistory<TextualOutputEvent> printsHistory = new IOHistory<OutputEvent>(this.outputHistory, this);
    private IOHistory<MouseStateInputEvent> mouseHistory = new IOHistory<InputEvent>(this.inputHistory, this);
    private IOHistory<KeyStateInputEvent> keyHistory = new IOHistory<InputEvent>(this.inputHistory, this);
    private IOHistory<WindowVisibilityOutputEvent> windowHistory = new IOHistory<OutputEvent>(this.outputHistory, this);
    private List<WindowState> windows = new ArrayList<WindowState>(3);
    private final TIntIntHashMap controlIDs = new TIntIntHashMap();
    private final TIntObjectHashMap<Value[]> arguments = new TIntObjectHashMap(1000);
    private IntegerVector[] previousLocalAssignmentCache = null;
    private int previousLocalAssignmentCacheStartID = -1;
    private int lastEventIDCachedForLocalAssignment = -1;
    private TIntIntHashMap threadIDCache = new TIntIntHashMap(1024);
    private final StackDependenciesCache stackDependenciesCache = new StackDependenciesCache(){
        private final LinkedList<MethodInfo> recent = new LinkedList();
        private final HashMap<MethodInfo, StackDependencies> cache = new HashMap(8192);

        public synchronized StackDependencies getStackDependenciesFor(MethodInfo method) throws AnalysisException {
            MethodInfo first;
            if (this.recent.size() > 8192 && (first = this.recent.getFirst()) != method) {
                this.cache.remove(this.recent.removeFirst());
            }
            this.recent.add(method);
            StackDependencies dependencies = this.cache.get(method);
            if (dependencies == null && method.getCode() != null) {
                dependencies = new StackDependencies(method.getCode());
                this.cache.put(method, dependencies);
                dependencies.analyze();
            }
            return dependencies;
        }
    };
    private final TraceListener listener;
    private final SortedSet<Explanation> narrative = new TreeSet<Explanation>();
    private final TIntLongHashMap invocationInstanceIDByInvocation = new TIntLongHashMap(100000);

    public Trace(TraceListener listener, File traceDirectory) throws IOException {
        this.listener = listener;
        this.TRACE_FOLDER = traceDirectory;
        this.IDS_FOLDER = new File(this.TRACE_FOLDER, Whyline.IDS_PATH);
        this.IDS_FOLDER.mkdirs();
        this.CALLS_FOLDER = new File(this.TRACE_FOLDER, Whyline.CALLS_PATH);
        this.CALLS_FOLDER.mkdirs();
        this.VALUES_FOLDER = new File(this.TRACE_FOLDER, Whyline.VALUES_PATH);
        this.VALUES_FOLDER.mkdirs();
        this.SERIAL_THREAD_TRACES_FOLDER = new File(traceDirectory, Whyline.SERIAL_PATH);
        this.SOURCE_FOLDER = new File(this.TRACE_FOLDER, Whyline.SOURCE_PATH);
        this.CLASSNAMES = new File(this.TRACE_FOLDER, Whyline.CLASSNAMES_PATH);
        this.IMMUTABLES = new File(this.TRACE_FOLDER, Whyline.IMMUTABLES_PATH);
        this.META = new File(this.TRACE_FOLDER, "meta");
        this.CLASSIDS = new File(this.TRACE_FOLDER, Whyline.CLASSIDS_PATH);
        this.OBJECTTYPES = new File(this.TRACE_FOLDER, Whyline.OBJECT_TYPES_PATH);
        this.CALL_GRAPH = new File(this.getPath(), Whyline.CALL_GRAPH_PATH);
        this.callGraphIsCached = this.CALL_GRAPH.exists();
        this.OUTPUT = new File(this.getPath(), Whyline.OUTPUT_PATH);
        this.outputIsCached = this.OUTPUT.exists();
        File classids = new File(this.TRACE_FOLDER, Whyline.CLASSIDS_PATH);
        if (!classids.exists()) {
            throw new IOException("Couldn't find " + classids.getAbsolutePath());
        }
        this.classIDs = new ClassIDs(classids);
        this.classfilesByID = new TIntObjectHashMap(this.classIDs.getNumberOfClasses() * 2);
    }

    public void addWindow(WindowState window) {
        this.windows.add(window);
        if (this.listener != null) {
            this.listener.windowParsed(window);
        }
    }

    public ImageData getImageData(long imageID) {
        return this.imageData.get(imageID);
    }

    public File getPath() {
        return this.TRACE_FOLDER;
    }

    public boolean isSaved() {
        return !this.TRACE_FOLDER.getAbsolutePath().equals(Whyline.getWorkingTraceFolder().getAbsolutePath());
    }

    public int getNumberOfEvents() {
        return this.metadata == null ? 0 : this.metadata.getNumberOfEvents();
    }

    public int getNumberOfClasses() {
        return this.metadata == null ? 0 : this.metadata.getNumberOfClasses();
    }

    public Iterable<Classfile> getClasses() {
        return this.classesByName.values();
    }

    public Classfile getClassfileByName(QualifiedClassName name) {
        return this.classesByName.get(name);
    }

    public Classfile getClassfileByID(int id) {
        return this.classfilesByID.get(id);
    }

    public ClassIDs getClassIDs() {
        return this.classIDs;
    }

    public QualifiedClassName getNameOfClassID(int id) {
        return this.classIDs.getNameOfClassID(id);
    }

    public List<Classfile> getClassfiles() {
        Classfile[] classes = new Classfile[this.classfilesByID.size()];
        this.classfilesByID.getValues(classes);
        return Collections.unmodifiableList(Arrays.asList(classes));
    }

    public int getNumberOfMethods() {
        return this.numberOfMethods;
    }

    public int getNumberOfInstructions() {
        return this.numberOfInstructions;
    }

    public int getNumberOfFields() {
        return this.numberOfFields;
    }

    public int getNumberOfInvocationInstructions() {
        return this.numberOfInvocationInstructions;
    }

    public boolean classOrSubclassIsReferencedInFamiliarSourceFile(QualifiedClassName classname) {
        Classfile cf = this.getClassfileByName(classname);
        assert (cf != null) : "Why couldn't we find the classfile for " + classname;
        if (this.classIsReferencedInFamiliarSourceFile(cf.getInternalName())) {
            return true;
        }
        for (Classfile subclass : cf.getAllSubclasses()) {
            if (!this.classIsReferencedInFamiliarSourceFile(subclass.getInternalName())) continue;
            return true;
        }
        return false;
    }

    public boolean classIsReferencedInFamiliarSourceFile(QualifiedClassName classname) {
        return classname.referencedInFamiliarClass();
    }

    public boolean methodIsReferencedInFamiliarSourceFile(String fullyQualifiedMethodName) {
        return this.familiarMethods.contains(fullyQualifiedMethodName);
    }

    public boolean fieldIsReferencedInFamiliarSourceFile(String fullyQualifiedFieldName) {
        return this.familiarFields.contains(fullyQualifiedFieldName);
    }

    public MethodInfo resolveMethodReference(QualifiedClassName classname, Invoke invoke) {
        Classfile classfile = this.getClassfileByName(invoke.getMethodInvoked().getClassName());
        MethodInfo method = null;
        MethodrefInfo methodref = invoke.getMethodInvoked();
        String nameAndDescriptor = methodref.getMethodNameAndDescriptor();
        if (classfile != null) {
            if (invoke instanceof INVOKEVIRTUAL) {
                Classfile classfileOfType = this.getClassfileByName(classname);
                if (classfileOfType != null) {
                    if (classfileOfType != classfile && !classfileOfType.isSubclassOf(classfile.getInternalName())) {
                        return null;
                    }
                    MethodInfo methodOfType = classfileOfType.getDeclaredMethodByNameAndDescriptor(nameAndDescriptor);
                    Classfile type = classfileOfType;
                    while (type.getSuperclass() != null && (methodOfType == null || methodOfType.isAbstract() || !methodOfType.isAccessibleFrom(classfileOfType))) {
                        type = type.getSuperclass();
                        methodOfType = type.getDeclaredMethodByNameAndDescriptor(nameAndDescriptor);
                    }
                    if (methodOfType != null && !methodOfType.isAbstract() && methodOfType.isAccessibleFrom(classfileOfType)) {
                        method = methodOfType;
                    }
                }
            } else if (invoke instanceof INVOKESPECIAL) {
                method = classfile.getDeclaredOrInheritedMethodByNameAndDescriptor(nameAndDescriptor);
                if (method != null && method.isProtected()) {
                    Classfile currentClass = invoke.getClassfile();
                    Classfile superClass = invoke.getClassfile().getSuperclass();
                    Classfile methodClass = method.getClassfile();
                    Classfile classfileOfType = this.getClassfileByName(classname);
                    if ((methodClass == currentClass || methodClass == superClass) && classfileOfType != currentClass && classfileOfType != superClass) {
                        method = null;
                    }
                }
            } else if (invoke instanceof INVOKEINTERFACE) {
                MethodInfo methodOfClassReferenced = classfile.getDeclaredOrInheritedMethodByNameAndDescriptor(nameAndDescriptor);
                Classfile classfileOfType = this.getClassfileByName(classname);
                if (classfileOfType != null) {
                    MethodInfo methodOfType = classfileOfType.getDeclaredMethodByNameAndDescriptor(nameAndDescriptor);
                    Classfile type = classfileOfType;
                    while (type.getSuperclass() != null && (methodOfType == null || methodOfType.isAbstract())) {
                        type = type.getSuperclass();
                        methodOfType = type.getDeclaredMethodByNameAndDescriptor(nameAndDescriptor);
                    }
                    if (methodOfType != null && !methodOfType.isAbstract()) {
                        method = methodOfType;
                    }
                }
            } else if (invoke instanceof INVOKESTATIC) {
                method = classfile.getDeclaredMethodByNameAndDescriptor(nameAndDescriptor);
            }
        }
        if (method != null) assert (!method.isAbstract()) : "Should not be returning abstract method\n\n" + method.getQualifiedNameAndDescriptor() + "\n\nwhen resolving " + invoke + "\n\non " + classname;
        return method;
    }

    public MethodInfo[] getMethodsFromReference(Invoke invoke) {
        HashSet<MethodInfo> methods;
        String qualifedSignature = invoke.getMethodInvoked().getQualfiedNameAndDescriptor();
        MethodInfo[] cachedMethods = this.methodsByQualifiedSignature.get(qualifedSignature);
        if (cachedMethods != null) {
            return cachedMethods;
        }
        MethodrefInfo methodref = invoke.getMethodInvoked();
        if (invoke instanceof INVOKESTATIC) {
            methods = new HashSet<MethodInfo>(1);
            MethodInfo method = this.resolveMethodReference(invoke.getMethodInvoked().getClassName(), invoke);
            if (method != null) {
                methods.add(method);
            }
        } else {
            Classfile classInvokedOn;
            MethodInfo m;
            methods = new HashSet(3);
            QualifiedClassName classNameInvokedOn = invoke.getMethodInvoked().getClassName();
            StackDependencies.Producers producersOfInstance = invoke.getProducersOfArgument(0);
            if (producersOfInstance.getNumberOfProducers() == 0) {
                List<ExceptionHandler> handlers = invoke.getCode().getExceptionHandlersThatExecute(invoke);
                for (ExceptionHandler handler : handlers) {
                    m = this.resolveMethodReference(handler.getCatchType().getName(), invoke);
                    if (m == null) continue;
                    methods.add(m);
                }
                classNameInvokedOn = null;
            } else if (producersOfInstance.getFirstProducer() instanceof GetLocal && ((GetLocal)producersOfInstance.getFirstProducer()).getLocalID() == 0) {
                classNameInvokedOn = invoke.getClassfile().getInternalName();
            }
            Classfile classfile = classInvokedOn = classNameInvokedOn == null ? null : this.getClassfileByName(classNameInvokedOn);
            if (classInvokedOn != null) {
                if (invoke instanceof INVOKEINTERFACE) {
                    for (Classfile classfile2 : classInvokedOn.getImplementors()) {
                        m = this.resolveMethodReference(classfile2.getInternalName(), invoke);
                        if (m != null) {
                            methods.add(m);
                        }
                        for (Classfile subclass : classfile2.getAllSubclasses()) {
                            m = this.resolveMethodReference(subclass.getInternalName(), invoke);
                            if (m == null) continue;
                            methods.add(m);
                        }
                    }
                } else if (invoke instanceof INVOKESPECIAL) {
                    Classfile superclass;
                    MethodInfo m2 = this.resolveMethodReference(classNameInvokedOn, invoke);
                    if (m2 != null) {
                        methods.add(m2);
                    }
                    if ((superclass = classInvokedOn.getSuperclass()) != null && (m2 = this.resolveMethodReference(superclass.getInternalName(), invoke)) != null) {
                        methods.add(m2);
                    }
                } else if (invoke instanceof INVOKEVIRTUAL) {
                    StackDependencies.Producers producers = invoke.getProducersOfArgument(0);
                    MethodInfo methodInvokedIn = invoke.getMethod();
                    boolean invokedOnTHIS = methodInvokedIn.isVirtual() && producers.getNumberOfProducers() == 1 && producers.getFirstProducer() instanceof GetLocal && ((GetLocal)producers.getFirstProducer()).getLocalID() == 0;
                    MethodInfo m3 = this.resolveMethodReference(classNameInvokedOn, invoke);
                    if (m3 != null) {
                        methods.add(m3);
                    }
                    for (Classfile subclass : classInvokedOn.getAllSubclasses()) {
                        MethodInfo overridingMethod;
                        m3 = this.resolveMethodReference(subclass.getInternalName(), invoke);
                        if (invokedOnTHIS && (overridingMethod = subclass.getDeclaredOrInheritedMethodByNameAndDescriptor(methodInvokedIn.getMethodNameAndDescriptor())) != null && overridingMethod != methodInvokedIn && !overridingMethod.callsSuper()) {
                            m3 = null;
                        }
                        if (m3 == null) continue;
                        methods.add(m3);
                    }
                }
            }
        }
        cachedMethods = new MethodInfo[methods.size()];
        methods.toArray(cachedMethods);
        this.methodsByQualifiedSignature.put(qualifedSignature, cachedMethods);
        return cachedMethods;
    }

    private void gatherOverridenMethods(Classfile classToCheck, Vector<MethodInfo> methods, String methodNameAndDescriptor) {
        MethodInfo match;
        for (Classfile subclass : classToCheck.getDirectSubclasses()) {
            match = subclass.getDeclaredMethodByNameAndDescriptor(methodNameAndDescriptor);
            if (match != null) {
                methods.add(match);
            }
            this.gatherOverridenMethods(subclass, methods, methodNameAndDescriptor);
        }
        for (Classfile implementor : classToCheck.getImplementors()) {
            match = implementor.getDeclaredMethodByNameAndDescriptor(methodNameAndDescriptor);
            if (match != null) {
                methods.add(match);
            }
            this.gatherOverridenMethods(implementor, methods, methodNameAndDescriptor);
        }
    }

    public FieldInfo resolveFieldReference(FieldrefInfo fieldref) {
        Classfile classfile = this.getClassfileByName(fieldref.getClassname());
        if (classfile == null) {
            return null;
        }
        FieldInfo field = classfile.getFieldByName(fieldref.getName());
        return field;
    }

    public MethodInfo getMain() {
        return this.metadata.getMain(this);
    }

    public Iterable<String> getMainArguments() {
        return this.metadata.getMainArguments();
    }

    public int getMainStartEventID() {
        IntegerVector mainIDs = this.invocationHistory.getStartIDsAfterEventID(this.getMain(), -1);
        return mainIDs.isEmpty() ? -1 : mainIDs.get(0);
    }

    public int getNumberOfThreads() {
        return this.metadata.getNumberOfThreads();
    }

    public int getNumberOfEventsInThread(int threadID) {
        return ((ThreadTrace)this.threads[threadID]).metadata.numberOfEventsInThread;
    }

    public String getThreadName(int threadID) {
        if (threadID < 0 || threadID >= this.threads.length) {
            throw new RuntimeException("Invalid threadID " + threadID + "; should be >= 0 and < " + this.threads.length);
        }
        return this.threads[threadID].getName();
    }

    private ThreadTrace getThreadLoaderFor(int eventID) {
        return this.threads[this.getThreadID(eventID)];
    }

    public CallStack getCallStack(int eventID) {
        return new CallStack(this, eventID);
    }

    public Iterable<JavaSourceFile> getAllSourceFiles() {
        for (String name : this.userSourceFiles) {
            this.getSourceByQualifiedName(name);
        }
        return this.sourceByQualifiedName.values();
    }

    public JavaSourceFile getSourceFor(Classfile c) {
        return c.hasSourceFileAttribute() ? this.getSourceByQualifiedName(c.getQualifiedSourceFileName()) : null;
    }

    public JavaSourceFile getFamiliarSourceByQualifiedName(String name) {
        return this.getSourceByQualifiedName(name, false);
    }

    public JavaSourceFile getSourceByQualifiedName(String name) {
        return this.getSourceByQualifiedName(name, true);
    }

    public boolean hasNonJDKSourceFor(Classfile c) {
        return this.userSourceFiles.contains(c.getQualifiedSourceFileName());
    }

    private JavaSourceFile getSourceByQualifiedName(String name, boolean searchJDK) {
        if (name == null) {
            return null;
        }
        JavaSourceFile source = this.sourceByQualifiedName.get(name);
        if (source == null) {
            File sourceFile = new File(this.SOURCE_FOLDER.getAbsolutePath(), name.replace('/', File.separatorChar));
            if (sourceFile.exists()) {
                try {
                    DataInputStream data = Util.getReaderFor(sourceFile);
                    byte[] bytes = new byte[(int)sourceFile.length()];
                    data.readFully(bytes);
                    data.close();
                    source = new JavaSourceFile(name, bytes, true);
                }
                catch (IOException data) {
                    // empty catch block
                }
            }
            if (source == null && searchJDK) {
                source = JDKSource.getSourceForQualifiedName(name);
            }
            if (source != null) {
                this.sourceByQualifiedName.put(name, source);
                Set<Classfile> unassociatedClasses = this.classesWaitingForSourceByQualifiedSourceFileName.get(name);
                if (unassociatedClasses != null) {
                    for (Classfile c : unassociatedClasses) {
                        source.linkClassfile(c);
                    }
                    this.classesWaitingForSourceByQualifiedSourceFileName.remove(name);
                }
                this.listener.additionalSourceLoaded(source);
            }
        }
        return source;
    }

    public boolean hasUserSourceFileFor(Classfile cf) {
        return cf.hasSourceFileAttribute() && this.userSourceFiles.contains(cf.getQualifiedSourceFileName());
    }

    public int getNumberOfUserSourceFiles() {
        return this.userSourceFiles.size();
    }

    public IOHistory<GraphicalOutputEvent> getGraphicsHistory() {
        return this.graphicsHistory;
    }

    public IOHistory<RenderEvent> getRenderHistory() {
        return this.renderHistory;
    }

    public IOHistory<TextualOutputEvent> getPrintHistory() {
        return this.printsHistory;
    }

    public IOHistory<MouseStateInputEvent> getMouseHistory() {
        return this.mouseHistory;
    }

    public IOHistory<KeyStateInputEvent> getKeyHistory() {
        return this.keyHistory;
    }

    public IOHistory<IOEvent> getIOHistory() {
        return this.ioHistory;
    }

    public IOHistory<InputEvent> getInputHistory() {
        return this.inputHistory;
    }

    public IOHistory<OutputEvent> getOutputHistory() {
        return this.outputHistory;
    }

    public boolean hasTextualOutputEvents() {
        return this.getPrintHistory().getNumberOfEvents() > 0;
    }

    public boolean hasGraphicalOutputEvents() {
        return this.getGraphicsHistory().getNumberOfEvents() > 0;
    }

    public boolean hasTextualOutputInstructions() {
        return this.textualOutput.size() > 0;
    }

    public boolean hasGraphicalOutputInstructions() {
        return this.graphicalOutput.size() > 0;
    }

    public Map<MethodInfo, Set<Instruction>> getTextualOutputByMethodForClass(Classfile classfile) {
        return this.textualOutputByMethodByClass.get(classfile);
    }

    public Map<MethodInfo, Set<Instruction>> getGraphicalOutputByMethodForClass(Classfile classfile) {
        return this.graphicalOutputByMethodByClass.get(classfile);
    }

    public List<Instruction> getTextualOutputInstructions() {
        return this.textualOutput;
    }

    public List<Instruction> getGraphicalOutputInstructions() {
        return this.graphicalOutput;
    }

    public Collection<FieldInfo> getOutputAffectingFields() {
        return this.outputAffectingFields;
    }

    public Collection<MethodInfo> getOutputAffectingMethods() {
        return this.outputAffectingMethods;
    }

    public Collection<MethodInfo> getOutputInvokingMethods() {
        return this.outputInvokingMethods;
    }

    public Collection<Classfile> getOutputInvokingClasses() {
        return this.outputInvokingClasses;
    }

    public Collection<Instruction> getTextualOutputInvokingInstructions() {
        HashMap<Instruction, Instruction> outputByFinalConsumer = new HashMap<Instruction, Instruction>(this.textualOutput.size());
        for (Instruction textOutput : this.getTextualOutputInstructions()) {
            Instruction firstTextConsumed;
            Instruction finalConsumer = textOutput.getFinalConsumer();
            if (finalConsumer == null || !(finalConsumer instanceof INVOKEVIRTUAL) || (firstTextConsumed = (Instruction)outputByFinalConsumer.get(finalConsumer)) != null && firstTextConsumed.getIndex() >= textOutput.getIndex()) continue;
            outputByFinalConsumer.put(finalConsumer, textOutput);
        }
        return outputByFinalConsumer.values();
    }

    public SortedSet<FieldInfo> getPublicOutputAffectingFieldsOf(Classfile classfile) {
        TreeSet<FieldInfo> publicOutputAffectingFields = new TreeSet<FieldInfo>();
        if (classfile != null) {
            for (FieldInfo field : classfile.getAllInstanceFields()) {
                if (!this.outputAffectingFields.contains(field) || !field.isPublic() && field.getSetters().isEmpty()) continue;
                publicOutputAffectingFields.add(field);
            }
        }
        return publicOutputAffectingFields;
    }

    public SortedSet<MethodInfo> getPublicOutputInvokingMethodsOf(Classfile classfile) {
        TreeSet<MethodInfo> methods = new TreeSet<MethodInfo>();
        for (MethodInfo method : classfile.getAllMethods()) {
            boolean isPublic = method.isPublic();
            if (!this.methodInvokesOutput(method) || !isPublic) continue;
            methods.add(method);
        }
        return methods;
    }

    public SortedSet<Classfile> getConcreteWindowClasses() {
        if (this.windowClasses == null) {
            this.windowClasses = new TreeSet<Classfile>();
            QualifiedClassName frame = QualifiedClassName.get("java/awt/Window");
            for (Classfile c : this.getClassfiles()) {
                if (!c.isSubclassOf(frame) || c.isAbstract()) continue;
                this.windowClasses.add(c);
            }
        }
        return Collections.unmodifiableSortedSet(this.windowClasses);
    }

    public boolean classInvokesOutput(Classfile classfile) {
        return this.outputInvokingClasses.contains(classfile);
    }

    private boolean methodInvokesOutput(MethodInfo method) {
        return this.outputInvokingMethods.contains(method) || method.getMethodOverriden() != null && this.methodInvokesOutput(method.getMethodOverriden());
    }

    public Object getImmutableObject(long objectID) {
        return this.immutablesByID.get(objectID);
    }

    public boolean isDoneLoading() {
        return this.doneLoading;
    }

    public void cancelLoading() {
        this.canceled = true;
    }

    public void load(int msPerNotification) throws IOException {
        new Loader(msPerNotification).start();
    }

    public List<Invoke> getInvocations() {
        return this.invocations;
    }

    public List<Instantiation> getInstantiationsOf(QualifiedClassName classname) {
        List<Instantiation> allocations = this.allocationsByClass.get(classname);
        if (allocations == null) {
            allocations = new ArrayList<Instantiation>(0);
            this.allocationsByClass.put(classname, allocations);
        }
        return allocations;
    }

    public boolean userCodeContainsInstantiationsOf(QualifiedClassName classname) {
        List<Instantiation> allocations = this.getInstantiationsOf(classname);
        for (Instantiation a : allocations) {
            if (!a.getClassfile().getInternalName().referencedInFamiliarClass()) continue;
            return true;
        }
        Classfile c = this.getClassfileByName(classname);
        if (c == null) {
            return false;
        }
        for (Classfile sub : c.getDirectSubclasses()) {
            if (!this.userCodeContainsInstantiationsOf(sub.getInternalName())) continue;
            return true;
        }
        for (Classfile implementor : c.getImplementors()) {
            if (!this.userCodeContainsInstantiationsOf(implementor.getInternalName())) continue;
            return true;
        }
        return false;
    }

    private IDBlock getIDBlock(int eventID) {
        return (IDBlock)((Blocks)this.idBlocks).getBlockContaining(eventID);
    }

    private ValueBlock getValueBlock(int eventID) {
        return (ValueBlock)((Blocks)this.valueBlocks).getBlockContaining(eventID);
    }

    private CallsBlock getCallsBlock(int eventID) {
        return (CallsBlock)((Blocks)this.callBlocks).getBlockContaining(eventID);
    }

    public int getInstructionIDFor(Instruction inst) {
        int classID = this.classIDs.getIDOfClassname(inst.getClassfile().getInternalName());
        int instructionID = inst.getMethod().getFirstInstructionID() + inst.getIndex();
        return classID << 18 | instructionID;
    }

    public Instruction getInstruction(int eventID) {
        return eventID < 0 ? null : this.getInstructionWithID(this.getInstructionID(eventID));
    }

    public Instruction getInstructionWithID(int classAndInstructionID) {
        int classID = classAndInstructionID >>> 18;
        int instructionID = classAndInstructionID << 14 >>> 14;
        Classfile classfile = this.getClassfileByID(classID);
        return classfile == null ? null : classfile.getInstructionByID(instructionID);
    }

    private int getDefinitionOfLocalIDBefore(int eventID, int localID) {
        IntegerVector[] assignmentIDsByLocalID;
        boolean cached;
        int startID = this.getStartID(eventID);
        assert (startID >= 0) : "Why couldn't we find a start ID for " + this.eventToString(eventID);
        boolean bl = cached = startID == this.previousLocalAssignmentCacheStartID;
        if (cached && eventID < this.lastEventIDCachedForLocalAssignment) {
            IntegerVector assignmentIDs = this.previousLocalAssignmentCache[localID];
            return assignmentIDs.getLargestValueLessThanOrEqualTo(eventID);
        }
        this.previousLocalAssignmentCacheStartID = startID;
        Instruction inst = this.getInstruction(eventID);
        MethodInfo method = inst.getMethod();
        IntegerVector[] integerVectorArray = assignmentIDsByLocalID = cached ? this.previousLocalAssignmentCache : new IntegerVector[method.getCode().getMaxLocals()];
        if (this.lastEventIDCachedForLocalAssignment < 0) {
            this.lastEventIDCachedForLocalAssignment = startID;
        }
        ThreadIterator iterator = new ThreadIterator(cached ? this.lastEventIDCachedForLocalAssignment : startID);
        while (iterator.hasNextInMethod()) {
            int nextID;
            this.lastEventIDCachedForLocalAssignment = nextID = iterator.nextInMethod();
            EventKind kind = this.getKind(nextID);
            int localIDSet = -1;
            if (kind == EventKind.SETLOCAL || kind == EventKind.IINC) {
                localIDSet = ((SetLocal)this.getInstruction(nextID)).getLocalID();
            } else if (kind.isArgument) {
                localIDSet = this.getArgumentLocalIDSet(nextID);
            }
            if (localIDSet < 0) continue;
            IntegerVector assignmentIDs = assignmentIDsByLocalID[localIDSet];
            if (assignmentIDs == null) {
                assignmentIDsByLocalID[localIDSet] = assignmentIDs = new IntegerVector(2);
            }
            assignmentIDs.append(nextID);
        }
        this.previousLocalAssignmentCache = assignmentIDsByLocalID;
        return assignmentIDsByLocalID[localID].getLargestValueLessThanOrEqualTo(eventID);
    }

    public Value getOperandStackValue(int eventID, int argument) {
        Value[] productionEvents = this.arguments.get(eventID);
        if (productionEvents == null) {
            productionEvents = new Value[this.getInstruction(eventID).getNumberOfArgumentProducers()];
            this.arguments.put(eventID, productionEvents);
        }
        assert (argument < productionEvents.length) : "Sent illegal argument " + argument + " to  instruction with " + this.getInstruction(eventID).getNumberOfArgumentProducers() + " arguments:\n\n" + this.getInstruction(eventID);
        if (productionEvents[argument] == null) {
            Value value;
            productionEvents[argument] = value = this.getOperandStackValueHelper(eventID, argument);
        }
        return productionEvents[argument];
    }

    private Value getOperandStackValueHelper(int consumerID, int argument) {
        Value value = null;
        EventKind kind = this.getKind(consumerID);
        Instruction consumer = this.getInstruction(consumerID);
        MethodInfo method = consumer.getMethod();
        boolean isVirtual = method.isVirtual();
        int numberOfArguments = consumer.getNumberOfArgumentProducers();
        if (kind.isArtificial || numberOfArguments == 0 || kind.isValueProduced && consumer instanceof Invoke) {
            return null;
        }
        StackDependencies.Producers producers = consumer.getProducersOfArgument(argument);
        if (consumer instanceof IADD) {
            System.err.println();
        }
        if (producers.getNumberOfProducers() == 0) {
            return null;
        }
        Instruction[] prods = new Instruction[producers.getNumberOfProducers()];
        int i = 0;
        while (i < producers.getNumberOfProducers()) {
            Instruction potentialProducer = producers.getProducer(i);
            Instruction priorProducer = consumer;
            while (potentialProducer instanceof Duplication) {
                Instruction newProducer = Trace.getSourceOfDuplicationsValue((Duplication)potentialProducer, priorProducer, argument);
                priorProducer = potentialProducer;
                potentialProducer = newProducer;
            }
            prods[i] = potentialProducer;
            ++i;
        }
        boolean singleProducer = prods.length == 1;
        Instruction firstProducer = prods[0];
        boolean referencesUninitializedObject = firstProducer.referencesUninitializedObject();
        if (isVirtual && singleProducer && firstProducer instanceof ALOAD_0 && !referencesUninitializedObject) {
            int startID = this.getStartID(consumerID);
            if (method.isInstanceInitializer()) {
                int callID = this.getStartIDsInvocationID(startID);
                if (callID >= 0) {
                    value = this.getOperandStackValue(callID, 0);
                }
                if (value == null) {
                    value = new UnknownValue(this, consumerID, UnknownValue.Reason.THIS_NOT_RECORDED);
                }
            } else {
                ThreadIterator afterStart = new ThreadIterator(startID);
                int nextID = afterStart.nextInThread();
                EventKind nextKind = this.getKind(nextID);
                value = new TraceValue(this, nextID, firstProducer);
            }
        } else if (singleProducer && firstProducer instanceof GetLocal && !referencesUninitializedObject) {
            int localIDUsed = ((GetLocal)firstProducer).getLocalID();
            if (value == null) {
                int definitionID = this.getDefinitionOfLocalIDBefore(consumerID, localIDUsed);
                if (definitionID >= 0) {
                    value = new TraceValue(this, definitionID, firstProducer);
                } else assert (false) : "It shouldn't be possible to not find a definition for local " + localIDUsed;
            }
        } else if (singleProducer && Trace.producerIsUnrecordedConstant(firstProducer)) {
            Instruction priorProducer = firstProducer;
            Instruction constantProducer = firstProducer;
            while (constantProducer instanceof Duplication) {
                Instruction newProducer = Trace.getSourceOfDuplicationsValue((Duplication)constantProducer, priorProducer, argument);
                priorProducer = constantProducer;
                constantProducer = newProducer;
            }
            value = new ConstantValue(this, (PushConstant)constantProducer);
        } else if (firstProducer instanceof JSR || firstProducer instanceof JSR_W) {
            value = new UnknownValue(this, consumerID, UnknownValue.Reason.JSR_ARGUMENT);
        } else if (singleProducer && firstProducer instanceof NEW) {
            if (kind == EventKind.INVOKE_SPECIAL) {
                int newID = this.getInstantiationFollowingInitialization(consumerID);
                value = newID >= 0 ? new TraceValue(this, newID, firstProducer) : new UnknownValue(this, consumerID, UnknownValue.Reason.NO_PLACEHOLDER);
            } else {
                int newID;
                long objectID;
                int placeholderID = -1;
                ThreadIterator iterator = this.getThreadIteratorAt(consumerID);
                while (value == null && iterator.hasPreviousInMethod()) {
                    int previousID = iterator.previousInMethod();
                    EventKind previousKind = this.getKind(previousID);
                    if (previousKind != EventKind.NEW_OBJECT || this.getInstruction(previousID) != firstProducer) continue;
                    placeholderID = previousID;
                    break;
                }
                value = placeholderID >= 0 ? ((objectID = this.getLongProduced(placeholderID)) < 0L ? new UnknownValue(this, consumerID, UnknownValue.Reason.PLACEHOLDER_WITH_NO_VALUE) : ((newID = this.getInstantiationHistory().getInstantiationIDOf(objectID)) >= 0 ? new TraceValue(this, newID, firstProducer) : new UnknownValue(this, consumerID, UnknownValue.Reason.PLACEHOLDER_WITH_NO_CORRESPONDING))) : new UnknownValue(this, consumerID, UnknownValue.Reason.NO_PLACEHOLDER);
            }
        } else if (referencesUninitializedObject && firstProducer.referencesInstanceInInitializerBeforeSuperInitializer()) {
            int startID = this.getStartID(consumerID);
            int callID = this.getStartIDsInvocationID(startID);
            if (callID >= 0) {
                value = this.getOperandStackValue(callID, 0);
            }
            if (value == null) {
                value = new UnknownValue(this, consumerID, UnknownValue.Reason.NO_INVOCATION_INSTANCE);
            }
        } else if (prods.length > 0) {
            int argumentsFound = 0;
            ThreadIterator iterator = this.getThreadIteratorAt(consumerID);
            while (value == null && iterator.hasPreviousInMethod() && argumentsFound < numberOfArguments) {
                int previousID = iterator.previousInMethod();
                EventKind previousKind = this.getKind(previousID);
                if (!previousKind.isValueProduced) continue;
                Instruction previousInstruction = this.getInstruction(previousID);
                boolean candidateIsProducer = false;
                Instruction[] instructionArray = prods;
                int n = prods.length;
                int n2 = 0;
                while (n2 < n) {
                    Instruction prod = instructionArray[n2];
                    if (prod == previousInstruction) {
                        candidateIsProducer = true;
                    }
                    ++n2;
                }
                if (!candidateIsProducer) continue;
                ++argumentsFound;
                value = previousInstruction instanceof GetLocal ? new TraceValue(this, this.getDefinitionOfLocalIDBefore(previousID, ((GetLocal)previousInstruction).getLocalID()), previousInstruction) : (previousKind.isConstantProduced ? new ConstantValue(this, (PushConstant)previousInstruction) : new TraceValue(this, previousID, previousInstruction));
            }
            if (value == null) {
                value = new UnknownValue(this, consumerID, UnknownValue.Reason.UNKNOWN);
            }
        } else if (consumer.isExceptionHandlerStart() && consumer instanceof SetLocal) {
            value = new UnknownValue(this, consumerID, UnknownValue.Reason.NO_EXCEPTION_SOURCE);
        } else assert (false) : "Why doesn't " + consumer + " have any producers, despite claiming to?";
        return value;
    }

    private int getInstantiationFollowingInitialization(int initializationID) {
        QualifiedClassName classCreated = ((INVOKESPECIAL)this.getInstruction(initializationID)).getMethodInvoked().getClassName();
        ThreadIterator iterator = this.getThreadIteratorAt(initializationID);
        while (iterator.hasNextInMethod()) {
            int nextID = iterator.nextInMethod();
            EventKind nextKind = this.getKind(nextID);
            if (nextKind != EventKind.NEW_OBJECT || ((NEW)this.getInstruction(nextID)).getClassInstantiated().getName() != classCreated) continue;
            return nextID;
        }
        return -1;
    }

    private static boolean producerIsUnrecordedConstant(Instruction potentialProducer) {
        if (!potentialProducer.getTypeProduced().isConstantProduced) {
            return false;
        }
        if (potentialProducer.isIO()) {
            return false;
        }
        return !(potentialProducer instanceof GetLocal);
    }

    private static Instruction getSourceOfDuplicationsValue(Duplication dup, Instruction consumerOfDuplicationsValue, int argumentNumberOfDuplicationsValue) {
        StackDependencies.Consumers consumers = dup.getConsumers();
        if (consumers.getNumberOfConsumers() == 1) {
            return dup.getProducersOfArgument(0).getFirstProducer();
        }
        Instruction producerOfFirstValue = dup.getProducersOfArgument(0).getFirstProducer();
        Instruction producerOfSecondValue = dup.getProducersOfArgument(1).getFirstProducer();
        if (consumers.getFirstConsumer() == consumers.getSecondConsumer()) {
            if (argumentNumberOfDuplicationsValue == 0) {
                return producerOfFirstValue;
            }
            if (consumerOfDuplicationsValue.getProducersOfArgument(argumentNumberOfDuplicationsValue - 1).getFirstProducer() == dup) {
                return producerOfSecondValue;
            }
            return producerOfFirstValue;
        }
        if (consumers.getFirstConsumer() == consumerOfDuplicationsValue) {
            return producerOfFirstValue;
        }
        return producerOfSecondValue;
    }

    public List<Value> getOperandStackDependencies(int eventID) {
        int numberOfArguments = this.getInstruction(eventID).getNumberOfArgumentProducers();
        int i = 0;
        while (i < numberOfArguments) {
            this.getOperandStackValue(eventID, i);
            ++i;
        }
        Value[] producers = this.arguments.get(eventID);
        if (producers == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(producers));
    }

    public String getDescription(int eventID) {
        return this.getKind(eventID).getDescription(this, eventID);
    }

    public String getHTMLDescription(int eventID) {
        return this.getKind(eventID).getHTMLDescription(this, eventID);
    }

    public String getNameAssociatedWithEvent(int eventID) {
        if (this.getKind((int)eventID).isArgument) {
            int localID = this.getArgumentLocalIDSet(eventID);
            Instruction instruction = this.getInstruction(eventID);
            MethodInfo method = instruction.getMethod();
            return method.getCode().getLocalIDNameRelativeToInstruction(localID, instruction);
        }
        return this.getInstruction(eventID).getAssociatedName();
    }

    public Value getMethodArgumentValue(int eventID, int argumentNumber) {
        if (this.getInstruction(eventID).getMethod().isImplicitlyInvoked()) {
            return null;
        }
        int startID = this.getStartID(eventID);
        if (!this.getInvocationByStartTable(startID).containsKey(startID)) {
            return null;
        }
        return this.getOperandStackValue(this.getInvocationByStartTable(startID).get(startID), argumentNumber);
    }

    public int getNextEventIDInMethod(int eventID) {
        ThreadIterator iterator = new ThreadIterator(eventID);
        return iterator.hasNextInMethod() ? iterator.nextInMethod() : -1;
    }

    public int getPreviousEventIDInMethod(int eventID) {
        ThreadIterator iterator = new ThreadIterator(eventID);
        return iterator.hasPreviousInMethod() ? iterator.previousInMethod() : -1;
    }

    public int getNextEventIDInThread(int eventID) {
        ThreadIterator iterator = this.getThreadIteratorAt(eventID);
        if (iterator.hasNextInThread()) {
            return iterator.nextInThread();
        }
        return -1;
    }

    public int getPreviousEventInThread(int eventID) {
        ThreadIterator iterator = this.getThreadIteratorAt(eventID);
        if (iterator.hasPreviousInThread()) {
            return iterator.previousInThread();
        }
        return -1;
    }

    public int getSourceOfValueID(int eventID) {
        int e;
        int mostRecentNonNullNonValueProducedEvent = e = eventID;
        while (e >= 0) {
            int heapID;
            Instruction i;
            EventKind kind = this.getKind(e);
            if (!kind.isValueProduced || kind.isInstantiation) {
                mostRecentNonNullNonValueProducedEvent = e;
            }
            if (kind.isArgument) {
                e = this.getHeapDependency(e);
                continue;
            }
            if (kind == EventKind.PUTFIELD) {
                e = this.getOperandStackValue(e, 1).getEventID();
                continue;
            }
            if (kind == EventKind.PUTSTATIC) {
                e = this.getOperandStackValue(e, 0).getEventID();
                continue;
            }
            if (kind == EventKind.SETLOCAL) {
                e = this.getOperandStackValue(e, 0).getEventID();
                continue;
            }
            if (kind == EventKind.SETARRAY) {
                e = this.getOperandStackValue(e, 2).getEventID();
                continue;
            }
            if (kind == EventKind.RETURN) {
                e = this.getOperandStackValue(e, 0).getEventID();
                continue;
            }
            if (!kind.isValueProduced || !((i = this.getInstruction(e)) instanceof Use) && !(i instanceof Invoke) && !(i instanceof NEW) || (heapID = this.getHeapDependency(e)) < 0) break;
            e = heapID;
        }
        return e;
    }

    public int getStartID(int eventID) {
        return eventID < 0 ? -1 : this.getInvocationHistory().determineStartMethodIDOf(eventID);
    }

    public int getHeapDependency(int eventID) {
        EventKind kind = this.getKind(eventID);
        if (kind.isArgument) {
            Instruction inst = this.getInstruction(eventID);
            MethodInfo method = inst.getMethod();
            int argumentNumber = method.getArgumentNumberOfLocalID(this.getArgumentLocalIDSet(eventID));
            Value stackvalue = this.getMethodArgumentValue(eventID, argumentNumber);
            if (stackvalue == null) {
                return -1;
            }
            if (!(stackvalue instanceof TraceValue)) {
                return -1;
            }
            return stackvalue.getEventID();
        }
        if (kind == EventKind.NEW_OBJECT) {
            return this.getInitializationByInstantiationTable(eventID).get(eventID);
        }
        Instruction inst = this.getInstruction(eventID);
        if (inst instanceof GetArrayValue) {
            try {
                long objectAddress = this.getOperandStackValue(eventID, 0).getLong();
                int arrayIndex = this.getOperandStackValue(eventID, 1).getInteger();
                return this.getArrayAssignmentBefore(objectAddress, arrayIndex, eventID);
            }
            catch (NoValueException e) {
                return -1;
            }
        }
        if (inst instanceof GETFIELD) {
            long referenceID = this.getOperandStackValue(eventID, 0).getLong();
            return referenceID < 0L ? -1 : this.findFieldAssignmentBefore(((FieldrefContainer)((Object)inst)).getFieldref(), referenceID, eventID);
        }
        if (inst instanceof GetLocal) {
            int localID = ((GetLocal)inst).getLocalID();
            int dependencyID = this.findLocalIDAssignmentBefore(localID, eventID);
            if (((GetLocal)inst).getsMethodArgument()) {
                if (dependencyID < 0) {
                    int argNumber = inst.getMethod().getArgumentNumberOfLocalID(localID);
                    Value value = this.getMethodArgumentValue(eventID, argNumber);
                    if (value == null) {
                        return -1;
                    }
                    dependencyID = value.getEventID();
                } else if (this.getInstruction(eventID).getMethod().isSynthetic()) {
                    return this.getHeapDependency(dependencyID);
                }
            }
            return dependencyID;
        }
        if (inst instanceof GETSTATIC) {
            return this.findGlobalAssignmentBefore(((GETSTATIC)inst).getFieldref().getQualifiedName(), eventID);
        }
        if (inst instanceof IINC) {
            final int localID = ((SetLocal)inst).getLocalID();
            int mostRecentLocalDefinition = this.findEventInMethodInThreadBefore(eventID, new SearchCriteria(){

                public boolean matches(int eventID) {
                    Instruction candidate = Trace.this.getInstruction(eventID);
                    if (candidate instanceof SetLocal) {
                        return ((SetLocal)candidate).getLocalID() == localID;
                    }
                    return false;
                }
            });
            if (mostRecentLocalDefinition >= -1) {
                return mostRecentLocalDefinition;
            }
            return -1;
        }
        if (inst instanceof Invoke) {
            return kind.isValueProduced ? this.getInvocationReturnDependencyID(eventID) : -1;
        }
        return -1;
    }

    private int getInvocationReturnDependencyID(int invocationID) {
        Invoke invoke = (Invoke)this.getInstruction(invocationID);
        assert (invoke.getMethodInvoked().getReturnType() != QualifiedClassName.VOID) : " Why do we have a value produced event from a method that doesn't return a value?";
        int returnID = this.getPreviousEventInThread(invocationID);
        if (this.getKind(returnID) == EventKind.RETURN) {
            MethodInfo methodOfReturn = this.getInstruction(returnID).getMethod();
            if (methodOfReturn.getMethodNameAndDescriptor().equals(invoke.getMethodInvoked().getMethodNameAndDescriptor())) {
                if (methodOfReturn.isSynthetic()) {
                    return this.getOperandStackValue(returnID, 0).getEventID();
                }
                return returnID;
            }
            return -1;
        }
        return -1;
    }

    public int getInvocationProducedInvocationID(int invocationProducedID) {
        Invoke call = (Invoke)this.getInstruction(invocationProducedID);
        ThreadIterator iterator = new ThreadIterator(invocationProducedID);
        while (iterator.hasPreviousInMethod()) {
            int eventID = iterator.previousInMethod();
            EventKind kind = this.getKind(eventID);
            Instruction inst = this.getInstruction(eventID);
            if (!this.getKind((int)eventID).isInvocation || this.getInstruction(eventID) != call) continue;
            return eventID;
        }
        return -1;
    }

    public IntegerVector getUnrecordedInvocationDependencyIDs(int invocationID) {
        EventKind kind = this.getKind(invocationID);
        if (!kind.isValueProduced) {
            return null;
        }
        Instruction inst = this.getInstruction(invocationID);
        if (!(inst instanceof Invoke)) {
            return null;
        }
        Invoke invoke = (Invoke)inst;
        if (invoke.getMethodInvoked().returnsVoid()) {
            return null;
        }
        int callID = this.getInvocationProducedInvocationID(invocationID);
        int startID = this.getInvocationStartID(callID);
        int returnID = this.getStartIDsReturnOrCatchID(startID);
        if (returnID > 0) {
            return null;
        }
        assert (callID >= 0);
        if (invoke.getMethodInvoked().isStatic()) {
            IntegerVector callIDs = new IntegerVector(1);
            callIDs.append(callID);
            return callIDs;
        }
        Value instanceValue = this.getOperandStackValue(callID, 0);
        if (instanceValue != null) {
            long instanceID = instanceValue.getLong();
            IntegerVector callIDs = this.invocationHistory.findInvocationsOfPublicStateAffectingMethodsWithParametersOnObjectIDBefore(instanceID, callID);
            callIDs.append(callID);
            return callIDs;
        }
        return null;
    }

    public int getControlID(int eventID) {
        int controlID = this.controlIDs.get(eventID);
        if (controlID == 0) {
            controlID = this.determineControlID(eventID);
            this.controlIDs.put(eventID, controlID);
        }
        return controlID;
    }

    private int determineControlID(int eventID) {
        int invocationID;
        ExceptionHistory exceptions;
        int throwEvent;
        int controlID = -1;
        Instruction inst = this.getInstruction(eventID);
        MethodInfo method = inst.getMethod();
        List<ExceptionHandler> handlers = method.getCode().getExceptionHandlersThatExecute(inst);
        boolean inCatch = handlers.size() > 0;
        final Set<Instruction> controlDependencies = inst.getBranchDependencies();
        boolean controlDependenciesInCatch = true;
        for (Instruction control : controlDependencies) {
            if (method.getCode().getExceptionHandlersThatExecute(control).size() != 0) continue;
            controlDependenciesInCatch = false;
        }
        if (inCatch && !controlDependenciesInCatch && (throwEvent = (exceptions = this.getExceptionHistory()).getExceptionThrownBefore(eventID)) >= 0) {
            controlID = throwEvent;
            return controlID;
        }
        int branchEvent = this.findEventInMethodInThreadBefore(eventID, new SearchCriteria(){

            public boolean matches(int eventID) {
                return controlDependencies.contains(Trace.this.getInstruction(eventID)) && (Trace.this.getKind((int)eventID).isBranch || Trace.this.getKind((int)eventID).isInvocation);
            }
        });
        if (branchEvent >= 0) {
            controlID = branchEvent;
            return controlID;
        }
        int threadID = this.getThreadID(eventID);
        if (method.isRun()) {
            Iterator<Invoke> iterator = method.getPotentialCallers().iterator();
            if (iterator.hasNext()) {
                Invoke invoke = iterator.next();
                int threadStartEvent = this.findThreadStartBefore(invoke, eventID);
                if (threadStartEvent >= 0) {
                    controlID = threadStartEvent;
                }
                if (threadStartEvent == eventID) {
                    controlID = -1;
                }
                return controlID;
            }
        } else {
            if (method.isClassInitializer()) {
                ThreadIterator iterator;
                int clinitStartEvent = this.getClassInitializationHistory().getClassInitializationEventFor(method.getClassfile().getInternalName());
                controlID = clinitStartEvent == eventID ? ((iterator = this.getThreadIteratorAt(eventID)).hasPreviousInThread() ? this.getControlID(iterator.previousInThread()) : -1) : clinitStartEvent;
                return controlID;
            }
            if (method == this.getMain()) {
                controlID = this.getMainStartEventID();
                if (controlID == eventID) {
                    controlID = -1;
                }
                return controlID;
            }
        }
        if ((invocationID = this.getStartIDsInvocationID(this.getStartID(eventID))) >= 0) {
            controlID = invocationID;
            if (method.isSynthetic()) {
                controlID = this.getControlID(invocationID);
            }
        }
        return controlID;
    }

    public int getNumberOfBlocks() {
        return this.getNumberOfEvents() / 4096 + 1;
    }

    private int getInstructionID(int eventID) {
        IDBlock block = ((IDBlock[])this.idBlocks.blocks)[eventID / 4096];
        if (block == null) {
            block = this.getIDBlock(eventID);
        }
        return block.instructionIDs[eventID - block.firstEventID];
    }

    public EventKind getKind(int eventID) {
        IDBlock block = ((IDBlock[])this.idBlocks.blocks)[eventID / 4096];
        if (block == null) {
            block = this.getIDBlock(eventID);
        }
        byte kindID = block.kindIDs[eventID - block.firstEventID];
        return EventKind.intToEvent(kindID);
    }

    public int getThreadID(int eventID) {
        if (this.threadIDCache.containsKey(eventID)) {
            return this.threadIDCache.get(eventID);
        }
        int threadID = this.findThreadID(eventID);
        if (threadID < 0) {
            throw new RuntimeException("Couldn't find threadID for event " + eventID);
        }
        if (this.threadIDCache.size() > Short.MAX_VALUE) {
            this.threadIDCache.clear();
        }
        this.threadIDCache.put(eventID, threadID);
        return threadID;
    }

    private int findThreadID(int eventID) {
        ThreadTrace[] threadTraceArray = this.threads;
        int n = this.threads.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadTrace trace = threadTraceArray[n2];
            if (eventID >= trace.getFirstEventID() && eventID <= trace.getLastEventID() && trace.eventIDs.contains(eventID)) {
                return trace.getThreadID();
            }
            ++n2;
        }
        return -1;
    }

    public int getBranchFirstExecutionInMethod(int branchID) {
        int startEventID = this.getStartID(branchID);
        return this.findEventInMethodInThreadAfter(startEventID, this.getInstruction(branchID));
    }

    public Object getObjectProduced(int eventID) {
        if (this.getKind((int)eventID).isConstantProduced) {
            if (this.getInstruction(eventID) instanceof PushConstant) {
                return ((PushConstant)this.getInstruction(eventID)).getConstant();
            }
            return null;
        }
        long id = this.getObjectIDProduced(eventID);
        Object o = id < 0L ? null : this.getImmutableObject(id);
        return o;
    }

    public boolean getBooleanProduced(int booleanID) throws NoValueException {
        if (this.getBooleansProduced(booleanID).containsKey(booleanID)) {
            return this.getBooleansProduced(booleanID).get(booleanID) > 0;
        }
        if (this.getKind((int)booleanID).isConstantProduced) {
            return (Boolean)((PushConstant)this.getInstruction(booleanID)).getConstant();
        }
        throw new NoValueException(this, booleanID, "didn't produce an boolean.");
    }

    public int getIntegerProduced(int eventID) throws NoValueException {
        if (this.getShortsProduced(eventID).containsKey(eventID)) {
            return this.getShortsProduced(eventID).get(eventID);
        }
        if (this.getIntegersProduced(eventID).containsKey(eventID)) {
            return this.getIntegersProduced(eventID).get(eventID);
        }
        if (this.getBooleansProduced(eventID).containsKey(eventID)) {
            return this.getBooleansProduced(eventID).get(eventID);
        }
        if (this.getKind((int)eventID).isConstantProduced) {
            return (Integer)((PushConstant)this.getInstruction(eventID)).getConstant();
        }
        throw new NoValueException(this, eventID, "didn't produce an integer.");
    }

    public long getObjectIDProduced(int eventID) {
        return this.getLongProduced(eventID);
    }

    public long getLongProduced(int eventID) {
        if (this.getShortsProduced(eventID).containsKey(eventID)) {
            return this.getShortsProduced(eventID).get(eventID);
        }
        if (this.getIntegersProduced(eventID).containsKey(eventID)) {
            return this.getIntegersProduced(eventID).get(eventID);
        }
        if (this.getLongsProduced(eventID).containsKey(eventID)) {
            return this.getLongsProduced(eventID).get(eventID);
        }
        if (this.getKind((int)eventID).isConstantProduced) {
            Object val = ((PushConstant)this.getInstruction(eventID)).getConstant();
            if (val == null) {
                return 0L;
            }
            if (val instanceof String) {
                return this.getIDOfImmutable(val);
            }
            throw new RuntimeException("Couldn't find a long produced by " + eventID);
        }
        return -1L;
    }

    public float getFloatProduced(int eventID) throws NoValueException {
        if (this.getFloatsProduced(eventID).containsKey(eventID)) {
            return this.getFloatsProduced(eventID).get(eventID);
        }
        if (this.getKind((int)eventID).isConstantProduced) {
            return ((Float)((PushConstant)this.getInstruction(eventID)).getConstant()).floatValue();
        }
        throw new NoValueException(this, eventID, "didn't produce a float.");
    }

    public double getDoubleProduced(int eventID) throws NoValueException {
        if (this.getDoublesProduced(eventID).containsKey(eventID)) {
            return this.getDoublesProduced(eventID).get(eventID);
        }
        if (this.getKind((int)eventID).isConstantProduced) {
            return (Double)((PushConstant)this.getInstruction(eventID)).getConstant();
        }
        throw new NoValueException(this, eventID, "didn't produce a double.");
    }

    public char getCharacterProduced(int eventID) throws NoValueException {
        if (this.getCharactersProduced(eventID).containsKey(eventID)) {
            return (char)this.getCharactersProduced(eventID).get(eventID);
        }
        if (this.getKind((int)eventID).isConstantProduced) {
            return ((Character)((PushConstant)this.getInstruction(eventID)).getConstant()).charValue();
        }
        throw new NoValueException(this, eventID, "didn't produce a character.");
    }

    public byte getByteProduced(int eventID) throws NoValueException {
        if (this.getBytesProduced(eventID).containsKey(eventID)) {
            return this.getBytesProduced(eventID).get(eventID);
        }
        if (this.getKind((int)eventID).isConstantProduced) {
            return (Byte)((PushConstant)this.getInstruction(eventID)).getConstant();
        }
        throw new NoValueException(this, eventID, "didn't produce a byte.");
    }

    public short getShortProduced(int eventID) throws NoValueException {
        if (this.getShortsProduced(eventID).containsKey(eventID)) {
            return this.getShortsProduced(eventID).get(eventID);
        }
        if (this.getKind((int)eventID).isConstantProduced) {
            return (Short)((PushConstant)this.getInstruction(eventID)).getConstant();
        }
        throw new NoValueException(this, eventID, "didn't produce a short.");
    }

    public Value getReturnValueReturned(int returnEventID) {
        if (this.getInstruction(returnEventID) instanceof RETURN) {
            return null;
        }
        return this.getOperandStackValue(returnEventID, 0);
    }

    public int getReturnStartID(int returnID) {
        if (this.getStartByReturnTable(returnID).containsKey(returnID)) {
            return this.getStartByReturnTable(returnID).get(returnID);
        }
        throw new RuntimeException(this.eventToString(returnID) + " didn't have a return.");
    }

    public Value getDefinitionValueSet(int definitionID) {
        EventKind kind = this.getKind(definitionID);
        switch (kind) {
            case IINC: {
                try {
                    return new IncrementValue(this, definitionID, this.getIncrementValue(definitionID));
                }
                catch (NoValueException e) {
                    return new UnknownValue(this, definitionID, UnknownValue.Reason.NO_INCREMENT);
                }
            }
            case PUTFIELD: {
                return this.getOperandStackValue(definitionID, 1);
            }
            case PUTSTATIC: {
                return this.getOperandStackValue(definitionID, 0);
            }
            case SETARRAY: {
                return this.getOperandStackValue(definitionID, 2);
            }
            case SETLOCAL: {
                return this.getOperandStackValue(definitionID, 0);
            }
        }
        return null;
    }

    public boolean eventDefinesLocalID(int definitionID, int localID) {
        EventKind kind = this.getKind(definitionID);
        if (kind == EventKind.SETLOCAL) {
            return ((SetLocal)this.getInstruction(definitionID)).getLocalID() == localID;
        }
        if (kind.isArgument) {
            return this.getArgumentLocalIDSet(definitionID) == localID;
        }
        if (kind == EventKind.IINC) {
            return ((IINC)this.getInstruction(definitionID)).getLocalID() == localID;
        }
        return false;
    }

    public long getPutFieldObjectIDAssigned(int putEventID) throws NoValueException {
        Value value = this.getOperandStackValue(putEventID, 0);
        if (value instanceof UnknownValue || value == null) {
            return 0L;
        }
        return value.getLong();
    }

    public long getInvocationInstanceID(int invocationID) {
        Instruction inst = this.getInstruction(invocationID);
        if (inst instanceof INVOKESTATIC) {
            return 0L;
        }
        long instanceID = this.invocationInstanceIDByInvocation.get(invocationID);
        if (instanceID <= 0L) {
            int argumentID;
            int startID = this.getInvocationStartID(invocationID);
            if (startID >= 0 && (argumentID = this.getNextEventIDInMethod(startID)) >= 0 && this.getKind((int)argumentID).isArgument && this.getArgumentLocalIDSet(argumentID) == 0) {
                instanceID = this.getObjectIDProduced(argumentID);
            }
            if (instanceID < 0L) {
                instanceID = this.getOperandStackValue(invocationID, 0).getLong();
                this.invocationInstanceIDByInvocation.put(invocationID, instanceID);
            }
            this.invocationInstanceIDByInvocation.put(invocationID, instanceID);
        }
        return instanceID;
    }

    public QualifiedClassName getInvocationClassInvokedOn(int invocationID) {
        Invoke inst = (Invoke)this.getInstruction(invocationID);
        if (inst instanceof INVOKESTATIC) {
            return inst.getMethodInvoked().getClassName();
        }
        long id = this.getInvocationInstanceID(invocationID);
        if (id < 0L) {
            return QualifiedClassName.JAVA_LANG_OBJECT;
        }
        return this.getClassnameOfObjectID(id);
    }

    public int getInvocationStartID(int invocationID) {
        if (this.getStartByInvocationTable(invocationID).containsKey(invocationID)) {
            return this.getStartByInvocationTable(invocationID).get(invocationID);
        }
        return -1;
    }

    public String getArgumentDescription(int setMethodArgumentID) {
        return this.getKind(setMethodArgumentID).getDescriptionOfSetArgumentEvent(this, setMethodArgumentID);
    }

    public String getArgumentValueDescription(int setMethodArgumentID) {
        return this.getKind(setMethodArgumentID).getDescriptionOfSetArgumentValue(this, setMethodArgumentID);
    }

    public String getArgumentNameSet(int setMethodArgumentID) {
        Instruction inst = this.getInstruction(setMethodArgumentID);
        return inst.getCode().getLocalIDNameRelativeToInstruction(this.getArgumentLocalIDSet(setMethodArgumentID), inst);
    }

    public int getArgumentLocalIDSet(int setMethodArgumentID) {
        assert (this.getKind((int)setMethodArgumentID).isArgument) : "Can only send set argument event IDs to this, but received \n\t" + this.eventToString(setMethodArgumentID);
        MethodInfo method = this.getInstruction(setMethodArgumentID).getMethod();
        ThreadIterator i = this.getThreadIteratorAt(setMethodArgumentID);
        int argNumber = 0;
        while (i.hasPreviousInMethod()) {
            int nextID = i.previousInMethod();
            EventKind kind = this.getKind(nextID);
            if (kind == EventKind.START_METHOD) break;
            if (!kind.isArgument) continue;
            ++argNumber;
        }
        if (method.isInstanceInitializer()) {
            ++argNumber;
        }
        int predictedID = method.getLocalIDFromArgumentNumber(argNumber);
        return predictedID;
    }

    public KeyArguments getKeyArguments(int keyEventID) {
        return this.keyArguments.get(keyEventID);
    }

    public MouseArguments getMouseArguments(int mouseEventID) {
        return this.mouseArguments.get(mouseEventID);
    }

    public RepaintArguments getRepaintArguments(int repaintEventID) {
        return this.repaintArguments.get(repaintEventID);
    }

    public CreateGraphicsArguments getCreateGraphicsArguments(int createGraphicsEventID) {
        return this.createGraphicsArguments.get(createGraphicsEventID);
    }

    public int getInitializationOfObjectID(long objectID) {
        int newID = this.getInstantiationOf(objectID);
        if (newID < 0) {
            return -1;
        }
        TIntIntHashMap initIDs = this.getInitializationByInstantiationTable(newID);
        return initIDs.containsKey(newID) ? initIDs.get(newID) : -1;
    }

    public int getStartIDsReturnOrCatchID(int startID) {
        TIntIntHashMap returnIDs = this.getReturnByStartTable(startID);
        return returnIDs.containsKey(startID) ? returnIDs.get(startID) : -1;
    }

    public int getStartIDsInvocationID(int startID) {
        if (this.getInvocationByStartTable(startID).containsKey(startID)) {
            return this.getInvocationByStartTable(startID).get(startID);
        }
        return -1;
    }

    public Value getStartMethodObjectIDInvokedOn(int startID) {
        int invocationID = this.getStartIDsInvocationID(startID);
        return invocationID < 0 ? null : this.getOperandStackValue(invocationID, 0);
    }

    public int getIncrementValue(int incrementID) throws NoValueException {
        if (this.getValuesByIncrementID(incrementID).containsKey(incrementID)) {
            return this.getValuesByIncrementID(incrementID).get(incrementID);
        }
        throw new NoValueException(this, incrementID, "not an increment.");
    }

    public Value getSetArrayArraySet(int setArrayEventID) {
        return this.getOperandStackValue(setArrayEventID, 0);
    }

    public Value getSetArrayIndexSet(int setArrayEventID) {
        return this.getOperandStackValue(setArrayEventID, 1);
    }

    public Value getSetArrayValueSet(int setArrayEventID) {
        return this.getOperandStackValue(setArrayEventID, 2);
    }

    public int getCatchesThrowID(int catchID) {
        return this.getExceptionHistory().getThrowEventIDForCatchID(catchID);
    }

    public long getIDOfImmutable(Object obj) {
        return this.idsOfImmutables.get(obj);
    }

    public QualifiedClassName getClassnameOfObjectID(long objectID) {
        if (objectID == 0L) {
            return QualifiedClassName.NULL;
        }
        if (objectID < 0L) {
            return null;
        }
        int classID = this.objectTypes.get(objectID);
        assert (classID != 0) : "Object ID " + objectID + " is of an unknown type.";
        return this.getNameOfClassID(classID);
    }

    public String getAssociatedNameOfObjectID(long objectID) {
        String associatedName = null;
        int instantiationID = this.getInstantiationOf(objectID);
        if (instantiationID >= 0) {
            Instruction instantiation = this.getInstruction(instantiationID);
            while (instantiation != null) {
                if (instantiation instanceof SetLocal || instantiation instanceof PUTFIELD || instantiation instanceof PUTSTATIC) {
                    associatedName = instantiation.getAssociatedName();
                    break;
                }
                StackDependencies.Consumers consumers = instantiation.getConsumers();
                if (consumers.getNumberOfConsumers() > 1) break;
                instantiation = consumers.getFirstConsumer();
            }
        }
        return associatedName;
    }

    public Classfile getClassfileOfObjectID(long objectID) {
        if (objectID == 0L) {
            return null;
        }
        int classID = this.objectTypes.get(objectID);
        if (classID == 0) {
            return null;
        }
        return this.getClassfileByID(classID);
    }

    public String getDescriptionOfObjectID(long objectID) {
        if (objectID < 0L) {
            return "unknown";
        }
        if (objectID == 0L) {
            return "null";
        }
        QualifiedClassName name = this.getClassnameOfObjectID(objectID);
        String number = Util.commas(objectID);
        return String.valueOf(name.getSimpleName()) + " #" + number;
    }

    public int findEventBetween(int afterTime, int beforeTime, SearchCriteria criteria) {
        int indexToCheck = beforeTime - 1;
        if (afterTime < 0) {
            afterTime = 0;
        }
        while (indexToCheck >= afterTime) {
            if (criteria.matches(indexToCheck)) {
                return indexToCheck;
            }
            --indexToCheck;
        }
        return -1;
    }

    @Deprecated
    public int findEventInThreadBefore(int eventID, SearchCriteria criteria) {
        ThreadIterator iterator = this.getThreadIteratorAt(eventID);
        while (iterator.hasPreviousInThread()) {
            int id = iterator.previousInThread();
            if (!criteria.matches(id)) continue;
            return id;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public int findEventInMethodInThreadBefore(int eventID, SearchCriteria criteria) {
        iterator = this.getThreadIteratorAt(eventID);
        kind = this.getKind(eventID);
        if (kind != EventKind.START_METHOD) ** GOTO lbl8
        return -1;
lbl-1000:
        // 1 sources

        {
            e = iterator.previousInMethod();
            if (!criteria.matches(e)) continue;
            return e;
lbl8:
            // 2 sources

            ** while (iterator.hasPreviousInMethod())
        }
lbl9:
        // 1 sources

        return -1;
    }

    public int findEventInMethodInThreadAfter(int eventID, Instruction instructionToFindExecutionOf) {
        ThreadIterator iterator = this.getThreadIteratorAt(eventID);
        while (iterator.hasNextInMethod()) {
            int e = iterator.nextInMethod();
            if (this.getInstruction(e) != instructionToFindExecutionOf) continue;
            return e;
        }
        return -1;
    }

    public int getInstantiationOf(long objectID) {
        return this.instantiationHistory.getInstantiationIDOf(objectID);
    }

    public InstantiationHistory getInstantiationHistory() {
        return this.instantiationHistory;
    }

    public int getArrayAssignmentBefore(long arrayID, int arrayIndex, int beforeEventID) {
        int mostRecentArrayDefinition = this.arrayHistory.getIndexAssignmentBefore(arrayID, arrayIndex, beforeEventID);
        if (mostRecentArrayDefinition >= 0) {
            return mostRecentArrayDefinition;
        }
        return this.getInstantiationOf(arrayID);
    }

    public int getArrayLength(long arrayID) {
        int initID = this.getInstantiationOf(arrayID);
        if (initID > 0) {
            Instruction newArray = this.getInstruction(initID);
            Value value = this.getOperandStackValue(initID, 0);
            try {
                return value.getInteger();
            }
            catch (NoValueException e) {
                return -1;
            }
        }
        return -1;
    }

    public int findGlobalAssignmentBefore(String qualifedName, int eventID) {
        return this.staticAssignmentHistory.getLastDefinitionOfBefore(qualifedName, eventID);
    }

    public int findFieldAssignmentBefore(FieldInfo field, long objectID, int eventID) {
        return this.findFieldAssignmentBefore(field.getDisplayName(true, -1), objectID, eventID);
    }

    public int findFieldAssignmentBefore(FieldrefInfo field, long objectID, int eventID) {
        return this.findFieldAssignmentBefore(field.getName(), objectID, eventID);
    }

    public int findFieldAssignmentBefore(String fieldname, long objectID, int eventID) {
        int lastDefinition = this.fieldAssignmentHistory.getDefinitionOfFieldBefore(objectID, fieldname, eventID);
        if (lastDefinition >= 0) {
            return lastDefinition;
        }
        return this.getInstantiationOf(objectID);
    }

    public int findFieldAssignmentAfter(FieldInfo field, long objectID, int eventID) {
        return this.fieldAssignmentHistory.getDefinitionOfFieldAfter(objectID, field.getName(), eventID);
    }

    public int findLocalIDAssignmentBefore(final int localID, int eventID) {
        assert (localID >= 0) : "Can't find a local with local ID " + localID;
        int definition = this.findEventInMethodInThreadBefore(eventID, new SearchCriteria(){

            public boolean matches(int eventID) {
                if (Trace.this.getKind((int)eventID).isDefinition) {
                    return Trace.this.eventDefinesLocalID(eventID, localID);
                }
                return false;
            }
        });
        return definition;
    }

    public int findExecutionOfInstructionPriorTo(final Instruction inst, int eventID) {
        return this.findEventBetween(0, eventID, new SearchCriteria(){

            public boolean matches(int eventID) {
                return Trace.this.getInstruction(eventID) == inst;
            }
        });
    }

    public int findExecutionOfInstructionInThreadAfter(Instruction inst, int eventID) {
        int threadID = this.getThreadID(eventID);
        ++eventID;
        while (eventID < this.getNumberOfEvents()) {
            if (this.getThreadID(eventID) != threadID) continue;
            if (!(this.getInstruction(eventID) != inst || inst instanceof Invoke && this.getKind((int)eventID).isInvocation)) {
                return eventID;
            }
            ++eventID;
        }
        return -1;
    }

    public int findExecutionOfInstructionAfter(Instruction inst, int afterID) {
        MethodInfo method = inst.getMethod();
        int currentStartID = this.getStartID(afterID);
        IntegerVector startIDs = this.invocationHistory.getStartIDsAfterEventID(method, currentStartID - 1);
        int eventID = -1;
        int i = 0;
        while (i < startIDs.size()) {
            int startID = startIDs.get(i);
            eventID = this.findExecutionOfInstructionInCallAfter(startID, inst, afterID);
            if (eventID >= 0) break;
            ++i;
        }
        return eventID;
    }

    public int findExecutionOfInstructionInCallAfter(int startID, Instruction inst, int afterID) {
        ThreadIterator events = this.getThreadIteratorAt(startID);
        while (events.hasNextInMethod()) {
            int eventID = events.nextInMethod();
            if (eventID <= afterID || this.getInstruction(eventID) != inst) continue;
            return eventID;
        }
        return -1;
    }

    public IntegerVector findExecutionsOfInstructionAfter(Instruction instruction, long objectID, int afterID) {
        StackDependencies.Consumers consumers = instruction.getConsumers();
        Instruction consumer1 = consumers.getFirstConsumer();
        Instruction consumer2 = consumers.getSecondConsumer();
        if (instruction instanceof PUTFIELD || consumer1 instanceof PUTFIELD || consumer2 instanceof PUTFIELD) {
            PUTFIELD instructionToAnalyze = (PUTFIELD)(instruction instanceof PUTFIELD ? instruction : (consumer1 instanceof PUTFIELD ? consumer1 : (consumer2 instanceof PUTFIELD ? consumer2 : null)));
            return this.fieldAssignmentHistory.getDefinitionsOfObjectFieldAfter(objectID, instructionToAnalyze.getFieldref().getName(), afterID);
        }
        if (instruction instanceof Invoke) {
            return this.invocationHistory.findInvocationsOnObjectIDAfterEventID((Invoke)instruction, objectID, afterID);
        }
        if (instruction == instruction.getCode().getFirstInstruction()) {
            return this.invocationHistory.getStartIDsOnObjectIDAfterEventID(instruction.getMethod(), objectID, afterID);
        }
        IntegerVector starts = this.invocationHistory.getStartIDsOnObjectIDAfterEventID(instruction.getMethod(), objectID, afterID);
        IntegerVector executions = new IntegerVector(10);
        Instruction inst = instruction;
        while (!(inst == null || inst instanceof Invoke || inst instanceof Branch || inst instanceof Definition)) {
            inst = inst.getNext();
        }
        if (inst == null) {
            inst = instruction;
            while (!(inst == null || inst instanceof Invoke || inst instanceof Branch || inst instanceof Definition)) {
                inst = inst.getPrevious();
            }
            if (inst == null) {
                inst = instruction.getCode().getFirstInstruction();
            }
        }
        final Instruction instructionToSearchFor = inst;
        int i = 0;
        while (i < starts.size()) {
            int startID;
            int returnID = this.getStartIDsReturnOrCatchID(startID = starts.get(i));
            int executionID = this.findEventBetween(startID, returnID < 0 ? this.getNumberOfEvents() - 1 : returnID, new SearchCriteria(){

                public boolean matches(int eventID) {
                    return Trace.this.getInstruction(eventID) == instructionToSearchFor;
                }
            });
            if (executionID >= 0) {
                executions.append(executionID);
            }
            ++i;
        }
        return executions;
    }

    public int findThreadStartBefore(Invoke invoke, int eventID) {
        return this.runHistory.getMostRecentExecutionOfBefore(invoke, eventID);
    }

    public FieldAssignmentHistory getFieldAssignmentHistory() {
        return this.fieldAssignmentHistory;
    }

    public ExceptionHistory getExceptionHistory() {
        return this.exceptionHistory;
    }

    public ArrayHistory getArrayAssignmentHistory() {
        return this.arrayHistory;
    }

    public ClassInitializationHistory getClassInitializationHistory() {
        return this.initializationHistory;
    }

    public InvocationHistory getInvocationHistory() {
        return this.invocationHistory;
    }

    public boolean addNarrativeExplanation(Explanation explanation) {
        return this.narrative.add(explanation);
    }

    public void removeNarrativeExplanation(Explanation explanation) {
        this.narrative.remove(explanation);
    }

    public SortedSet<Explanation> getNarrativeExplanations() {
        return Collections.unmodifiableSortedSet(this.narrative);
    }

    public ThreadIterator getThreadIteratorAt(int eventID) {
        return new ThreadIterator(eventID);
    }

    public int getThreadFirstEventID(int threadID) {
        return this.threads[threadID].getFirstEventID();
    }

    public int getThreadLastEventID(int threadID) {
        return this.threads[threadID].getLastEventID();
    }

    public int getThreadEventIDNearest(int threadID, int eventID) {
        IntegerRange ranges = this.threads[threadID].eventIDs;
        if (ranges.contains(eventID)) {
            return eventID;
        }
        int rangeIndex = ranges.getRangeIndexWithValueLessThanOrEqualTo(eventID);
        return rangeIndex < 0 ? -1 : ranges.getUpperBoundOfRange(rangeIndex);
    }

    public String eventToString(int eventID) {
        if (eventID < 0) {
            return "invalid eventID";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(Util.fillOrTruncateString(this.getThreadName(this.getThreadID(eventID)), 10));
        buf.append(Util.fillOrTruncateString(Integer.toString(eventID), 10));
        buf.append(Util.fillOrTruncateString(this.getKind((int)eventID).name, 15));
        EventKind kind = this.getKind(eventID);
        if (kind.isArgument) {
            Instruction inst = this.getInstruction(eventID);
            buf.append(Instruction.getMethodString(inst.getMethod()));
            int arg = this.getArgumentLocalIDSet(eventID);
            String name = inst.getCode().getLocalIDNameRelativeToInstruction(arg, inst);
            buf.append(name);
            buf.append(" (argument ");
            buf.append(arg);
            buf.append(") = " + this.getArgumentValueDescription(eventID));
        } else if (!kind.isArtificial) {
            buf.append(this.getInstruction(eventID).toString());
        }
        return buf.toString();
    }

    public void printContextAroundEventAtIndex(int eventIndex, int context) {
        System.err.println(this.getContextAroundEventAtIndex(eventIndex, context));
    }

    public String getContextAroundEventAtIndex(int eventIndex, int context) {
        try {
            StringBuilder builder = new StringBuilder(context * 40 * 2);
            builder.append(context + " events before and after...\n");
            int startIndex = Math.max(0, eventIndex - context);
            int endIndex = Math.min(this.getNumberOfEvents(), eventIndex + context);
            int i = startIndex;
            while (i < endIndex) {
                builder.append(String.valueOf(i == eventIndex ? "*\t" : "\t") + this.eventToString(i) + "\n");
                ++i;
            }
            return builder.toString();
        }
        catch (Exception e) {
            return "[Couldn't create context because of exception during string generation.]";
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Execution of " + this.getMain().getQualifiedNameAndDescriptor());
        buf.append("\n");
        buf.append(this.metadata.getNumberOfEvents());
        buf.append(" events\n");
        return buf.toString();
    }

    private TIntIntHashMap getIntegersProduced(int eventID) {
        return this.getValueBlock(eventID).integersProduced;
    }

    private TIntLongHashMap getLongsProduced(int eventID) {
        return this.getValueBlock(eventID).longsProduced;
    }

    private TIntFloatHashMap getFloatsProduced(int eventID) {
        return this.getValueBlock(eventID).floatsProduced;
    }

    private TIntDoubleHashMap getDoublesProduced(int eventID) {
        return this.getValueBlock(eventID).doublesProduced;
    }

    private TIntIntHashMap getCharactersProduced(int eventID) {
        return this.getValueBlock(eventID).charactersProduced;
    }

    private TIntByteHashMap getBytesProduced(int eventID) {
        return this.getValueBlock(eventID).bytesProduced;
    }

    private TIntShortHashMap getShortsProduced(int eventID) {
        return this.getValueBlock(eventID).shortsProduced;
    }

    private TIntByteHashMap getBooleansProduced(int eventID) {
        return this.getValueBlock(eventID).booleansProduced;
    }

    private TIntIntHashMap getValuesByIncrementID(int eventID) {
        return this.getValueBlock(eventID).valuesByIncrementID;
    }

    private TIntIntHashMap getStartByReturnTable(int eventID) {
        return this.getCallsBlock(eventID).startIDByReturnID;
    }

    private TIntIntHashMap getStartByInvocationTable(int eventID) {
        return this.getCallsBlock(eventID).startIDByInvocationID;
    }

    private TIntIntHashMap getInvocationByStartTable(int eventID) {
        return this.getCallsBlock(eventID).invocationIDByStartID;
    }

    private TIntIntHashMap getReturnByStartTable(int eventID) {
        return this.getCallsBlock(eventID).returnIDByStartID;
    }

    private TIntIntHashMap getInitializationByInstantiationTable(int newID) {
        return this.getCallsBlock(newID).initIDByNewID;
    }

    public static TraceMetaData getMetaDataFrom(File traceDirectory) {
        try {
            return new TraceMetaData(new File(traceDirectory, "meta"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public FieldState getFieldNode(long objectID, FieldInfo field) {
        FieldState node;
        assert (objectID > 0L);
        Map<String, FieldState> map = this.fields.get(objectID);
        if (map == null) {
            map = new HashMap<String, FieldState>();
            this.fields.put(objectID, map);
        }
        if ((node = map.get(field.getDisplayName(true, -1))) == null) {
            node = new FieldState(this, objectID, field);
            map.put(field.getDisplayName(true, -1), node);
        }
        return node;
    }

    public ObjectState getObjectNode(long objectID) {
        ObjectState obj = this.objects.get(objectID);
        if (obj == null) {
            obj = new ObjectState(this, objectID);
            this.objects.put(objectID, obj);
        }
        return obj;
    }

    public File getSaveLocation(String name) {
        return new File(Whyline.getSavedTracesFolder(), name);
    }

    public boolean save(String name, Util.ProgressListener listener) throws IOException {
        Saver saver = new Saver(name, listener);
        return saver.save();
    }

    private static abstract class Block {
        protected final int firstEventID;

        public abstract void readFromDisk(File var1);

        public abstract void writeToDisk(File var1) throws IOException;

        protected abstract String getBlockName();

        public Block(int firstEventID) {
            this.firstEventID = firstEventID;
        }

        public String toString() {
            return String.valueOf(this.getBlockName()) + "[" + this.firstEventID + ", " + (this.firstEventID + 4096 - 1) + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Blocks<T extends Block> {
        private final Trace trace;
        public T[] blocks;
        private final boolean[] blocksCreated;
        private final boolean[] blocksWritten;
        private final boolean[] blocksLocked;
        private final int[] blockFrequencies;
        private int blocksInMemory;
        private final int maxBlocksInMemory;
        private final File folder;

        public Blocks(Trace trace, File blockFolder, int numberOfBlocks, int maxBlocksInMemory) {
            this.trace = trace;
            this.folder = blockFolder;
            this.maxBlocksInMemory = maxBlocksInMemory;
            this.blocksCreated = new boolean[numberOfBlocks];
            this.blocksWritten = new boolean[numberOfBlocks];
            this.blocksLocked = new boolean[numberOfBlocks];
            this.blockFrequencies = new int[numberOfBlocks];
        }

        public void markAllBlocksWritten() {
            Arrays.fill(this.blocksCreated, true);
            Arrays.fill(this.blocksWritten, true);
        }

        protected abstract T makeBlock(int var1);

        public int getNumberOfBlocks() {
            return this.blocks.length;
        }

        public File getFolder() {
            return this.folder;
        }

        public void lock(int blockID) {
            this.blocksLocked[blockID] = true;
        }

        public void unlock(int blockID) {
            this.blocksLocked[blockID] = false;
        }

        private T getBlockContaining(int eventID) {
            return this.getBlock(eventID / 4096);
        }

        private T getBlock(int blockID) {
            T block = this.blocks[blockID];
            this.blockFrequencies[blockID] = Short.MAX_VALUE;
            if (block == null) {
                int blockIDToUnload;
                int firstEventID = blockID * 4096;
                if (this.blocksInMemory + 1 > this.maxBlocksInMemory && (blockIDToUnload = this.chooseBlockIDToUnload(blockID)) >= 0) {
                    if (!this.blocksWritten[blockIDToUnload] || !this.trace.isSaved() && !this.trace.isDoneLoading()) {
                        try {
                            ((Block)this.blocks[blockIDToUnload]).writeToDisk(this.folder);
                            this.blocksWritten[blockIDToUnload] = true;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    this.blocks[blockIDToUnload] = null;
                    --this.blocksInMemory;
                }
                block = this.makeBlock(firstEventID);
                if (this.blocksCreated[blockID]) {
                    assert (this.blocksWritten[blockID]) : "Looked for block " + blockID + " but didn't find, but it says its been created, but not cached.";
                    ((Block)block).readFromDisk(this.folder);
                } else {
                    assert (!this.blocksCreated[blockID]) : "But we've already created a block for " + blockID;
                    this.blocksCreated[blockID] = true;
                }
                this.blocks[blockID] = block;
                ++this.blocksInMemory;
            }
            return block;
        }

        private int chooseBlockIDToUnload(int desiredBlockID) {
            int blockIDToUnload = -1;
            int smallestFrequency = Short.MAX_VALUE;
            int i = 0;
            while (i < this.blocks.length) {
                int freq = this.blockFrequencies[i];
                if (freq > 0) {
                    int n = i;
                    this.blockFrequencies[n] = this.blockFrequencies[n] - 1;
                }
                if (this.blocks[i] != null && i != desiredBlockID && !this.blocksLocked[i] && freq < smallestFrequency) {
                    blockIDToUnload = i;
                    smallestFrequency = freq;
                }
                ++i;
            }
            return blockIDToUnload;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CallBlocks
    extends Blocks<CallsBlock> {
        public CallBlocks(Trace trace, File folder, int numberOfBlocks, int maxBlocksInMemory) {
            super(trace, folder, numberOfBlocks, maxBlocksInMemory);
            this.blocks = new CallsBlock[numberOfBlocks];
        }

        @Override
        protected CallsBlock makeBlock(int firstEventID) {
            return new CallsBlock(firstEventID);
        }
    }

    private static class CallsBlock
    extends Block {
        private final TIntIntHashMap startIDByReturnID = new TIntIntHashMap(10);
        private final TIntIntHashMap startIDByInvocationID = new TIntIntHashMap(10);
        private final TIntIntHashMap invocationIDByStartID = new TIntIntHashMap(10);
        private final TIntIntHashMap returnIDByStartID = new TIntIntHashMap(10);
        private final TIntIntHashMap initIDByNewID = new TIntIntHashMap(10);

        public CallsBlock(int firstEventID) {
            super(firstEventID);
        }

        protected String getBlockName() {
            return "calls" + Integer.toString(this.firstEventID / 4096);
        }

        public void readFromDisk(File folder) {
            File block = new File(folder, this.getBlockName());
            try {
                DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(block), 28672));
                Util.readIntIntMap(stream, this.startIDByReturnID);
                Util.readIntIntMap(stream, this.startIDByInvocationID);
                Util.readIntIntMap(stream, this.invocationIDByStartID);
                Util.readIntIntMap(stream, this.returnIDByStartID);
                Util.readIntIntMap(stream, this.initIDByNewID);
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(0);
            }
            this.startIDByReturnID.trimToSize();
            this.startIDByInvocationID.trimToSize();
            this.invocationIDByStartID.trimToSize();
            this.returnIDByStartID.trimToSize();
            this.initIDByNewID.trimToSize();
        }

        public void writeToDisk(File folder) throws IOException {
            File block = new File(folder, this.getBlockName());
            if (block.exists()) {
                block.delete();
            }
            DataOutputStream stream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(block), 28672));
            Util.writeIntIntMap(stream, this.startIDByReturnID);
            Util.writeIntIntMap(stream, this.startIDByInvocationID);
            Util.writeIntIntMap(stream, this.invocationIDByStartID);
            Util.writeIntIntMap(stream, this.returnIDByStartID);
            Util.writeIntIntMap(stream, this.initIDByNewID);
            stream.close();
        }
    }

    private static class IDBlock
    extends Block {
        private final byte[] kindIDs = new byte[4096];
        private final int[] instructionIDs = new int[4096];

        public IDBlock(int firstEventID) {
            super(firstEventID);
        }

        protected String getBlockName() {
            return "ids" + Integer.toString(this.firstEventID / 4096);
        }

        public void readFromDisk(File folder) {
            File block = new File(folder, this.getBlockName());
            assert (block.exists()) : "If we're reading the cached block from disk, then it must be there! But its not!";
            try {
                DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(block), 28672));
                int i = 0;
                while (i < 4096) {
                    this.kindIDs[i] = (byte)stream.readUnsignedByte();
                    this.instructionIDs[i] = stream.readInt();
                    ++i;
                }
                stream.close();
            }
            catch (IOException e) {
                System.err.println("Tried to read from " + block.getAbsolutePath() + " but...");
                e.printStackTrace();
                System.exit(0);
            }
        }

        public void writeToDisk(File folder) throws IOException {
            File block = new File(folder, this.getBlockName());
            if (block.exists()) {
                block.delete();
            }
            DataOutputStream stream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(block), 28672));
            int i = 0;
            while (i < 4096) {
                stream.writeByte(this.kindIDs[i]);
                stream.writeInt(this.instructionIDs[i]);
                ++i;
            }
            stream.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IDBlocks
    extends Blocks<IDBlock> {
        public IDBlocks(Trace trace, File folder, int numberOfBlocks, int maxBlocksInMemory) {
            super(trace, folder, numberOfBlocks, maxBlocksInMemory);
            this.blocks = new IDBlock[numberOfBlocks];
        }

        @Override
        protected IDBlock makeBlock(int firstEventID) {
            return new IDBlock(firstEventID);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Loader
    extends Thread {
        private int millisecondsBetweenNotification;
        private Map<String, File[]> cachedPaths;
        private Map<File, JarFile> jars;
        private String status;
        private final ReferencesWaitingForReferentToLoad<Classfile> classesWaitingForSuperclasses;
        private final ReferencesWaitingForReferentToLoad<Classfile> classesWaitingForInterfaces;
        private ArrayList<FieldrefContainer> fieldReferencesToResolve;
        private final ArrayList<Invoke> potentialThreadStarts;
        private IDBlock currentIDBlock;
        private ValueBlock currentValueBlock;
        private final GetGraphicsParser repaintParser;
        private final CreateGraphicsParser createGraphicsParser;
        private final GraphicalOutputParser graphicsParser;
        private final TextualOutputParser textParser;
        private final MouseInputParser mouseParser;
        private final KeyInputParser keyParser;
        private final WindowParser windowParser;
        private int numberOfEventsRead;
        private int numberOfClassesRead;
        private double percentOfIOAnalyzed;
        private double percentOfCallsAnalyzed;
        private double percentOfGraphicsParsed;

        public Loader(int msPerNotification) throws IOException {
            super("Whyline trace loader");
            this.millisecondsBetweenNotification = 200;
            this.cachedPaths = new HashMap<String, File[]>();
            this.jars = new HashMap<File, JarFile>();
            this.status = "";
            this.classesWaitingForSuperclasses = new ReferencesWaitingForReferentToLoad();
            this.classesWaitingForInterfaces = new ReferencesWaitingForReferentToLoad();
            this.fieldReferencesToResolve = new ArrayList(10000);
            this.potentialThreadStarts = new ArrayList(10);
            this.repaintParser = new GetGraphicsParser(Trace.this);
            this.createGraphicsParser = new CreateGraphicsParser(Trace.this);
            this.graphicsParser = new GraphicalOutputParser(Trace.this);
            this.textParser = new TextualOutputParser(Trace.this);
            this.mouseParser = new MouseInputParser(Trace.this);
            this.keyParser = new KeyInputParser(Trace.this);
            this.windowParser = new WindowParser(Trace.this);
            this.numberOfEventsRead = 0;
            this.numberOfClassesRead = 0;
            this.percentOfIOAnalyzed = 0.0;
            this.percentOfCallsAnalyzed = 0.0;
            this.percentOfGraphicsParsed = 0.0;
            this.millisecondsBetweenNotification = msPerNotification;
            this.setPriority(10);
        }

        private double getPercentOfEventsLoaded() {
            return (double)this.numberOfEventsRead / (double)Trace.this.getNumberOfEvents();
        }

        private double getPercentOfClassesLoaded() {
            return (double)this.numberOfClassesRead / (double)Trace.this.getNumberOfClasses();
        }

        public double getPercentLoaded() {
            if (Trace.this.isSaved()) {
                return 0.6 * this.getPercentOfClassesLoaded() + 0.1 * this.percentOfCallsAnalyzed + 0.1 * this.getPercentOfEventsLoaded() + 0.1 * this.percentOfIOAnalyzed + 0.2 * this.percentOfGraphicsParsed;
            }
            return 0.2 * this.getPercentOfClassesLoaded() + 0.1 * this.percentOfCallsAnalyzed + 0.4 * this.getPercentOfEventsLoaded() + 0.2 * this.percentOfIOAnalyzed + 0.1 * this.percentOfGraphicsParsed;
        }

        private void printTime(long beforeTime, long count, String kind) {
        }

        @Override
        public void run() {
            this.load();
        }

        private void load() {
            Timer timer = new Timer("Trace loading progress notifier", true);
            timer.scheduleAtFixedRate(new TimerTask(){

                public void run() {
                    Trace.this.listener.loadingProgress(Loader.this.status, Loader.this.getPercentLoaded());
                }
            }, 0L, (long)this.millisecondsBetweenNotification);
            try {
                long beforeLoading = System.nanoTime();
                this.status = "Loading trace meta data...";
                Trace.this.listener.loadingMetadata();
                this.loadMeta();
                long timeBeforeEventReading = System.currentTimeMillis();
                this.loadSource();
                if (Trace.this.canceled) {
                    return;
                }
                this.numberOfClassesRead = 0;
                Trace.this.listener.loadingClassFiles();
                if (Trace.this.canceled) {
                    return;
                }
                long beforeLoadingClasses = System.nanoTime();
                this.loadClassfiles();
                if (Trace.this.canceled) {
                    return;
                }
                this.printTime(beforeLoadingClasses, this.numberOfClassesRead, "classes");
                long beforeCreatingCallGraph = System.nanoTime();
                this.associatedThreadStartsWithRunMethods();
                int callCount = Trace.this.invocations.size();
                this.createCallGraph();
                if (Trace.this.canceled) {
                    return;
                }
                this.printTime(beforeCreatingCallGraph, callCount, "calls");
                this.status = "Marking I/O...";
                this.markOutput();
                if (Trace.this.canceled) {
                    return;
                }
                this.status = "Cleaning up...";
                for (Classfile cf : Trace.this.classesByName.values()) {
                    cf.trim();
                }
                Trace.this.listener.doneLoadingClassFiles();
                this.status = "Preparing to load events...";
                this.loadObjectTypes();
                this.loadImmutables();
                if (Trace.this.canceled) {
                    return;
                }
                Trace.this.listener.doneLoadingMetadata();
                int numberOfBlocks = Trace.this.getNumberOfBlocks();
                long memoryInUse = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                long maxMemory = Runtime.getRuntime().maxMemory();
                long memoryFreeForBlocksEtc = maxMemory - memoryInUse;
                int bytesPerBlock = 65536;
                int maxBlocksInMemory = (int)((double)(memoryFreeForBlocksEtc / (long)bytesPerBlock) * 0.25);
                Trace.this.idBlocks = new IDBlocks(Trace.this, Trace.this.IDS_FOLDER, numberOfBlocks, maxBlocksInMemory);
                Trace.this.valueBlocks = new ValueBlocks(Trace.this, Trace.this.VALUES_FOLDER, numberOfBlocks, maxBlocksInMemory);
                Trace.this.callBlocks = new CallBlocks(Trace.this, Trace.this.CALLS_FOLDER, numberOfBlocks, maxBlocksInMemory);
                long beforeLoadingEvents = System.nanoTime();
                File serialHistory = new File(Trace.this.getPath(), Whyline.SERIAL_PATH);
                if (serialHistory.exists()) {
                    this.loadSerialAccessHistory();
                } else {
                    this.loadRandomAccessHistory();
                }
                if (Trace.this.canceled) {
                    return;
                }
                this.printTime(beforeLoadingEvents, Trace.this.getNumberOfEvents(), "events");
                long timeAfterEventReading = System.currentTimeMillis();
                this.windowParser.parse(new Util.ProgressListener(){

                    public void notice(String notice) {
                        Loader.this.status = notice;
                    }

                    public void progress(double percent) {
                        Loader.this.percentOfGraphicsParsed = percent;
                        if (Trace.this.listener != null) {
                            Trace.this.listener.ioEventsParsed(Loader.this.windowParser.getLastEventIDParsed());
                        }
                    }
                });
                Trace.this.listener.doneLoading(timeAfterEventReading - timeBeforeEventReading);
                timer.cancel();
                Trace.this.doneLoading = true;
                this.printTime(beforeLoading, -1L, "total");
            }
            catch (Exception e) {
                e.printStackTrace();
                Trace.this.listener.exceptionDuringLoading(e);
            }
            timer.cancel();
            System.gc();
        }

        private void associatedThreadStartsWithRunMethods() {
            for (Invoke invoke : this.potentialThreadStarts) {
                MethodInfo method;
                MethodrefInfo methodref = invoke.getMethodInvoked();
                Classfile classfile = Trace.this.getClassfileByName(methodref.getClassName());
                if (classfile == null || !classfile.isSubclassOf(QualifiedClassName.JAVA_LANG_THREAD) || (method = classfile.getDeclaredMethodByNameAndDescriptor("run()V")) == null) continue;
                method.addPotentialCaller(invoke);
            }
        }

        private File[] resolvePaths(String paths) {
            File[] resolvedPaths = this.cachedPaths.get(paths);
            if (resolvedPaths == null) {
                String[] pathStrings = paths.split(File.pathSeparator);
                resolvedPaths = new File[pathStrings.length];
                int i = 0;
                while (i < pathStrings.length) {
                    resolvedPaths[i] = new File(pathStrings[i]);
                    ++i;
                }
                if (pathStrings.length > 1) {
                    this.cachedPaths.put(paths, resolvedPaths);
                }
            }
            return resolvedPaths;
        }

        private DataInputStream getStreamForBundledClass(String classFileName, File file) throws IOException {
            ZipEntry entry;
            JarFile jar = this.jars.get(file);
            if (jar == null) {
                jar = new JarFile(file);
                this.jars.put(file, jar);
            }
            if ((entry = jar.getEntry(classFileName)) != null) {
                return new DataInputStream(jar.getInputStream(entry));
            }
            return null;
        }

        private boolean resolveClass(String internallyQualifiedClassname, String paths) throws IOException, AnalysisException, JavaSpecificationViolation {
            File[] resolvedPaths = this.resolvePaths(paths);
            String classFileName = String.valueOf(internallyQualifiedClassname.replace('/', File.separatorChar)) + ".class";
            String jarFileName = String.valueOf(internallyQualifiedClassname) + ".class";
            String[] pathStrings = paths.split(File.pathSeparator);
            File[] fileArray = resolvedPaths;
            int n = resolvedPaths.length;
            int n2 = 0;
            while (n2 < n) {
                DataInputStream data;
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    File classFilePath = new File(file, classFileName);
                    if (classFilePath.exists()) {
                        data = Util.getReaderFor(classFilePath);
                        this.loadClassfile(data);
                        data.close();
                        return true;
                    }
                } else if (file.isFile()) {
                    String filename = file.getName();
                    if (filename.endsWith(".class")) {
                        data = Util.getReaderFor(file);
                        this.loadClassfile(data);
                        data.close();
                        return true;
                    }
                    if (filename.endsWith(".jar") && (data = this.getStreamForBundledClass(jarFileName, file)) != null) {
                        this.loadClassfile(data);
                        data.close();
                        return true;
                    }
                }
                ++n2;
            }
            return false;
        }

        private void loadMeta() throws AnalysisException {
            try {
                Trace.this.metadata = new TraceMetaData(Trace.this.META);
                if (Trace.this.metadata.getNumberOfObjects() > Integer.MAX_VALUE) {
                    throw new AnalysisException(Trace.this.metadata.getNumberOfObjects() + " objects is too many objects for the Whyline to handle with a Java array.");
                }
                Trace.this.instantiationHistory = new InstantiationHistory(Trace.this, Trace.this.metadata.getNumberOfObjects());
                Trace.this.threads = new ThreadTrace[Trace.this.getNumberOfThreads()];
                int i = 0;
                while (i < Trace.this.getNumberOfThreads()) {
                    ThreadTrace thread = new ThreadTrace(Trace.this.metadata.getThreadMetaData(i));
                    assert (Trace.this.threads[thread.getThreadID()] == null);
                    ((Trace)Trace.this).threads[thread.getThreadID()] = thread;
                    ++i;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new AnalysisException("The recording's meta data was corrupted, probably because the program crashed or hung before the Whyline could record it properly.");
            }
        }

        private void createCallGraph() throws IOException {
            for (FieldrefContainer fieldReferencer : this.fieldReferencesToResolve) {
                FieldInfo field;
                Classfile classfile = Trace.this.getClassfileByName(fieldReferencer.getFieldref().getClassname());
                if (classfile == null || (field = classfile.getFieldByName(fieldReferencer.getFieldref().getName())) == null) continue;
                if (fieldReferencer instanceof Use) {
                    field.addUse((Use)((Object)fieldReferencer));
                    continue;
                }
                if (!(fieldReferencer instanceof Definition)) continue;
                field.addDefinition((Definition)((Object)fieldReferencer));
            }
            if (Trace.this.callGraphIsCached) {
                DataInputStream in = Util.getReaderFor(Trace.this.CALL_GRAPH);
                int numberOfInvocations = in.readInt();
                int i = 0;
                while (i < numberOfInvocations) {
                    Invoke invoke = (Invoke)Trace.this.getInstructionWithID(in.readInt());
                    int numberOfMethods = in.readInt();
                    int j = 0;
                    while (j < numberOfMethods) {
                        Classfile c = Trace.this.getClassfileByID(in.readInt());
                        short id = in.readShort();
                        if (c == null) {
                            throw new IOException("While trying to read cached call graph, couldn't find classfile with ID " + id);
                        }
                        c.getMethodNumber(id).addPotentialCaller(invoke);
                        ++j;
                    }
                    if (i % 1024 == 0) {
                        this.percentOfCallsAnalyzed = (double)i / (double)numberOfInvocations;
                        this.status = "Associating calls (" + Util.commas(numberOfInvocations - i) + " remaining)";
                    }
                    ++i;
                }
                in.close();
            } else {
                DataOutputStream out = Util.getWriterFor(Trace.this.CALL_GRAPH);
                Trace.this.numberOfInvocationInstructions = Trace.this.invocations.size();
                int invocationsRemaining = Trace.this.invocations.size();
                HashMap<String, MethodInfo[]> methodsByQualifiedSignature = new HashMap<String, MethodInfo[]>(1000);
                out.writeInt(Trace.this.invocations.size());
                int count = 0;
                for (Invoke invoke : Trace.this.invocations) {
                    String qualifiedSignature = invoke.getMethodInvoked().getQualfiedNameAndDescriptor();
                    MethodInfo[] methods = (MethodInfo[])methodsByQualifiedSignature.get(qualifiedSignature);
                    if (methods == null) {
                        methods = Trace.this.getMethodsFromReference(invoke);
                        methodsByQualifiedSignature.put(qualifiedSignature, methods);
                    }
                    out.writeInt(Trace.this.getInstructionIDFor(invoke));
                    out.writeInt(methods.length);
                    MethodInfo[] methodInfoArray = methods;
                    int n = methods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MethodInfo method = methodInfoArray[n2];
                        out.writeInt(Trace.this.classIDs.getIDOfClassname(method.getClassfile().getInternalName()));
                        out.writeShort(method.getDeclarationIndex());
                        method.addPotentialCaller(invoke);
                        ++n2;
                    }
                    --invocationsRemaining;
                    if (++count <= 1024) continue;
                    count = 0;
                    this.status = "Associating calls (" + Util.commas(invocationsRemaining) + " remaining)";
                    this.percentOfCallsAnalyzed = 1.0 - (double)invocationsRemaining / (double)Trace.this.invocations.size();
                }
                out.close();
            }
        }

        private void markOutput() throws IOException {
            if (Trace.this.outputIsCached) {
                DataInputStream in = Util.getReaderFor(Trace.this.OUTPUT);
                int numberOfGraphical = in.readInt();
                int i = 0;
                while (i < numberOfGraphical) {
                    Trace.this.graphicalOutput.add(Trace.this.getInstructionWithID(in.readInt()));
                    ++i;
                }
                int numberOfTextual = in.readInt();
                int i2 = 0;
                while (i2 < numberOfTextual) {
                    Trace.this.textualOutput.add(Trace.this.getInstructionWithID(in.readInt()));
                    ++i2;
                }
                int numberOfOutputAffectingFields = in.readInt();
                Trace.this.outputAffectingFields = new HashSet(numberOfOutputAffectingFields);
                int i3 = 0;
                while (i3 < numberOfOutputAffectingFields) {
                    Trace.this.outputAffectingFields.add(Trace.this.getClassfileByID(in.readInt()).getFieldNumber(in.readShort()));
                    ++i3;
                }
                int numberOfOutputAffectingMethods = in.readInt();
                Trace.this.outputAffectingMethods = new HashSet(numberOfOutputAffectingMethods);
                int i4 = 0;
                while (i4 < numberOfOutputAffectingMethods) {
                    Trace.this.outputAffectingMethods.add(Trace.this.getClassfileByID(in.readInt()).getMethodNumber(in.readShort()));
                    ++i4;
                }
                int numberOfOutputInvokingMethods = in.readInt();
                Trace.this.outputInvokingMethods = new HashSet(numberOfOutputInvokingMethods);
                int i5 = 0;
                while (i5 < numberOfOutputInvokingMethods) {
                    Trace.this.outputInvokingMethods.add(Trace.this.getClassfileByID(in.readInt()).getMethodNumber(in.readShort()));
                    ++i5;
                }
            } else {
                DataOutputStream out = Util.getWriterFor(Trace.this.OUTPUT);
                AffectsOutputAnalyzer outputAnalyzer = new AffectsOutputAnalyzer(Trace.this, new Util.ProgressListener(){

                    public void notice(String notice) {
                        Loader.this.status = notice;
                    }

                    public void progress(double percent) {
                        Loader.this.percentOfIOAnalyzed = percent;
                    }
                });
                Trace.this.outputAffectingFields = outputAnalyzer.getFieldsAffectingOutput();
                Trace.this.outputAffectingMethods = outputAnalyzer.getMethodsAffectingOutput();
                Trace.this.outputInvokingMethods = outputAnalyzer.getMethodsInvokingOutput();
                out.writeInt(Trace.this.graphicalOutput.size());
                for (Instruction inst : Trace.this.graphicalOutput) {
                    out.writeInt(Trace.this.getInstructionIDFor(inst));
                }
                out.writeInt(Trace.this.textualOutput.size());
                for (Instruction inst : Trace.this.textualOutput) {
                    out.writeInt(Trace.this.getInstructionIDFor(inst));
                }
                out.writeInt(Trace.this.outputAffectingFields.size());
                for (FieldInfo field : Trace.this.outputAffectingFields) {
                    out.writeInt(Trace.this.classIDs.getIDOfClassname(field.getClassfile().getInternalName()));
                    out.writeShort(field.getDeclarationIndex());
                }
                out.writeInt(Trace.this.outputAffectingMethods.size());
                for (MethodInfo method : Trace.this.outputAffectingMethods) {
                    out.writeInt(Trace.this.classIDs.getIDOfClassname(method.getClassfile().getInternalName()));
                    out.writeShort(method.getDeclarationIndex());
                }
                out.writeInt(Trace.this.outputInvokingMethods.size());
                for (MethodInfo method : Trace.this.outputInvokingMethods) {
                    out.writeInt(Trace.this.classIDs.getIDOfClassname(method.getClassfile().getInternalName()));
                    out.writeShort(method.getDeclarationIndex());
                }
                out.close();
            }
            for (MethodInfo method : Trace.this.outputInvokingMethods) {
                Trace.this.outputInvokingClasses.add(method.getClassfile());
            }
            for (Instruction textual : Trace.this.textualOutput) {
                this.addToHash(Trace.this.textualOutputByMethodByClass, textual);
            }
            for (Instruction graphical : Trace.this.graphicalOutput) {
                this.addToHash(Trace.this.graphicalOutputByMethodByClass, graphical);
            }
        }

        private void addToHash(Map<Classfile, Map<MethodInfo, Set<Instruction>>> classes, Instruction inst) {
            Set<Instruction> set;
            MethodInfo method = inst.getMethod();
            Classfile classfile = method.getClassfile();
            Map<MethodInfo, Set<Instruction>> byMethod = classes.get(classfile);
            if (byMethod == null) {
                byMethod = new HashMap<MethodInfo, Set<Instruction>>();
                classes.put(classfile, byMethod);
            }
            if ((set = byMethod.get(method)) == null) {
                set = new HashSet<Instruction>();
                byMethod.put(method, set);
            }
            set.add(inst);
        }

        private void loadObjectTypes() throws IOException {
            DataInputStream objectTypesData = Util.getReaderFor(Trace.this.OBJECTTYPES);
            Trace.this.objectTypes = new TLongIntHashMap((int)Trace.this.OBJECTTYPES.length() / 12);
            while (objectTypesData.available() > 0) {
                long id = objectTypesData.readLong();
                int classID = objectTypesData.readInt();
                Trace.this.objectTypes.put(id, classID);
            }
            objectTypesData.close();
        }

        private void loadImmutables() throws IOException, AnalysisException {
            DataInputStream immutableData = Util.getReaderFor(Trace.this.IMMUTABLES);
            while (immutableData.available() > 0) {
                ImmutableKind type = ImmutableKind.intToType(immutableData.readUnsignedByte());
                long id = immutableData.readLong();
                Object object = type.createObject(Trace.this, immutableData);
                assert (!Trace.this.immutablesByID.containsKey(id)) : "We've already read a definition for immutable " + id + ": not replacing " + Trace.access$56(Trace.this).get(id) + " with " + object + " of type " + object.getClass();
                Trace.this.immutablesByID.put(id, object);
                Trace.this.idsOfImmutables.put(object, id);
            }
            immutableData.close();
            Trace.this.invocationHistory = new InvocationHistory(Trace.this);
        }

        private boolean loadSource() {
            ArrayList<File> files = new ArrayList<File>();
            this.gatherSource(Trace.this.SOURCE_FOLDER, files);
            for (File file : files) {
                String qualifiedName = file.getAbsolutePath().substring(Trace.this.SOURCE_FOLDER.getAbsolutePath().length() + 1).replace(File.separatorChar, '/');
                Trace.this.userSourceFiles.add(qualifiedName);
            }
            return true;
        }

        private void gatherSource(File folder, ArrayList<File> files) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().endsWith(".java")) {
                    files.add(file);
                } else if (file.isDirectory()) {
                    this.gatherSource(file, files);
                }
                ++n2;
            }
        }

        private void loadClassfiles() throws IOException {
            DataInputStream classesData = Util.getReaderFor(Trace.this.CLASSNAMES);
            HashMap<String, String> pathsByClassnames = new HashMap<String, String>(Trace.this.getNumberOfClasses());
            int i = 0;
            while (i < Trace.this.getNumberOfClasses()) {
                String classname = classesData.readUTF();
                String paths = classesData.readUTF();
                pathsByClassnames.put(classname, paths);
                ++i;
            }
            classesData.close();
            File classesFile = new File(Trace.this.TRACE_FOLDER, Whyline.CLASSES_PATH);
            if (classesFile.exists()) {
                DataInputStream in = Util.getReaderFor(classesFile);
                int classCount = in.readInt();
                int count = 0;
                int i2 = 0;
                while (i2 < classCount) {
                    try {
                        this.loadClassfile(in);
                    }
                    catch (AnalysisException e) {
                        e.printStackTrace();
                    }
                    catch (JavaSpecificationViolation e) {
                        e.printStackTrace();
                    }
                    ++this.numberOfClassesRead;
                    if (++count > 127) {
                        count = 0;
                        this.status = "Loading classes (" + Util.commas(Trace.this.getNumberOfClasses() - this.numberOfClassesRead) + " remaining)";
                    }
                    ++i2;
                }
                in.close();
            } else {
                int count = 0;
                for (String classname : pathsByClassnames.keySet()) {
                    String paths = (String)pathsByClassnames.get(classname);
                    try {
                        boolean success = this.resolveClass(classname, paths);
                        if (!success) {
                            Whyline.debug("Couldn't resolve " + classname + " from " + paths);
                        }
                    }
                    catch (AnalysisException e) {
                        e.printStackTrace();
                    }
                    catch (JavaSpecificationViolation e) {
                        e.printStackTrace();
                    }
                    ++this.numberOfClassesRead;
                    if (++count <= 127) continue;
                    count = 0;
                    this.status = "Resolving classes (" + Util.commas(Trace.this.getNumberOfClasses() - this.numberOfClassesRead) + " remaining)";
                }
            }
        }

        private Classfile loadClassfile(DataInputStream stream) throws IOException, AnalysisException, JavaSpecificationViolation {
            Iterable<Classfile> classfilesWaitingForThisInterface;
            Iterable<Classfile> classfilesWaitingForThis;
            Classfile classfile = new Classfile(stream, Trace.this);
            classfile.setStackDependenciesCache(Trace.this.stackDependenciesCache);
            if (classfile.hasSourceFileAttribute()) {
                HashSet<Classfile> unassociatedClasses = (HashSet<Classfile>)Trace.this.classesWaitingForSourceByQualifiedSourceFileName.get(classfile.getQualifiedSourceFileName());
                if (unassociatedClasses == null) {
                    unassociatedClasses = new HashSet<Classfile>();
                    Trace.this.classesWaitingForSourceByQualifiedSourceFileName.put(classfile.getQualifiedSourceFileName(), unassociatedClasses);
                }
                unassociatedClasses.add(classfile);
                if (classfile.hasSourceFileAttribute() && Trace.this.userSourceFiles.contains(classfile.getQualifiedSourceFileName())) {
                    ConstantPoolInfo[] constantPoolInfoArray = classfile.getConstantPool().getItems();
                    int n = constantPoolInfoArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ConstantPoolInfo info = constantPoolInfoArray[n2];
                        if (info instanceof ClassInfo) {
                            Iterator<ClassInfo> classname = ((ClassInfo)info).getName();
                            Trace.this.familiarClasses.add(classname);
                            ((QualifiedClassName)((Object)classname)).markAsReferencedInFamiliarClass();
                        } else if (info instanceof MethodrefInfo) {
                            Trace.this.familiarMethods.add(((MethodrefInfo)info).getQualfiedNameAndDescriptor());
                        } else if (info instanceof FieldrefInfo) {
                            Trace.this.familiarFields.add(((FieldrefInfo)info).getQualifiedName());
                        }
                        ++n2;
                    }
                }
            }
            for (MethodInfo method : classfile.getDeclaredMethods()) {
                Trace trace = Trace.this;
                trace.numberOfMethods = trace.numberOfMethods + 1;
                CodeAttribute code = method.getCode();
                if (code == null) continue;
                Instruction[] instructionArray = code.getInstructions();
                int classname = instructionArray.length;
                int n = 0;
                while (n < classname) {
                    Instruction inst = instructionArray[n];
                    Trace trace2 = Trace.this;
                    trace2.numberOfInstructions = trace2.numberOfInstructions + 1;
                    if (inst instanceof Invoke) {
                        Trace.this.invocations.add((Invoke)inst);
                        Invoke invoke = (Invoke)inst;
                        MethodrefInfo methodref = invoke.getMethodInvoked();
                        if (methodref.getMethodNameAndDescriptor().equals("start()V")) {
                            this.potentialThreadStarts.add(invoke);
                        }
                    } else if (inst instanceof FieldrefContainer) {
                        this.fieldReferencesToResolve.add((FieldrefContainer)((Object)inst));
                    } else if (inst instanceof Instantiation) {
                        QualifiedClassName classname2 = ((Instantiation)inst).getClassnameOfTypeProduced();
                        ArrayList<Instantiation> allocations = (ArrayList<Instantiation>)Trace.this.allocationsByClass.get(classname2);
                        if (allocations == null) {
                            allocations = new ArrayList<Instantiation>(5);
                            Trace.this.allocationsByClass.put(classname2, allocations);
                        }
                        allocations.add((Instantiation)inst);
                    }
                    if (!Trace.this.outputIsCached && inst.isIO()) {
                        if (TextualOutputParser.handles(Trace.this.classIDs, inst)) {
                            Trace.this.textualOutput.add(inst);
                        } else if (GraphicalOutputParser.handles(inst)) {
                            Trace.this.graphicalOutput.add(inst);
                        }
                    }
                    ++n;
                }
            }
            Trace trace = Trace.this;
            trace.numberOfFields = trace.numberOfFields + classfile.getDeclaredFields().size();
            Classfile existingClass = Trace.this.classesByName.put(classfile.getInternalName(), classfile);
            assert (existingClass == null) : "But we've already loaded a class named " + classfile.getInternalName() + ". There must be two classfiles with the same name in this trace!";
            int classID = Trace.this.classIDs.getIDOfClassname(classfile.getInternalName());
            Trace.this.classfilesByID.put(classID, classfile);
            ClassInfo superclassInfo = classfile.getSuperclassInfo();
            if (superclassInfo != null) {
                QualifiedClassName superclassName = superclassInfo.getName();
                Classfile superclass = Trace.this.getClassfileByName(superclassName);
                if (superclass == null) {
                    this.classesWaitingForSuperclasses.addReference(superclassName.getText(), classfile);
                } else {
                    classfile.setSuperclass(superclass);
                    superclass.addSubclass(classfile);
                }
            }
            if ((classfilesWaitingForThis = this.classesWaitingForSuperclasses.removeAndReturnReferencesWaitingFor(classfile.getInternalName().getText())) != null) {
                for (Classfile classfileWaiting : classfilesWaitingForThis) {
                    classfile.addSubclass(classfileWaiting);
                    classfileWaiting.setSuperclass(classfile);
                }
            }
            for (ClassInfo interfaze : classfile.getInterfacesImplemented()) {
                Classfile interfaceClassfile = Trace.this.getClassfileByName(interfaze.getName());
                if (interfaceClassfile == null) {
                    this.classesWaitingForInterfaces.addReference(interfaze.getName().getText(), classfile);
                    continue;
                }
                interfaceClassfile.addImplementor(classfile);
            }
            if (classfile.isInterface() && (classfilesWaitingForThisInterface = this.classesWaitingForInterfaces.removeAndReturnReferencesWaitingFor(classfile.getInternalName().getText())) != null) {
                for (Classfile classfileWaiting : classfilesWaitingForThisInterface) {
                    classfile.addImplementor(classfileWaiting);
                }
            }
            return classfile;
        }

        private void loadSerialAccessHistory() throws IOException {
            int n;
            Trace.this.isLoadingSerial = true;
            ThreadLoader[] loaders = new ThreadLoader[Trace.this.threads.length];
            int i = 0;
            while (i < Trace.this.threads.length) {
                loaders[i] = new ThreadLoader(Trace.this, Trace.this.threads[i]);
                ++i;
            }
            ThreadLoader thread = null;
            ThreadLoader[] threadLoaderArray = loaders;
            int n2 = loaders.length;
            int n3 = 0;
            while (n3 < n2) {
                ThreadLoader loader = threadLoaderArray[n3];
                if (loader.getNextEventID() == 0) {
                    thread = loader;
                    break;
                }
                ++n3;
            }
            assert (thread != null) : "No thread with eventID 0? What's the deal?";
            int count = 0;
            int numberOfEvents = Trace.this.getNumberOfEvents();
            int eventID = 0;
            while (eventID < numberOfEvents) {
                if (thread.getNextEventID() != eventID) {
                    thread = null;
                    ThreadLoader[] threadLoaderArray2 = loaders;
                    int n4 = loaders.length;
                    n = 0;
                    while (n < n4) {
                        ThreadLoader loader = threadLoaderArray2[n];
                        if (loader.getNextEventID() == eventID) {
                            thread = loader;
                            break;
                        }
                        ++n;
                    }
                    assert (thread != null) : "Looked for thread that contained event " + eventID + " but couldn't find it. Number of events = " + numberOfEvents;
                }
                if (eventID % 4096 == 0) {
                    int blockID = eventID / 4096;
                    if (blockID > 0) {
                        Trace.this.idBlocks.unlock(blockID - 1);
                    }
                    Trace.this.idBlocks.lock(blockID);
                    this.currentIDBlock = Trace.this.getIDBlock(eventID);
                    this.currentValueBlock = Trace.this.getValueBlock(eventID);
                }
                thread.thread.eventIDs.include(eventID);
                DataInputStream traceData = thread.data;
                int nextKindFlags = thread.nextKindFlags;
                int threadID = thread.threadID;
                assert (eventID == thread.nextEventID);
                int kindID = nextKindFlags >>> 2;
                boolean isIO = nextKindFlags << 30 >>> 31 == 1;
                int instructionID = traceData.readInt();
                int index = eventID - this.currentIDBlock.firstEventID;
                ((IDBlock)this.currentIDBlock).instructionIDs[index] = instructionID;
                ((IDBlock)this.currentIDBlock).kindIDs[index] = (byte)kindID;
                EventKind kind = EventKind.intToEvent(kindID);
                boolean loadImmediately = kind.loadImmediately;
                switch (kind) {
                    case START_METHOD: {
                        Instruction start = Trace.this.getInstruction(eventID);
                        assert (start != null) : "Couldn't find instruction for event " + eventID;
                        MethodInfo method = start.getMethod();
                        if (method.isClassInitializer()) {
                            Trace.this.initializationHistory.addClassInitializationEvent(start.getClassfile().getInternalName(), eventID);
                        }
                        Trace.this.invocationHistory.addStartID(eventID, threadID);
                        break;
                    }
                    case INVOKE_VIRTUAL: {
                        Trace.this.invocationHistory.addInvocationID(eventID);
                        Invoke virtual = (Invoke)Trace.this.getInstruction(eventID);
                        MethodrefInfo methodref = virtual.getMethodInvoked();
                        if (!methodref.getMethodName().equals("start")) break;
                        QualifiedClassName classname = methodref.getClassName();
                        if (!Trace.this.classIDs.isOrIsSubclassOf(classname, QualifiedClassName.JAVA_LANG_THREAD)) break;
                        Trace.this.runHistory.addThreadStartTime(eventID);
                        break;
                    }
                    case INVOKE_STATIC: {
                        Trace.this.invocationHistory.addInvocationID(eventID);
                        MethodrefInfo ref = ((Invoke)Trace.this.getInstruction(eventID)).getMethodInvoked();
                        if (!ref.getMethodName().equals("arraycopy") || !ref.getMethodDescriptor().equals("(Ljava/lang/Object;ILjava/lang/Object;II)V")) break;
                        Trace.this.arrayHistory.addArrayCopyID(eventID);
                        break;
                    }
                    case INVOKE_INTERFACE: {
                        Trace.this.invocationHistory.addInvocationID(eventID);
                        break;
                    }
                    case INVOKE_SPECIAL: {
                        Trace.this.invocationHistory.addInvocationID(eventID);
                        INVOKESPECIAL invoke = (INVOKESPECIAL)Trace.this.getInstruction(eventID);
                        if (!invoke.isInstanceInitializer()) break;
                        StackDependencies.Producers instanceProducers = invoke.getProducersOfArgument(0);
                        while (instanceProducers.getNumberOfProducers() == 1 && instanceProducers.getFirstProducer() instanceof Duplication) {
                            instanceProducers = instanceProducers.getFirstProducer().getProducersOfArgument(0);
                        }
                        if (instanceProducers.getNumberOfProducers() != 1 || !(instanceProducers.getFirstProducer() instanceof NEW)) break;
                        thread.initIDsWaitingForNewIDs.push(eventID);
                        break;
                    }
                    case EXCEPTION_THROWN: 
                    case EXCEPTION_CAUGHT: {
                        Trace.this.exceptionHistory.addExceptionTime(eventID);
                        break;
                    }
                    case PUTSTATIC: {
                        Trace.this.staticAssignmentHistory.addStaticAssignmentID(eventID);
                        break;
                    }
                    case PUTFIELD: {
                        Trace.this.fieldAssignmentHistory.addFieldAssignmentID(eventID);
                        break;
                    }
                    case SETARRAY: {
                        Trace.this.arrayHistory.addArrayAssignmentID(eventID);
                        break;
                    }
                    case NEW_OBJECT: {
                        long objectID = traceData.readLong();
                        Trace.this.instantiationHistory.addObjectInstantiationID(eventID, objectID);
                        Trace.this.getValueBlock(eventID).longsProduced.put(eventID, objectID);
                        QualifiedClassName classInstantiated = null;
                        QualifiedClassName classInitialized = null;
                        int initID = -1;
                        do {
                            initID = thread.initIDsWaitingForNewIDs.pop();
                            classInstantiated = ((NEW)Trace.this.getInstruction(eventID)).getClassInstantiated().getName();
                        } while ((classInitialized = ((INVOKESPECIAL)Trace.this.getInstruction(initID)).getMethodInvoked().getClassName()) != classInstantiated);
                        Trace.this.getInitializationByInstantiationTable(eventID).put(eventID, initID);
                        break;
                    }
                    case NEW_ARRAY: {
                        long arrayID = traceData.readLong();
                        this.currentValueBlock.longsProduced.put(eventID, arrayID);
                        Trace.this.instantiationHistory.addArrayInstantiationID(eventID, arrayID);
                        break;
                    }
                    case IINC: {
                        Trace.this.getValuesByIncrementID(eventID).put(eventID, traceData.readInt());
                        break;
                    }
                    case GETGRAPHICS: {
                        Trace.this.repaintArguments.put(eventID, new RepaintArguments(traceData.readBoolean(), traceData.readLong(), traceData.readLong(), traceData.readShort(), traceData.readShort(), traceData.readShort(), traceData.readShort(), traceData.readLong(), traceData.readShort(), traceData.readShort()));
                        break;
                    }
                    case CREATEGRAPHICS: {
                        Trace.this.createGraphicsArguments.put(eventID, new CreateGraphicsArguments(traceData.readLong(), traceData.readLong()));
                        break;
                    }
                    case MOUSE_EVENT: {
                        Trace.this.mouseArguments.put(eventID, new MouseArguments(traceData.readLong(), traceData.readInt(), traceData.readInt(), traceData.readInt(), traceData.readInt()));
                        break;
                    }
                    case KEY_EVENT: {
                        Trace.this.keyArguments.put(eventID, new KeyArguments(traceData.readLong(), traceData.readInt(), traceData.readInt(), traceData.readInt(), traceData.readChar(), traceData.readInt()));
                        break;
                    }
                    case WINDOW: {
                        traceData.readLong();
                        break;
                    }
                    case IMAGE_SIZE: {
                        long imageID = traceData.readLong();
                        ImageData data = (ImageData)Trace.this.imageData.get(imageID);
                        if (data == null) {
                            data = new ImageData(imageID);
                            Trace.this.imageData.put(imageID, data);
                        }
                        data.addSize(eventID, traceData.readInt(), traceData.readInt());
                        break;
                    }
                    case INTEGER_PRODUCED: 
                    case INTEGER_ARG: {
                        int integerValue = traceData.readInt();
                        if (integerValue <= Short.MAX_VALUE && integerValue >= Short.MIN_VALUE) {
                            this.currentValueBlock.shortsProduced.put(eventID, (short)integerValue);
                            break;
                        }
                        this.currentValueBlock.integersProduced.put(eventID, integerValue);
                        break;
                    }
                    case SHORT_PRODUCED: 
                    case SHORT_ARG: {
                        this.currentValueBlock.shortsProduced.put(eventID, traceData.readShort());
                        break;
                    }
                    case BYTE_PRODUCED: 
                    case BYTE_ARG: {
                        this.currentValueBlock.bytesProduced.put(eventID, traceData.readByte());
                        break;
                    }
                    case FLOAT_PRODUCED: 
                    case FLOAT_ARG: {
                        this.currentValueBlock.floatsProduced.put(eventID, traceData.readFloat());
                        break;
                    }
                    case BOOLEAN_PRODUCED: 
                    case BOOLEAN_ARG: {
                        this.currentValueBlock.booleansProduced.put(eventID, (byte)(traceData.readBoolean() ? 1 : 0));
                        break;
                    }
                    case CHARACTER_PRODUCED: 
                    case CHARACTER_ARG: {
                        this.currentValueBlock.charactersProduced.put(eventID, traceData.readChar());
                        break;
                    }
                    case DOUBLE_PRODUCED: 
                    case DOUBLE_ARG: {
                        this.currentValueBlock.doublesProduced.put(eventID, traceData.readDouble());
                        break;
                    }
                    case LONG_PRODUCED: 
                    case OBJECT_PRODUCED: 
                    case LONG_ARG: 
                    case OBJECT_ARG: {
                        MethodrefInfo mr;
                        Instruction inst;
                        long longValue = traceData.readLong();
                        if (longValue <= 32767L && longValue >= -32768L) {
                            this.currentValueBlock.shortsProduced.put(eventID, (short)longValue);
                        } else if (longValue <= Integer.MAX_VALUE && longValue >= Integer.MIN_VALUE) {
                            this.currentValueBlock.integersProduced.put(eventID, (int)longValue);
                        } else {
                            this.currentValueBlock.longsProduced.put(eventID, longValue);
                        }
                        if (kind != EventKind.OBJECT_PRODUCED || !((inst = Trace.this.getInstruction(eventID)) instanceof INVOKEVIRTUAL) || !(mr = ((INVOKEVIRTUAL)inst).getMethodInvoked()).getMethodName().equals("toCharArray") || mr.getClassName() != QualifiedClassName.JAVA_LANG_STRING) break;
                        Trace.this.arrayHistory.addToCharArrayID(eventID);
                    }
                }
                if (loadImmediately) {
                    if (thread.callStack == null) {
                        thread.callStack = new CallStack(Trace.this, threadID, eventID, new CallStack.Listener(){

                            public void foundInvocationStartPair(int invocationID, int startID) {
                                Trace.this.getInvocationByStartTable(startID).put(startID, invocationID);
                                Trace.this.getStartByInvocationTable(invocationID).put(invocationID, startID);
                            }

                            public void foundStartReturnOrCatchPair(int startID, int returnOrCatchID) {
                                Trace.this.getReturnByStartTable(startID).put(startID, returnOrCatchID);
                                Trace.this.getStartByReturnTable(returnOrCatchID).put(returnOrCatchID, startID);
                            }
                        });
                    } else {
                        thread.callStack.handleNextEventID(eventID);
                    }
                }
                if (isIO) {
                    this.handleIOEvent(eventID);
                }
                ++this.numberOfEventsRead;
                if (eventID == thread.lastEventID) {
                    thread.nextEventID = -1;
                } else {
                    thread.nextEventID();
                }
                if (thread.isDone()) {
                    thread.data.close();
                    ThreadLoader[] newLoaders = new ThreadLoader[loaders.length - 1];
                    int newIndexI = 0;
                    ThreadLoader[] threadLoaderArray3 = loaders;
                    int n5 = loaders.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        ThreadLoader loader = threadLoaderArray3[n6];
                        if (loader != thread) {
                            newLoaders[newIndexI++] = loader;
                        }
                        ++n6;
                    }
                    loaders = newLoaders;
                }
                if (++count == Short.MAX_VALUE) {
                    count = 0;
                    double fraction = this.getPercentLoaded();
                    int percent = (int)(100.0 * fraction);
                    this.status = "Reading events (" + Util.commas(Trace.this.getNumberOfEvents() - this.numberOfEventsRead) + " remaining)";
                }
                ++eventID;
            }
            Trace.this.idBlocks.unlock((Trace.this.getNumberOfEvents() - 1) / 4096);
            Trace.this.ioHistory.trimToSize();
            Trace.this.inputHistory.trimToSize();
            Trace.this.outputHistory.trimToSize();
            Trace.this.graphicsHistory.trimToSize();
            Trace.this.renderHistory.trimToSize();
            Trace.this.printsHistory.trimToSize();
            Trace.this.mouseHistory.trimToSize();
            Trace.this.fieldAssignmentHistory.trimToSize();
            Trace.this.arrayHistory.trimToSize();
            Trace.this.instantiationHistory.trimToSize();
            Trace.this.invocationHistory.trimToSize();
            ThreadTrace[] threadTraceArray = Trace.this.threads;
            n = threadTraceArray.length;
            int n7 = 0;
            while (n7 < n) {
                ThreadTrace t = threadTraceArray[n7];
                t.trimToSize();
                ++n7;
            }
            Trace.this.isLoadingSerial = false;
        }

        private void loadRandomAccessHistory() throws IOException {
            Trace.this.isLoadingSerial = false;
            Trace.this.idBlocks.markAllBlocksWritten();
            Trace.this.callBlocks.markAllBlocksWritten();
            Trace.this.valueBlocks.markAllBlocksWritten();
            File path = Trace.this.getPath();
            File ranges = new File(path, Whyline.RANGES_PATH);
            ThreadTrace[] threadTraceArray = Trace.this.threads;
            int n = threadTraceArray.length;
            int n2 = 0;
            while (n2 < n) {
                ThreadTrace t = threadTraceArray[n2];
                this.status = "Reading " + t.getName() + "...";
                t.readFromDisk(ranges);
                ++n2;
            }
            this.numberOfEventsRead = (int)(0.1 * (double)Trace.this.getNumberOfEvents());
            this.status = "Reading exceptions...";
            Util.load(Trace.this.exceptionHistory, new File(path, Whyline.EXCEPTIONS_PATH));
            this.status = "Reading global assignments...";
            Util.load(Trace.this.staticAssignmentHistory, new File(path, Whyline.STATIC_ASSIGNMENTS_PATH));
            this.status = "Reading field assignments...";
            Util.load(Trace.this.fieldAssignmentHistory, new File(path, Whyline.FIELD_ASSIGNMENTS_PATH));
            this.status = "Reading array assignments...";
            Util.load(Trace.this.arrayHistory, new File(path, Whyline.ARRAY_ASSIGNMENTS_PATH));
            this.status = "Reading instantiations...";
            Util.load(Trace.this.instantiationHistory, new File(path, Whyline.INSTANTIATIONS_PATH));
            this.status = "Reading initializations...";
            Util.load(Trace.this.initializationHistory, new File(path, Whyline.INITIALIZATIONS_PATH));
            this.status = "Reading runs...";
            Util.load(Trace.this.runHistory, new File(path, Whyline.RUNS_PATH));
            this.status = "Reading invocations...";
            Util.load(Trace.this.invocationHistory, new File(path, Whyline.INVOCATIONS_PATH));
            this.numberOfEventsRead = (int)(0.3 * (double)Trace.this.getNumberOfEvents());
            DataInputStream io = Util.getReaderFor(new File(path, Whyline.IMAGE_PATH));
            int size = io.readInt();
            Trace.this.imageData.ensureCapacity(size);
            int i = 0;
            while (i < size) {
                ImageData data = new ImageData(io);
                Trace.this.imageData.put(data.getImageID(), data);
                ++i;
            }
            io.close();
            io = Util.getReaderFor(new File(path, Whyline.KEY_PATH));
            size = io.readInt();
            Trace.this.keyArguments.ensureCapacity(size);
            i = 0;
            while (i < size) {
                Trace.this.keyArguments.put(io.readInt(), new KeyArguments(io));
                ++i;
            }
            io.close();
            io = Util.getReaderFor(new File(path, Whyline.MOUSE_PATH));
            size = io.readInt();
            Trace.this.mouseArguments.ensureCapacity(size);
            i = 0;
            while (i < size) {
                Trace.this.mouseArguments.put(io.readInt(), new MouseArguments(io));
                ++i;
            }
            io.close();
            io = Util.getReaderFor(new File(path, Whyline.REPAINT_PATH));
            size = io.readInt();
            Trace.this.repaintArguments.ensureCapacity(size);
            i = 0;
            while (i < size) {
                Trace.this.repaintArguments.put(io.readInt(), new RepaintArguments(io));
                ++i;
            }
            io.close();
            io = Util.getReaderFor(new File(path, Whyline.CREATE_PATH));
            size = io.readInt();
            Trace.this.createGraphicsArguments.ensureCapacity(size);
            i = 0;
            while (i < size) {
                Trace.this.createGraphicsArguments.put(io.readInt(), new CreateGraphicsArguments(io));
                ++i;
            }
            io.close();
            this.numberOfEventsRead = (int)(0.4 * (double)Trace.this.getNumberOfEvents());
            this.status = "Loading I/O events ...";
            io = Util.getReaderFor(new File(path, Whyline.IO_PATH));
            int count = io.readInt();
            i = 0;
            while (i < count) {
                this.handleIOEvent(io.readInt());
                if (i % 128 == 0) {
                    double percentDone = (double)i / (double)count;
                    this.numberOfEventsRead = (int)((percentDone + 0.4) * (double)Trace.this.getNumberOfEvents());
                }
                ++i;
            }
            io.close();
            this.numberOfEventsRead = Trace.this.getNumberOfEvents();
        }

        private void handleIOEvent(int eventID) {
            Trace.this.getInstruction(eventID).setIsIO();
            switch (Trace.this.getKind(eventID)) {
                case MOUSE_EVENT: {
                    this.mouseParser.handle(eventID);
                    break;
                }
                case KEY_EVENT: {
                    this.keyParser.handle(eventID);
                    break;
                }
                case GETGRAPHICS: {
                    this.repaintParser.handle(eventID);
                    break;
                }
                case CREATEGRAPHICS: {
                    this.createGraphicsParser.handle(eventID);
                    break;
                }
                case WINDOW: {
                    Trace.this.windowHistory.add(new WindowVisibilityOutputEvent(Trace.this, eventID));
                    break;
                }
                default: {
                    if (this.graphicsParser.handle(eventID)) break;
                    this.textParser.handle(eventID);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReferencesWaitingForReferentToLoad<ReferenceType> {
        private final Hashtable<String, Vector<ReferenceType>> waitersByReferentName = new Hashtable();

        public void addReference(String nameOfReferent, ReferenceType reference) {
            Vector<Object> waiters = this.waitersByReferentName.get(nameOfReferent);
            if (waiters == null) {
                waiters = new Vector();
                this.waitersByReferentName.put(nameOfReferent, waiters);
            }
            waiters.add(reference);
        }

        public Iterable<ReferenceType> removeAndReturnReferencesWaitingFor(String referentName) {
            Iterable waiters = this.waitersByReferentName.get(referentName);
            this.waitersByReferentName.remove(referentName);
            return waiters;
        }

        public int size() {
            return this.waitersByReferentName.size();
        }

        public String toString() {
            return this.waitersByReferentName.keySet().toString();
        }
    }

    private class Saver {
        private static final double FOLDER_COPYING_PROGRESS_WEIGHT = 0.35;
        private static final double BLOCK_WRITING_WEIGHT = 0.35;
        private static final double CLASS_COPYING_WEIGHT = 0.2;
        private static final double OTHER_WEIGHT = 0.1;
        private final String name;
        private final Util.ProgressListener listener;
        private final File source;
        private final File destination;
        private long lastUpdate = 0L;
        private double percentCopied = 0.0;
        private final int totalBlocks;
        private int blocksWritten = 0;
        private final int totalClasses;
        private int classesWritten = 0;
        private double percentOfOtherDataWritten = 0.0;

        public Saver(String name, Util.ProgressListener listener) {
            this.name = name;
            this.listener = listener;
            this.source = Trace.this.getPath();
            this.destination = Trace.this.getSaveLocation(name);
            this.totalBlocks = Trace.this.callBlocks.getNumberOfBlocks() + Trace.this.valueBlocks.getNumberOfBlocks() + Trace.this.idBlocks.getNumberOfBlocks();
            this.totalClasses = Trace.this.classfilesByID.size();
        }

        private void updateProgress(boolean updateNow) {
            long now = System.currentTimeMillis();
            if (updateNow || now - this.lastUpdate > 50L) {
                this.lastUpdate = now;
                this.listener.notice(this.percentCopied < 1.0 ? "Copying trace data..." : (this.blocksWritten < this.totalBlocks ? "Saving events" : (this.classesWritten < this.totalClasses ? "Writing classes (" + (this.totalClasses - this.classesWritten) + " remaining)" : "Finishing...")));
                double progress = 0.35 * this.percentCopied + 0.35 * ((double)this.blocksWritten / (double)this.totalBlocks) + 0.2 * ((double)this.classesWritten / (double)this.totalClasses) + 0.1 * this.percentOfOtherDataWritten;
                this.listener.progress(progress);
            }
        }

        public boolean save() throws IOException {
            if (this.destination.exists()) {
                return false;
            }
            this.destination.mkdir();
            if (!Whyline.getSavedTracesFolder().exists()) {
                Whyline.getSavedTracesFolder().mkdir();
            }
            this.listener.notice("Copying folder...");
            Util.copyFolder(this.source, this.destination, new Util.ProgressListener(){

                public void progress(double percent) {
                    Saver.this.percentCopied = percent;
                    Saver.this.updateProgress(true);
                }

                public void notice(String notice) {
                }
            });
            try {
                Util.deleteFolder(new File(this.destination, Whyline.SERIAL_PATH));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            File ids = new File(this.destination, Whyline.IDS_PATH);
            File calls = new File(this.destination, Whyline.CALLS_PATH);
            File values = new File(this.destination, Whyline.VALUES_PATH);
            ids.mkdirs();
            int i = 0;
            while (i < Trace.this.idBlocks.getNumberOfBlocks()) {
                ((IDBlock)((Blocks)Trace.this.idBlocks).getBlock(i)).writeToDisk(ids);
                ++this.blocksWritten;
                this.updateProgress(false);
                ++i;
            }
            calls.mkdirs();
            i = 0;
            while (i < Trace.this.callBlocks.getNumberOfBlocks()) {
                ((CallsBlock)((Blocks)Trace.this.callBlocks).getBlock(i)).writeToDisk(calls);
                ++this.blocksWritten;
                this.updateProgress(false);
                ++i;
            }
            values.mkdirs();
            i = 0;
            while (i < Trace.this.valueBlocks.getNumberOfBlocks()) {
                ((ValueBlock)((Blocks)Trace.this.valueBlocks).getBlock(i)).writeToDisk(values);
                ++this.blocksWritten;
                this.updateProgress(false);
                ++i;
            }
            this.listener.notice("Writing classes...");
            File classesFile = new File(this.destination, Whyline.CLASSES_PATH);
            DataOutputStream out = Util.getWriterFor(classesFile);
            out.writeInt(Trace.this.classfilesByID.size());
            Object[] objectArray = Trace.this.classfilesByID.getValues();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                ((Classfile)o).writeToStream(out);
                ++this.classesWritten;
                this.updateProgress(false);
                ++n2;
            }
            out.close();
            File rangesFolder = new File(this.destination, Whyline.RANGES_PATH);
            rangesFolder.mkdir();
            ThreadTrace[] threadTraceArray = Trace.this.threads;
            int n3 = threadTraceArray.length;
            n = 0;
            while (n < n3) {
                ThreadTrace t = threadTraceArray[n];
                t.writeToDisk(rangesFolder);
                ++n;
            }
            this.percentOfOtherDataWritten = 0.2;
            this.updateProgress(true);
            this.listener.notice("Saving exceptions...");
            Util.save(Trace.this.exceptionHistory, new File(this.destination, Whyline.EXCEPTIONS_PATH));
            this.listener.notice("Saving global assignments...");
            Util.save(Trace.this.staticAssignmentHistory, new File(this.destination, Whyline.STATIC_ASSIGNMENTS_PATH));
            this.listener.notice("Saving field assignments...");
            Util.save(Trace.this.fieldAssignmentHistory, new File(this.destination, Whyline.FIELD_ASSIGNMENTS_PATH));
            this.listener.notice("Saving array assignments...");
            Util.save(Trace.this.arrayHistory, new File(this.destination, Whyline.ARRAY_ASSIGNMENTS_PATH));
            this.listener.notice("Saving instantiations...");
            Util.save(Trace.this.instantiationHistory, new File(this.destination, Whyline.INSTANTIATIONS_PATH));
            this.listener.notice("Saving initializations...");
            Util.save(Trace.this.initializationHistory, new File(this.destination, Whyline.INITIALIZATIONS_PATH));
            this.listener.notice("Saving runs...");
            Util.save(Trace.this.runHistory, new File(this.destination, Whyline.RUNS_PATH));
            this.percentOfOtherDataWritten = 0.4;
            this.updateProgress(true);
            this.listener.notice("Saving invocations...");
            Util.save(Trace.this.invocationHistory, new File(this.destination, Whyline.INVOCATIONS_PATH));
            this.percentOfOtherDataWritten = 0.7;
            this.updateProgress(true);
            this.listener.notice("Saving I/O...");
            Util.save(Trace.this.ioHistory, new File(this.destination, Whyline.IO_PATH));
            this.percentOfOtherDataWritten = 0.8;
            this.updateProgress(true);
            new File(this.destination, Whyline.ARGUMENTS_PATH).mkdirs();
            DataOutputStream io = Util.getWriterFor(new File(this.destination, Whyline.IMAGE_PATH));
            io.writeInt(Trace.this.imageData.size());
            TLongObjectIterator images = Trace.this.imageData.iterator();
            while (images.hasNext()) {
                images.advance();
                ((ImageData)images.value()).write(io);
            }
            io.close();
            io = Util.getWriterFor(new File(this.destination, Whyline.KEY_PATH));
            io.writeInt(Trace.this.keyArguments.size());
            TIntObjectIterator keys = Trace.this.keyArguments.iterator();
            while (keys.hasNext()) {
                keys.advance();
                io.writeInt(keys.key());
                ((KeyArguments)keys.value()).write(io);
            }
            io.close();
            io = Util.getWriterFor(new File(this.destination, Whyline.MOUSE_PATH));
            io.writeInt(Trace.this.mouseArguments.size());
            TIntObjectIterator mouses = Trace.this.mouseArguments.iterator();
            while (mouses.hasNext()) {
                mouses.advance();
                io.writeInt(mouses.key());
                ((MouseArguments)mouses.value()).write(io);
            }
            io.close();
            io = Util.getWriterFor(new File(this.destination, Whyline.REPAINT_PATH));
            io.writeInt(Trace.this.repaintArguments.size());
            mouses = Trace.this.repaintArguments.iterator();
            while (mouses.hasNext()) {
                mouses.advance();
                io.writeInt(mouses.key());
                ((RepaintArguments)mouses.value()).write(io);
            }
            io.close();
            io = Util.getWriterFor(new File(this.destination, Whyline.CREATE_PATH));
            io.writeInt(Trace.this.createGraphicsArguments.size());
            mouses = Trace.this.createGraphicsArguments.iterator();
            while (mouses.hasNext()) {
                mouses.advance();
                io.writeInt(mouses.key());
                ((CreateGraphicsArguments)mouses.value()).write(io);
            }
            io.close();
            this.percentOfOtherDataWritten = 1.0;
            this.updateProgress(true);
            return true;
        }
    }

    public static abstract class SearchCriteria {
        public abstract boolean matches(int var1);
    }

    public final class ThreadIterator {
        private final ThreadTrace thread;
        private final int firstID;
        private final IntegerRange eventIDs;
        private int range;
        private int lower;
        private int upper;
        private int last;
        private int value;
        private int startID = -1;
        private int cachedNextInMethodID = -1;

        public ThreadIterator(int eventID) {
            this.firstID = eventID;
            this.thread = Trace.this.threads[Trace.this.getThreadID(eventID)];
            this.eventIDs = this.thread.eventIDs;
            this.last = this.thread.getLastEventID();
            this.jumpTo(eventID);
        }

        private int getStartID() {
            if (this.startID == -1) {
                this.startID = Trace.this.getStartID(this.firstID);
            }
            return this.startID;
        }

        public int current() {
            return this.value;
        }

        public boolean hasNextInThread() {
            return this.value + 1 <= this.upper || this.eventIDs.hasRange(this.range + 1);
        }

        public boolean hasPreviousInThread() {
            return this.value - 1 >= this.lower || this.eventIDs.hasRange(this.range - 1);
        }

        public boolean hasNextInMethod() {
            if (!this.hasNextInThread()) {
                return false;
            }
            if (Trace.this.getKind(this.value) == EventKind.RETURN) {
                return false;
            }
            int current = this.value;
            int next = this.nextInThread();
            boolean hasNext = true;
            while (Trace.this.getKind(this.value) == EventKind.START_METHOD) {
                MethodInfo method = Trace.this.getInstruction(this.value).getMethod();
                int returnID = Trace.this.getStartIDsReturnOrCatchID(this.value);
                if (returnID >= 0) {
                    EventKind returnKind = Trace.this.getKind(returnID);
                    if (returnKind == EventKind.RETURN) {
                        this.jumpTo(returnID);
                        if (this.hasNextInThread()) {
                            this.nextInThread();
                            continue;
                        }
                        hasNext = false;
                        break;
                    }
                    if (returnKind == EventKind.EXCEPTION_CAUGHT && Trace.this.getStartID(returnID) == this.getStartID()) {
                        this.jumpTo(returnID);
                        continue;
                    }
                    hasNext = false;
                    break;
                }
                hasNext = false;
                break;
            }
            this.cachedNextInMethodID = hasNext ? this.value : -1;
            this.jumpTo(current);
            return hasNext;
        }

        public boolean hasPreviousInMethod() {
            return this.hasPreviousInThread() && this.value > this.getStartID();
        }

        public int nextInMethod() {
            if (this.cachedNextInMethodID >= 0) {
                this.jumpTo(this.cachedNextInMethodID);
            } else {
                this.nextInThread();
                while (Trace.this.getKind(this.value) == EventKind.START_METHOD) {
                    MethodInfo method = Trace.this.getInstruction(this.value).getMethod();
                    int returnID = Trace.this.getStartIDsReturnOrCatchID(this.value);
                    if (returnID >= 0) {
                        EventKind returnKind = Trace.this.getKind(returnID);
                        if (returnKind == EventKind.RETURN) {
                            this.jumpTo(returnID);
                            this.nextInThread();
                            continue;
                        }
                        if (returnKind == EventKind.EXCEPTION_CAUGHT && Trace.this.getStartID(returnID) == this.getStartID()) {
                            this.jumpTo(returnID);
                            continue;
                        }
                        throw new NoSuchElementException("There is no next event in this method.");
                    }
                    throw new NoSuchElementException("There is no next event in this method.");
                }
            }
            return this.value;
        }

        public int previousInMethod() {
            if (Trace.this.getKind(this.value) == EventKind.EXCEPTION_CAUGHT) {
                int previous;
                MethodInfo method = Trace.this.getInstruction(this.firstID).getMethod();
                while (Trace.this.getInstruction(previous = this.previousInThread()).getMethod() != method) {
                }
                return this.value;
            }
            int previous = this.previousInThread();
            while (Trace.this.getKind(previous) == EventKind.RETURN) {
                int startID = Trace.this.getReturnStartID(previous);
                if (startID < 0) {
                    throw new RuntimeException("How can we not know the start ID of the return " + previous);
                }
                if (startID == this.getStartID()) break;
                this.jumpTo(startID);
                if (!this.hasPreviousInThread()) break;
                previous = this.previousInThread();
            }
            return this.value;
        }

        public int nextInThread() {
            if (this.value + 1 <= this.upper) {
                ++this.value;
            } else {
                ++this.range;
                this.lower = this.eventIDs.getLowerBoundOfRange(this.range);
                this.upper = this.eventIDs.getUpperBoundOfRange(this.range);
                this.value = this.lower;
            }
            return this.value;
        }

        public int previousInThread() {
            if (this.value - 1 >= this.lower) {
                --this.value;
            } else {
                --this.range;
                this.lower = this.eventIDs.getLowerBoundOfRange(this.range);
                this.value = this.upper = this.eventIDs.getUpperBoundOfRange(this.range);
            }
            return this.value;
        }

        public void jumpTo(int eventID) {
            this.range = this.eventIDs.getRangeIndexContaining(eventID);
            assert (this.range >= 0) : eventID + " does not occur in the given thread. There must be a bug.";
            this.lower = this.eventIDs.getLowerBoundOfRange(this.range);
            this.upper = this.eventIDs.getUpperBoundOfRange(this.range);
            this.value = eventID;
        }
    }

    private static class ThreadLoader {
        private final Trace trace;
        private final ThreadTrace thread;
        private final int threadID;
        private final String name;
        private final DataInputStream data;
        private int nextKindFlags = -1;
        private int nextEventID = -1;
        private boolean threadSwitch;
        public final int lastEventID;
        private CallStack callStack;
        private IntegerVector newIDsWaitingForObjectIDs = new IntegerVector(20);
        private IntegerVector initIDsWaitingForNewIDs = new IntegerVector(20);

        public ThreadLoader(Trace trace, ThreadTrace thread) throws IOException {
            this.trace = trace;
            this.thread = thread;
            this.threadID = thread.getThreadID();
            this.lastEventID = thread.getLastEventID();
            this.name = thread.getName();
            this.data = new DataInputStream(new BufferedInputStream(new FileInputStream(thread.getSerialFile()), 65536));
            if (this.data.available() > 0) {
                this.nextEventID();
            }
            if (((ThreadTrace)thread).metadata.lastEventID < ((ThreadTrace)thread).metadata.firstEventID) {
                this.nextEventID = -1;
            }
            if (this.threadID >= Short.MAX_VALUE) {
                throw new RuntimeException("Reached maximum number of threads 32767");
            }
        }

        public boolean isDone() {
            return this.nextEventID < 0 || this.nextEventID > this.lastEventID;
        }

        public int getNextEventID() {
            return this.nextEventID;
        }

        private void nextEventID() throws IOException {
            this.nextKindFlags = this.data.readUnsignedByte();
            this.threadSwitch = this.switched(this.nextKindFlags);
            this.nextEventID = this.threadSwitch ? this.data.readInt() : ++this.nextEventID;
        }

        private boolean switched(int kindFlags) {
            return kindFlags << 31 >>> 31 == 1;
        }

        private int getPlaceholderIDFor(int classAndInstructionID) {
            int placeholder = -1;
            int index = this.newIDsWaitingForObjectIDs.size() - 1;
            while (index >= 0) {
                int candidate = this.newIDsWaitingForObjectIDs.get(index);
                if (this.trace.getInstructionID(candidate) == classAndInstructionID) {
                    placeholder = candidate;
                    this.newIDsWaitingForObjectIDs.removeValueAt(index);
                    break;
                }
                --index;
            }
            return placeholder;
        }
    }

    private class ThreadTrace
    implements Saveable {
        private final ThreadMetaData metadata;
        private final IntegerRange eventIDs;

        public ThreadTrace(ThreadMetaData meta) throws IOException {
            assert (meta != null);
            this.metadata = meta;
            this.eventIDs = new IntegerRange(this.metadata.numberOfEventsInThread / 3);
        }

        public int getThreadID() {
            return this.metadata.threadID;
        }

        public String getName() {
            return this.metadata.name;
        }

        public int getFirstEventID() {
            return this.eventIDs.getFirst();
        }

        public int getLastEventID() {
            return this.metadata.lastEventID;
        }

        public void trimToSize() {
            this.eventIDs.trimToSize();
        }

        public File getSerialFile() {
            return new File(Trace.this.SERIAL_THREAD_TRACES_FOLDER, String.valueOf(this.getName()) + ".history");
        }

        public void readFromDisk(File folder) throws IOException {
            Util.load(this, new File(folder, this.getName()));
        }

        public void writeToDisk(File folder) throws IOException {
            Util.save(this, new File(folder, this.getName()));
        }

        public String toString() {
            return this.metadata.toString();
        }

        public void write(DataOutputStream out) throws IOException {
            this.eventIDs.write(out);
        }

        public void read(DataInputStream in) throws IOException {
            this.eventIDs.read(in);
        }
    }

    private static class ValueBlock
    extends Block {
        private final TIntIntHashMap integersProduced = new TIntIntHashMap(10);
        private final TIntLongHashMap longsProduced = new TIntLongHashMap(10);
        private final TIntFloatHashMap floatsProduced = new TIntFloatHashMap(10);
        private final TIntDoubleHashMap doublesProduced = new TIntDoubleHashMap(10);
        private final TIntIntHashMap charactersProduced = new TIntIntHashMap(10);
        private final TIntByteHashMap bytesProduced = new TIntByteHashMap(10);
        private final TIntShortHashMap shortsProduced = new TIntShortHashMap(10);
        private final TIntByteHashMap booleansProduced = new TIntByteHashMap(10);
        private final TIntIntHashMap valuesByIncrementID = new TIntIntHashMap(10);

        public ValueBlock(int firstEventID) {
            super(firstEventID);
        }

        protected String getBlockName() {
            return "values" + Integer.toString(this.firstEventID / 4096);
        }

        public void readFromDisk(File folder) {
            File block = new File(folder, this.getBlockName());
            assert (block.exists()) : "If we're reading the cached block from disk, then it must be there! But its not!";
            try {
                DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(block), 28672));
                Util.readIntIntMap(stream, this.integersProduced);
                int size = stream.readInt();
                this.longsProduced.ensureCapacity(size);
                int i = 0;
                while (i < size) {
                    this.longsProduced.put(stream.readInt(), stream.readLong());
                    ++i;
                }
                size = stream.readInt();
                this.floatsProduced.ensureCapacity(size);
                i = 0;
                while (i < size) {
                    this.floatsProduced.put(stream.readInt(), stream.readFloat());
                    ++i;
                }
                size = stream.readInt();
                this.doublesProduced.ensureCapacity(size);
                i = 0;
                while (i < size) {
                    this.doublesProduced.put(stream.readInt(), stream.readDouble());
                    ++i;
                }
                size = stream.readInt();
                this.charactersProduced.ensureCapacity(size);
                i = 0;
                while (i < size) {
                    this.charactersProduced.put(stream.readInt(), stream.readChar());
                    ++i;
                }
                size = stream.readInt();
                this.bytesProduced.ensureCapacity(size);
                i = 0;
                while (i < size) {
                    this.bytesProduced.put(stream.readInt(), stream.readByte());
                    ++i;
                }
                size = stream.readInt();
                this.shortsProduced.ensureCapacity(size);
                i = 0;
                while (i < size) {
                    this.shortsProduced.put(stream.readInt(), stream.readShort());
                    ++i;
                }
                size = stream.readInt();
                this.booleansProduced.ensureCapacity(size);
                i = 0;
                while (i < size) {
                    this.booleansProduced.put(stream.readInt(), stream.readByte());
                    ++i;
                }
                Util.readIntIntMap(stream, this.valuesByIncrementID);
                stream.close();
            }
            catch (IOException e) {
                System.err.println("Tried to read from " + block.getAbsolutePath() + " but...");
                e.printStackTrace();
                System.exit(0);
            }
            this.integersProduced.trimToSize();
            this.longsProduced.trimToSize();
            this.floatsProduced.trimToSize();
            this.doublesProduced.trimToSize();
            this.charactersProduced.trimToSize();
            this.bytesProduced.trimToSize();
            this.shortsProduced.trimToSize();
            this.booleansProduced.trimToSize();
            this.valuesByIncrementID.trimToSize();
        }

        public void writeToDisk(File folder) throws IOException {
            int key;
            File block = new File(folder, this.getBlockName());
            if (block.exists()) {
                return;
            }
            DataOutputStream stream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(block), 28672));
            Util.writeIntIntMap(stream, this.integersProduced);
            stream.writeInt(this.longsProduced.size());
            int[] nArray = this.longsProduced.keys();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                key = nArray[n2];
                stream.writeInt(key);
                stream.writeLong(this.longsProduced.get(key));
                ++n2;
            }
            stream.writeInt(this.floatsProduced.size());
            nArray = this.floatsProduced.keys();
            n = nArray.length;
            n2 = 0;
            while (n2 < n) {
                key = nArray[n2];
                stream.writeInt(key);
                stream.writeFloat(this.floatsProduced.get(key));
                ++n2;
            }
            stream.writeInt(this.doublesProduced.size());
            nArray = this.doublesProduced.keys();
            n = nArray.length;
            n2 = 0;
            while (n2 < n) {
                key = nArray[n2];
                stream.writeInt(key);
                stream.writeDouble(this.doublesProduced.get(key));
                ++n2;
            }
            stream.writeInt(this.charactersProduced.size());
            nArray = this.charactersProduced.keys();
            n = nArray.length;
            n2 = 0;
            while (n2 < n) {
                key = nArray[n2];
                stream.writeInt(key);
                stream.writeChar(this.charactersProduced.get(key));
                ++n2;
            }
            stream.writeInt(this.bytesProduced.size());
            nArray = this.bytesProduced.keys();
            n = nArray.length;
            n2 = 0;
            while (n2 < n) {
                key = nArray[n2];
                stream.writeInt(key);
                stream.writeByte(this.bytesProduced.get(key));
                ++n2;
            }
            stream.writeInt(this.shortsProduced.size());
            nArray = this.shortsProduced.keys();
            n = nArray.length;
            n2 = 0;
            while (n2 < n) {
                key = nArray[n2];
                stream.writeInt(key);
                stream.writeShort(this.shortsProduced.get(key));
                ++n2;
            }
            stream.writeInt(this.booleansProduced.size());
            nArray = this.booleansProduced.keys();
            n = nArray.length;
            n2 = 0;
            while (n2 < n) {
                key = nArray[n2];
                stream.writeInt(key);
                stream.writeByte(this.booleansProduced.get(key));
                ++n2;
            }
            Util.writeIntIntMap(stream, this.valuesByIncrementID);
            stream.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValueBlocks
    extends Blocks<ValueBlock> {
        public ValueBlocks(Trace trace, File folder, int numberOfBlocks, int maxBlocksInMemory) {
            super(trace, folder, numberOfBlocks, maxBlocksInMemory);
            this.blocks = new ValueBlock[numberOfBlocks];
        }

        @Override
        protected ValueBlock makeBlock(int firstEventID) {
            return new ValueBlock(firstEventID);
        }
    }
}

