/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace;

import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.util.IntegerVector;
import edu.cmu.hcii.whyline.util.Saveable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ThreadStartHistory
implements Saveable {
    private final Trace trace;
    private IntegerVector threadStarts = new IntegerVector(100);

    public ThreadStartHistory(Trace trace) {
        this.trace = trace;
    }

    public void addThreadStartTime(int timeOfThreadStart) {
        this.threadStarts.append(timeOfThreadStart);
    }

    public int getMostRecentExecutionOfBefore(Invoke threadStart, int eventID) {
        int i = this.threadStarts.size() - 1;
        while (i >= 0) {
            int id = this.threadStarts.get(i);
            if (id < eventID && this.trace.getInstruction(id) == threadStart) {
                return id;
            }
            --i;
        }
        return -1;
    }

    public void write(DataOutputStream out) throws IOException {
        this.threadStarts.write(out);
    }

    public void read(DataInputStream in) throws IOException {
        this.threadStarts.read(in);
    }
}

