/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace;

import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.util.Saveable;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ClassInitializationHistory
implements Saveable {
    private final Trace trace;
    private final TObjectIntHashMap<QualifiedClassName> initializationIDsByClassname = new TObjectIntHashMap();

    public ClassInitializationHistory(Trace trace) {
        this.trace = trace;
    }

    public void addClassInitializationEvent(QualifiedClassName classname, int eventID) {
        this.initializationIDsByClassname.put(classname, eventID);
    }

    public int getClassInitializationEventFor(QualifiedClassName classname) {
        return this.initializationIDsByClassname.get(classname);
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.initializationIDsByClassname.size());
        Object[] objectArray = this.initializationIDsByClassname.keys();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object name = objectArray[n2];
            out.writeUTF(((QualifiedClassName)name).getText());
            out.writeInt(this.initializationIDsByClassname.get((QualifiedClassName)name));
            ++n2;
        }
    }

    public void read(DataInputStream in) throws IOException {
        int size = in.readInt();
        this.initializationIDsByClassname.ensureCapacity(size);
        int i = 0;
        while (i < size) {
            this.initializationIDsByClassname.put(QualifiedClassName.get(in.readUTF()), in.readInt());
            ++i;
        }
        this.initializationIDsByClassname.trimToSize();
    }
}

