/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace;

import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.trace.Trace;

public class CallStackEntry {
    private final Trace trace;
    private final MethodInfo method;
    private final int callerID;
    private final int startEventID;

    public CallStackEntry(Trace trace, MethodInfo method, int invocationID, int startID) {
        this.trace = trace;
        this.method = method;
        this.callerID = invocationID;
        this.startEventID = startID;
    }

    public int getInvocationID() {
        return this.callerID;
    }

    public int getStartEventID() {
        return this.startEventID;
    }

    public MethodInfo getMethod() {
        return this.method;
    }

    public QualifiedClassName getClassnameInvokedOn() {
        QualifiedClassName type = this.method.getClassfile().getInternalName();
        if (this.callerID >= 0) {
            type = this.trace.getInvocationClassInvokedOn(this.callerID);
        }
        return type;
    }

    public String toString() {
        QualifiedClassName type = this.getClassnameInvokedOn();
        return type + "." + this.method.getMethodNameAndDescriptor();
    }
}

