/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.source;

import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.source.FileInterface;
import edu.cmu.hcii.whyline.source.LineNumber;
import edu.cmu.hcii.whyline.source.ParseException;
import edu.cmu.hcii.whyline.source.Token;
import edu.cmu.hcii.whyline.source.TokenRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Line
implements Comparable<Line> {
    private final LineNumber lineNumber;
    private final FileInterface file;
    private ArrayList<Token> tokens = new ArrayList(10);
    private int numberOfCharacters = 0;

    public Line(LineNumber lineNumber, Token ... newTokens) {
        this.lineNumber = lineNumber;
        this.file = lineNumber.getFile();
        Token[] tokenArray = newTokens;
        int n = newTokens.length;
        int n2 = 0;
        while (n2 < n) {
            Token t = tokenArray[n2];
            this.addToken(t);
            ++n2;
        }
    }

    public static Line createBlankLine(LineNumber lineNumber) {
        Line newLine = new Line(lineNumber, new Token[0]);
        Token blank = new Token(newLine, "", 0);
        newLine.addToken(blank);
        return newLine;
    }

    public Token getToken(int index) {
        return index < 0 || index >= this.tokens.size() ? null : this.tokens.get(index);
    }

    public void addToken(Token t) {
        t.setLineIndex(this.tokens.size());
        this.tokens.add(t);
        this.numberOfCharacters += t.getText().length();
    }

    public int getNumberOfCharacters() {
        return this.numberOfCharacters;
    }

    public int getIndexOfCodeToken(Token token) {
        int index = 0;
        for (Token t : this.tokens) {
            if (t == token) {
                return index;
            }
            if (!t.isCode()) continue;
            ++index;
        }
        return -1;
    }

    public Token getFirstCodeToken() {
        for (Token token : this.tokens) {
            if (token.isWhitespaceOrComment()) continue;
            return token;
        }
        return null;
    }

    public Token getLastCodeToken() {
        Token lastNonWhitespaceToken = null;
        for (Token token : this.tokens) {
            if (token.isWhitespaceOrComment()) continue;
            lastNonWhitespaceToken = token;
        }
        return lastNonWhitespaceToken;
    }

    public Line getLineAfter() throws ParseException {
        return this.file.getLine(this.getLineNumber().getNumber() + 1);
    }

    public List<Token> getTokens() {
        return Collections.unmodifiableList(this.tokens);
    }

    public Iterator<Token> iterator() {
        return this.tokens.iterator();
    }

    public SortedSet<Instruction> getInstructions() {
        return this.file.getInstructionsOnLine(this);
    }

    public Instruction getFirstInstruction() {
        SortedSet<Instruction> instructions = this.getInstructions();
        if (instructions.isEmpty()) {
            return null;
        }
        return instructions.first();
    }

    public FileInterface getFile() {
        return this.file;
    }

    public MethodInfo getMethod() {
        SortedSet<Instruction> instructions = this.getInstructions();
        if (instructions.isEmpty()) {
            return null;
        }
        return instructions.first().getMethod();
    }

    public LineNumber getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int compareTo(Line line) {
        if (this.file != line.file) {
            return this.file.getFileName().compareTo(line.file.getFileName());
        }
        return this.lineNumber.compareTo(line.lineNumber);
    }

    public void trim() {
        this.tokens.trimToSize();
    }

    public String getLineText() {
        StringBuilder builder = new StringBuilder();
        for (Token t : this.tokens) {
            builder.append(t.getText());
        }
        return builder.toString();
    }

    public String toString() {
        return String.valueOf(this.getLineNumber().toString()) + "\t" + this.getLineText();
    }

    public List<Token> getTokensAfterFirstNonWhitespaceToken() {
        ArrayList<Token> tokens = new ArrayList<Token>();
        try {
            Token token = this.getFirstCodeToken();
            while (token != null && token.getLine() == this) {
                tokens.add(token);
                token = token.getNextCodeToken();
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return tokens;
    }

    /*
     * Unable to fully structure code
     */
    public Token getCodeTokenAtOrAfter(Token token) {
        index = this.tokens.indexOf(token);
        if (index >= 0) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            token = this.tokens.get(++index);
lbl5:
            // 2 sources

            ** while (!token.isCode() && index < this.tokens.size() - 1)
        }
lbl6:
        // 1 sources

        if (token.isCode()) {
            return token;
        }
        return null;
    }

    public Token getTokenAfter(Token token) {
        int index = this.tokens.indexOf(token);
        if (index < 0 || index >= this.tokens.size() - 1) {
            return null;
        }
        return this.tokens.get(index + 1);
    }

    public Token getTokenBefore(Token token) {
        int index = this.tokens.indexOf(token);
        if (index <= 0 || index > this.tokens.size() - 1) {
            return null;
        }
        return this.tokens.get(index - 1);
    }

    public TokenRange getRange() {
        Token first = this.getFirstCodeToken();
        Token last = this.getLastCodeToken();
        if (first == null && last != null) {
            first = last;
        }
        if (last == null && first != null) {
            last = first;
        }
        if (first == null && last == null) {
            return null;
        }
        return new TokenRange(first, last);
    }

    public Token getFirstToken() {
        return this.tokens.size() > 0 ? this.tokens.get(0) : null;
    }

    public Token getLastToken() {
        return this.tokens.size() > 0 ? this.tokens.get(this.tokens.size() - 1) : null;
    }
}

