/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.source;

import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.FieldInfo;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.source.ClassBodyElement;
import edu.cmu.hcii.whyline.source.ClassElementContainer;
import edu.cmu.hcii.whyline.source.FileElement;
import edu.cmu.hcii.whyline.source.JavaElement;
import edu.cmu.hcii.whyline.source.JavaParser;
import edu.cmu.hcii.whyline.source.ParseException;
import edu.cmu.hcii.whyline.source.Token;
import edu.cmu.hcii.whyline.source.TokenRange;
import java.util.ArrayList;
import java.util.List;

public class ClassElement
extends JavaElement
implements ClassElementContainer {
    private final boolean anonymous;
    private Token name;
    private Token lastOfHeader;
    private Classfile classfile;
    private final List<ClassElement> classes = new ArrayList<ClassElement>(1);
    private final List<ClassElement> enums = new ArrayList<ClassElement>(1);
    private final List<ClassElement> interfaces = new ArrayList<ClassElement>(1);
    private final List<ClassElement> annotations = new ArrayList<ClassElement>(1);
    private final List<ClassBodyElement> methodsFields = new ArrayList<ClassBodyElement>(1);

    public ClassElement(JavaElement parent, Token first, Token last, boolean anonymous) {
        super(parent, first, last);
        this.anonymous = anonymous;
    }

    public ClassElement getEnclosingClass() {
        return this;
    }

    public void parseBlocks() {
        for (ClassElement classElement : this.classes) {
            classElement.parseBlocks();
        }
        for (ClassElement classElement : this.enums) {
            classElement.parseBlocks();
        }
        for (ClassElement classElement : this.interfaces) {
            classElement.parseBlocks();
        }
        for (ClassElement classElement : this.annotations) {
            classElement.parseBlocks();
        }
        for (ClassBodyElement classBodyElement : this.methodsFields) {
            classBodyElement.parseBlock();
        }
    }

    public TokenRange getHeaderRange() {
        return new TokenRange(this.firstToken, this.lastOfHeader);
    }

    public ClassElement getClassBySimpleName(String name) {
        this.parse();
        for (ClassBodyElement e : this.methodsFields) {
            e.parse();
        }
        for (ClassElement c : this.classes) {
            if (!c.getSimpleName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public ClassBodyElement getFieldElement(FieldInfo field) {
        this.parse();
        for (ClassBodyElement element : this.methodsFields) {
            if (element.isMethod() || !element.getNameToken().getText().equals(field.getName())) continue;
            return element;
        }
        return null;
    }

    public ClassBodyElement getMethodElement(MethodInfo method) {
        String simpleDescriptor = method.getSimpleDescriptor();
        this.parse();
        for (ClassBodyElement element : this.methodsFields) {
            if (!element.getNameToken().getText().equals(method.getJavaName()) || !element.getSimpleDescriptor().equals(simpleDescriptor)) continue;
            return element;
        }
        return null;
    }

    protected void parse(JavaParser.TokenIterator tokens) throws ParseException {
        this.optionalModifiers(tokens);
        if (this.anonymous) {
            this.classDeclaration(tokens, true);
        } else {
            Token keyword = tokens.getNext();
            switch (keyword.kind) {
                case 20: {
                    this.classDeclaration(tokens, false);
                    break;
                }
                case 27: {
                    this.enumDeclaration(tokens);
                    break;
                }
                case 40: {
                    this.interfaceDeclaration(tokens);
                    break;
                }
                case 88: {
                    this.annotationDeclaration(tokens);
                }
            }
        }
    }

    private void classDeclaration(JavaParser.TokenIterator tokens, boolean anonymous) throws ParseException {
        if (anonymous) {
            tokens.getNext(81);
        } else {
            this.name = tokens.getNext();
            this.lastOfHeader = tokens.jumpPastNext(81);
        }
        String simpleClassQualifiedName = this.getSimpleClassQualifiedName();
        FileElement file = this.getRoot();
        for (Classfile c : file.getSource().getClassfiles()) {
            if (!c.getInternalName().getSimpleClassQualifiedName().equals(simpleClassQualifiedName)) continue;
            this.classfile = c;
            break;
        }
        if (this.classfile == null) {
            System.err.println("Failed to resolve " + simpleClassQualifiedName);
        }
        while (tokens.hasNext()) {
            if (tokens.nextKindIs(82)) {
                tokens.getNext();
                break;
            }
            if (tokens.nextKindIs(85)) {
                tokens.getNext();
                continue;
            }
            if (tokens.nextKindIs(51) && tokens.peekNext().kind == 81 || tokens.nextKindIs(81)) {
                Token keyword = tokens.getNext();
                Token.PairedToken blockOpen = tokens.nextPaired(81);
                tokens.jumpPast(blockOpen.getAssociatedToken());
                continue;
            }
            Token first = tokens.peek();
            this.optionalModifiers(tokens);
            switch (tokens.peek().kind) {
                case 20: 
                case 27: 
                case 40: {
                    Token.PairedToken open = (Token.PairedToken)tokens.jumpPastNext(81);
                    Token last = open.getAssociatedToken();
                    tokens.jumpPast(last);
                    ClassElement classElement = new ClassElement(this, first, last, false);
                    this.classes.add(classElement);
                    break;
                }
                case 88: {
                    this.annotationDeclaration(tokens);
                    break;
                }
                default: {
                    Token last = tokens.getNextOr(81, 85);
                    if (last instanceof Token.PairedToken) {
                        last = ((Token.PairedToken)last).getAssociatedToken();
                        tokens.jumpPast(last);
                    }
                    ClassBodyElement el = new ClassBodyElement(this, first, last);
                    this.methodsFields.add(el);
                }
            }
        }
    }

    private void interfaceDeclaration(JavaParser.TokenIterator tokens) throws ParseException {
        this.name = tokens.getNext();
        Token.PairedToken open = (Token.PairedToken)tokens.jumpPastNext(81);
        tokens.jumpPast(open.getAssociatedToken());
    }

    private void enumDeclaration(JavaParser.TokenIterator tokens) throws ParseException {
        this.name = tokens.getNext();
        Token.PairedToken open = (Token.PairedToken)tokens.jumpPastNext(81);
        tokens.jumpPast(open.getAssociatedToken());
    }

    private void annotationDeclaration(JavaParser.TokenIterator tokens) throws ParseException {
        tokens.getNext();
        this.name = tokens.getNext();
        if (tokens.nextKindIs(79)) {
            Token.PairedToken open = tokens.nextPaired(79);
            tokens.jumpPast(open.getAssociatedToken());
        }
    }

    public String getSimpleName() {
        if (this.getNameToken() != null) {
            return this.getNameToken().getText();
        }
        ClassElement enclosing = this.parent.getEnclosingClass();
        if (enclosing == null) {
            return null;
        }
        return String.valueOf(enclosing.getIndexOf(this) + 1);
    }

    private String getSimpleClassQualifiedName() {
        ClassElement enclosing = this.parent.getEnclosingClass();
        if (enclosing == null) {
            return this.getSimpleName();
        }
        StringBuilder builder = new StringBuilder(enclosing.getSimpleClassQualifiedName());
        builder.append('$');
        builder.append(this.getSimpleName());
        return builder.toString();
    }

    public void addInnerClass(ClassElement c) {
        this.classes.add(c);
    }

    public int getIndexOf(ClassElement classElement) {
        return this.classes.indexOf(classElement);
    }

    public Token getNameToken() {
        this.parse();
        return this.name;
    }

    public Classfile getClassfile() {
        return this.classfile;
    }

    public String getJavaDoc() {
        return null;
    }

    public String toString() {
        return "ClassElement " + this.getSimpleName();
    }
}

