/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.qa;

import edu.cmu.hcii.whyline.analysis.UnexecutedInstructionAnalyzer;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.qa.Answer;
import edu.cmu.hcii.whyline.qa.Asker;
import edu.cmu.hcii.whyline.qa.ExpectedObject;
import edu.cmu.hcii.whyline.qa.MessageAnswer;
import edu.cmu.hcii.whyline.qa.WhyDidntQuestion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WhyDidntMethodExecute
extends WhyDidntQuestion<MethodInfo> {
    private final long objectID;

    public WhyDidntMethodExecute(Asker asker, MethodInfo method, long objectID, String descriptionOfEvent) {
        super(asker, method, descriptionOfEvent);
        this.objectID = objectID;
        assert (objectID > 0L) : "Must provide legal objectID: " + objectID;
        assert (method.isVirtual()) : "This question requires that the given method is an instance method.";
    }

    public long getObjectIDOfInterest() {
        return this.objectID;
    }

    @Override
    protected Answer answer() {
        if (this.scope.isEndOfProgram()) {
            return new MessageAnswer(this, "<i>Nothing</i> changed after the end of the program. Perhaps you forgot to select a specific time?");
        }
        return UnexecutedInstructionAnalyzer.explain(this, new Instruction[]{((MethodInfo)this.subject).getCode().getFirstInstruction()}, this.objectID == 0L ? null : new ExpectedObject(this.objectID, 0));
    }

    @Override
    public String getQuestionExplanation() {
        return "explain why <b>" + this.getDescriptionOfSubject() + "</b> didn't execute";
    }
}

