/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.qa;

import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.ExceptionHandler;
import edu.cmu.hcii.whyline.bytecode.GetLocal;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.bytecode.SetLocal;
import edu.cmu.hcii.whyline.bytecode.StackDependencies;
import edu.cmu.hcii.whyline.io.IOEvent;
import edu.cmu.hcii.whyline.qa.ExpectedObject;
import edu.cmu.hcii.whyline.qa.Question;
import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.trace.Value;
import edu.cmu.hcii.whyline.util.IntegerVector;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnexecutedInstruction {
    private final Instruction instruction;
    private final MethodInfo method;
    private Object cause;
    private final Set<UnexecutedInstruction> outgoing = new HashSet<UnexecutedInstruction>(16);
    private final Set<UnexecutedInstruction> incoming = new HashSet<UnexecutedInstruction>(4);
    private Reason reason = Reason.UNEXPLAINED;
    private int methodStartID = -1;
    private int methodReturnID = -1;
    private ExpectedObject callerExpectation;
    private Set<Instruction> controlDependencies;
    private final Question<?> question;
    private final Trace trace;
    private final ExpectedObject expectedObject;
    private IntegerVector executionsOnOtherObjects;
    private boolean explained = false;

    public UnexecutedInstruction(Question<?> question, Instruction instruction, ExpectedObject object) {
        this.question = question;
        this.trace = question.getTrace();
        this.instruction = instruction;
        this.method = instruction.getMethod();
        this.expectedObject = object;
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    private void addIncoming(UnexecutedInstruction inst) {
        assert (inst != null);
        this.incoming.add(inst);
        inst.outgoing.add(this);
    }

    public Collection<UnexecutedInstruction> getIncoming() {
        return this.incoming;
    }

    public Collection<UnexecutedInstruction> getOutgoing() {
        return this.outgoing;
    }

    public void setReason(Reason reason, Instruction cause) {
        this.setReasonAsObject(reason, cause);
    }

    public void setReason(Reason reason, int eventID) {
        this.setReasonAsObject(reason, eventID);
    }

    public void setReason(Reason reason, MethodInfo cause) {
        this.setReasonAsObject(reason, cause);
    }

    public void setReason(Reason reason, Set<? extends Instruction> cause) {
        this.setReasonAsObject(reason, cause);
    }

    public void setReason(Reason reason, IntegerVector causes) {
        this.setReasonAsObject(reason, causes);
    }

    private void setReasonAsObject(Reason reason, Object cause) {
        this.reason = reason;
        this.cause = cause;
    }

    public Reason getReason() {
        return this.reason;
    }

    public IntegerVector getExecutionsOnOtherObjects() {
        return this.executionsOnOtherObjects;
    }

    public int getDecidingEventID() {
        return this.cause instanceof Integer ? (Integer)this.cause : -1;
    }

    public IntegerVector getDecidingEvents() {
        return this.cause instanceof IntegerVector ? (IntegerVector)this.cause : null;
    }

    public MethodInfo getDecidingMethod() {
        return this.cause instanceof MethodInfo ? (MethodInfo)this.cause : null;
    }

    public Instruction getDecidingInstruction() {
        return this.cause instanceof Instruction ? (Instruction)this.cause : null;
    }

    public Set<? extends Instruction> getDecidingInstructions() {
        return this.cause instanceof Set ? (Set)this.cause : null;
    }

    public int getMaximumDepth() {
        return this.getMaximumDepthHelper(new HashSet<UnexecutedInstruction>());
    }

    private int getMaximumDepthHelper(Set<UnexecutedInstruction> visited) {
        if (visited.contains(this)) {
            return 0;
        }
        visited.add(this);
        if (this.incoming.isEmpty()) {
            return 1;
        }
        int maxDepth = 0;
        for (UnexecutedInstruction in : this.incoming) {
            maxDepth = Math.max(maxDepth, in.getMaximumDepthHelper(visited));
        }
        return maxDepth + 1;
    }

    private Set<Invoke> getFeasibleCallers() {
        HashSet<Invoke> feasibleCallers;
        Classfile classOfInstanceCalledOn = null;
        if (this.instruction.getMethod().isVirtual() && this.expectedObject != null && this.expectedObject.expectsSpecificArgument() && this.expectedObject.getExpectedArgument() == 0) {
            classOfInstanceCalledOn = this.trace.getClassfileOfObjectID(this.expectedObject.getExpectedObjectID());
        }
        if (classOfInstanceCalledOn == null) {
            feasibleCallers = this.instruction.getMethod().getPreciseCallers(this.trace, null);
        } else {
            feasibleCallers = new HashSet();
            for (Invoke caller : this.instruction.getMethod().getPreciseCallers(this.trace, null)) {
                if (caller.getMethodInvoked().isStatic()) {
                    feasibleCallers.add(caller);
                    continue;
                }
                if (caller.callsOnThis()) {
                    Classfile callersClass = caller.getClassfile();
                    if (classOfInstanceCalledOn != callersClass && !classOfInstanceCalledOn.isSubclassOf(callersClass.getInternalName())) continue;
                    feasibleCallers.add(caller);
                    continue;
                }
                feasibleCallers.add(caller);
            }
        }
        return feasibleCallers;
    }

    private int getIndexOfParameterSource(Instruction inst, int arg) {
        StackDependencies.Producers producers = inst.getProducersOfArgument(arg);
        int i = 0;
        while (i < producers.getNumberOfProducers()) {
            Instruction producer = producers.getProducer(i);
            if (producer instanceof GetLocal) {
                int localID = ((GetLocal)producer).getLocalID();
                List<SetLocal> definitions = inst.getMethod().getCode().getLocalDependencies().getPotentialDefinitionsOfLocalIDBefore(this.instruction, localID);
                if (definitions.isEmpty()) {
                    return this.instruction.getMethod().getArgumentNumberOfLocalID(localID);
                }
                for (SetLocal definition : definitions) {
                    int parameterIndex = this.getIndexOfParameterSource(definition, 0);
                    if (parameterIndex < 0) continue;
                    return parameterIndex;
                }
                return -1;
            }
            ++i;
        }
        return -1;
    }

    public void explain() {
        if (this.explained) {
            return;
        }
        this.explained = true;
        this.incoming.clear();
        this.callerExpectation = null;
        if (this.expectedObject == null || !this.expectedObject.expectsSpecificArgument()) {
            this.callerExpectation = this.expectedObject;
        } else {
            int parameterIndex = this.getIndexOfParameterSource(this.instruction, this.expectedObject.getExpectedArgument());
            if (parameterIndex < 0) {
                this.callerExpectation = null;
            } else {
                int arg = this.instruction.getMethod().getArgumentNumberOfLocalID(parameterIndex);
                this.callerExpectation = new ExpectedObject(this.expectedObject.getExpectedObjectID(), arg);
            }
        }
        IntegerVector methodStartIDs = this.trace.getInvocationHistory().getStartIDsOnObjectIDAfterEventID(this.method, 0L, this.question.getInputEventID());
        IntegerVector otherExecutions = new IntegerVector(2);
        if (this.callerExpectation != null) {
            int i = 0;
            while (i < methodStartIDs.size()) {
                int startID = methodStartIDs.get(i);
                int invocationID = this.trace.getStartIDsInvocationID(startID);
                if (invocationID >= 0) {
                    if (this.callerExpectation.expectsSpecificArgument()) {
                        Value value = this.trace.getOperandStackValue(invocationID, this.callerExpectation.getExpectedArgument());
                        long candidateObjectID = value.getLong();
                        if (candidateObjectID == this.callerExpectation.getExpectedObjectID()) {
                            this.methodStartID = startID;
                        } else {
                            otherExecutions.append(invocationID);
                        }
                    } else {
                        int arg = 0;
                        while (arg < this.trace.getInstruction(invocationID).getNumberOfArgumentProducers()) {
                            Value value = this.trace.getOperandStackValue(invocationID, arg);
                            long candidateObjectID = value.getLong();
                            if (this.callerExpectation.expectsObjectID(candidateObjectID)) {
                                this.methodStartID = startID;
                            } else {
                                otherExecutions.append(invocationID);
                            }
                            ++arg;
                        }
                    }
                }
                ++i;
            }
        } else if (methodStartIDs.size() > 0) {
            this.methodStartID = methodStartIDs.lastValue();
        }
        if (this.methodStartID < 0 && methodStartIDs.size() > 0) {
            this.executionsOnOtherObjects = otherExecutions;
        }
        this.methodReturnID = this.methodStartID >= 0 ? this.trace.getStartIDsReturnOrCatchID(this.methodStartID) : -1;
        boolean instructionsMethodWasExecuted = this.methodStartID >= 0;
        this.controlDependencies = this.instruction.getBranchDependencies();
        if (this.controlDependencies.size() == 1 && this.controlDependencies.iterator().next() == this.instruction) {
            this.controlDependencies = new HashSet<Instruction>(0);
        }
        if (!instructionsMethodWasExecuted) {
            this.analyzeFeasibleCallers();
        } else {
            int startTime = this.methodStartID;
            int endTime = this.methodReturnID < 0 ? this.question.getOutputEventID() : this.methodReturnID + 1;
            EventKind returnKind = this.trace.getKind(this.methodReturnID);
            int executionID = this.trace.findEventBetween(startTime, endTime, new Trace.SearchCriteria(){

                public boolean matches(int eventID) {
                    return UnexecutedInstruction.this.trace.getInstruction(eventID) == UnexecutedInstruction.this.instruction;
                }
            });
            if (executionID >= 0) {
                this.setReason(Reason.DID_EXECUTE, executionID);
            } else if (!this.exceptionInMethodJumpedOverThis()) {
                if (returnKind == EventKind.EXCEPTION_CAUGHT) {
                    this.setReason(Reason.EXCEPTION_CAUGHT, this.methodReturnID);
                } else if (!(this.methodReturnID >= 0 && returnKind != EventKind.RETURN || this.controlDependencies.isEmpty())) {
                    this.analyzeControlDependencies();
                } else {
                    this.setReason(Reason.UNKNOWN_REASON, this.instruction);
                }
            }
        }
    }

    private boolean exceptionInMethodJumpedOverThis() {
        if (!this.instruction.isInTryCatchBlock()) {
            return false;
        }
        int startID = this.methodStartID;
        int endID = this.methodReturnID < 0 ? this.question.getOutputEventID() : this.methodReturnID + 1;
        Set<ExceptionHandler> handlers = this.instruction.getExceptionHandlersProtecting();
        IntegerVector catches = this.trace.getExceptionHistory().getExceptionsCaughtBetween(startID, endID, this.trace.getThreadID(this.methodStartID));
        int i = 0;
        while (i < catches.size()) {
            for (ExceptionHandler handler : handlers) {
                int catchID = catches.get(i);
                if (handler.getHandlerPC() != this.trace.getInstruction(catchID)) continue;
                this.setReason(Reason.EXCEPTION_CAUGHT, catchID);
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean analyzeFeasibleCallers() {
        Set<Invoke> feasibleCallers = this.getFeasibleCallers();
        if (feasibleCallers.isEmpty()) {
            if (this.method.isImplicitlyInvoked()) {
                this.setReason(Reason.METHOD_DID_NOT_EXECUTE, this.method);
            } else {
                this.setReason(Reason.UNREACHABLE, this.method);
            }
            return true;
        }
        boolean callerExecuted = false;
        for (Invoke caller : feasibleCallers) {
            int invocationID;
            int i;
            IntegerVector invocations = this.trace.getInvocationHistory().findInvocationsOnObjectIDAfterEventID(caller, 0L, this.question.getInputEventID());
            if (this.callerExpectation == null) {
                if (invocations.size() <= 0) continue;
                this.setReason(Reason.DID_EXECUTE, invocations.get(invocations.size() - 1));
                callerExecuted = true;
                return true;
            }
            if (!this.callerExpectation.expectsSpecificArgument()) {
                i = 0;
                while (i < invocations.size()) {
                    invocationID = invocations.get(i);
                    int arg = 0;
                    while (arg < this.trace.getInstruction(invocationID).getNumberOfArgumentProducers()) {
                        Value value = this.trace.getOperandStackValue(invocationID, arg);
                        long candidateObjectID = value.getLong();
                        if (this.callerExpectation.expectsObjectID(candidateObjectID)) {
                            this.setReason(Reason.DID_EXECUTE, invocations.get(invocations.size() - 1));
                            callerExecuted = true;
                            return true;
                        }
                        ++arg;
                    }
                    ++i;
                }
                continue;
            }
            i = 0;
            while (i < invocations.size()) {
                invocationID = invocations.get(i);
                Value value = this.trace.getOperandStackValue(invocationID, this.callerExpectation.getExpectedArgument());
                long candidateObjectID = value.getLong();
                if (candidateObjectID == this.callerExpectation.getExpectedObjectID()) {
                    this.setReason(Reason.DID_EXECUTE, invocations.get(invocations.size() - 1));
                    callerExecuted = true;
                    return true;
                }
                ++i;
            }
        }
        boolean hasPotentialCalls = false;
        QualifiedClassName typeOfThis = this.callerExpectation == null ? null : (this.callerExpectation.expectsSpecificObjectID() ? this.trace.getClassnameOfObjectID(this.callerExpectation.getExpectedObjectID()) : null);
        for (Invoke caller : feasibleCallers) {
            if (this.method.isVirtual() && this.callerExpectation != null && this.callerExpectation.expectsSpecificArgument() && this.callerExpectation.getExpectedArgument() == 0 && this.trace.resolveMethodReference(typeOfThis, caller) == null || !this.trace.userCodeContainsInstantiationsOf(caller.getClassfile().getInternalName())) continue;
            UnexecutedInstruction callerNotExecuted = this.question.getUnexecutedInstruction(caller, this.callerExpectation);
            this.addIncoming(callerNotExecuted);
            hasPotentialCalls = true;
        }
        if (hasPotentialCalls) {
            this.setReason(Reason.METHOD_DID_NOT_EXECUTE, feasibleCallers);
        } else {
            this.setReason(Reason.UNREACHABLE, this.method);
        }
        return true;
    }

    private boolean analyzeControlDependencies() {
        Iterator<Instruction> iterator = this.controlDependencies.iterator();
        while (iterator.hasNext()) {
            Instruction branch;
            int executionID = this.trace.findEventBetween(this.methodStartID, this.methodReturnID < 0 ? this.question.getOutputEventID() : this.methodReturnID + 1, new Trace.SearchCriteria(branch = iterator.next()){
                private final /* synthetic */ Instruction val$branch;
                {
                    this.val$branch = instruction;
                }

                public boolean matches(int eventID) {
                    return UnexecutedInstruction.this.trace.getInstruction(eventID) == this.val$branch;
                }
            });
            if (executionID < 0) continue;
            IntegerVector branchDataDependencies = new IntegerVector(2);
            for (Value value : this.trace.getOperandStackDependencies(executionID)) {
                if (value.getEventID() < 0) continue;
                branchDataDependencies.append(value.getEventID());
            }
            this.setReason(Reason.WRONG_WAY, branchDataDependencies);
            return true;
        }
        this.setReason(Reason.INSTRUCTIONS_BRANCH_DID_NOT_EXECUTE, this.controlDependencies);
        for (Instruction branch : this.controlDependencies) {
            this.addIncoming(this.question.getUnexecutedInstruction(branch, this.expectedObject));
        }
        return true;
    }

    public String getVerbalExplanation() {
        if (this.reason == null) {
            return "(No reason given for why this line didn't execute)";
        }
        return this.reason.getVerbalExplanation(this.question, this.instruction);
    }

    public String toString() {
        return this.instruction + " not executed because " + (Object)((Object)this.reason);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Reason {
        UNREACHABLE{

            @Override
            public String getVerbalExplanation(Question<?> question, Instruction inst) {
                return "<b>" + inst.getMethod().getJavaName() + "()</b> has no known (loaded) callers";
            }
        }
        ,
        METHOD_DID_NOT_EXECUTE{

            @Override
            public String getVerbalExplanation(Question<?> question, Instruction inst) {
                IOEvent io = question.getInputEvent();
                return "<b>" + inst.getMethod().getJavaName() + "()</b> wasn't called";
            }
        }
        ,
        WRONG_WAY{

            @Override
            public String getVerbalExplanation(Question<?> question, Instruction inst) {
                return "The enclosing conditional went the wrong way.";
            }
        }
        ,
        INSTRUCTIONS_BRANCH_DID_NOT_EXECUTE{

            @Override
            public String getVerbalExplanation(Question<?> question, Instruction inst) {
                return "The enclosing conditional didn't execute";
            }
        }
        ,
        DID_EXECUTE{

            @Override
            public String getVerbalExplanation(Question<?> question, Instruction inst) {
                return "This line <i>did</i> execute.";
            }
        }
        ,
        EXCEPTION_CAUGHT{

            @Override
            public String getVerbalExplanation(Question<?> question, Instruction inst) {
                return "An exception jumped over this line.";
            }
        }
        ,
        UNKNOWN_REASON{

            @Override
            public String getVerbalExplanation(Question<?> question, Instruction inst) {
                return "Couldn't find a reason.";
            }
        }
        ,
        UNEXPLAINED{

            @Override
            public String getVerbalExplanation(Question<?> question, Instruction inst) {
                return "Selected to explain...";
            }
        };


        public abstract String getVerbalExplanation(Question<?> var1, Instruction var2);
    }
}

