/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.qa;

import edu.cmu.hcii.whyline.analysis.ClassUsesSearch;
import edu.cmu.hcii.whyline.analysis.FieldUsesSearch;
import edu.cmu.hcii.whyline.analysis.FindOverriders;
import edu.cmu.hcii.whyline.analysis.LocalUsesSearch;
import edu.cmu.hcii.whyline.analysis.MethodCallersSearch;
import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.CodeAttribute;
import edu.cmu.hcii.whyline.bytecode.FieldInfo;
import edu.cmu.hcii.whyline.bytecode.FieldrefContainer;
import edu.cmu.hcii.whyline.bytecode.FieldrefInfo;
import edu.cmu.hcii.whyline.bytecode.GetLocal;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.NEW;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.bytecode.SetLocal;
import edu.cmu.hcii.whyline.bytecode.StackDependencies;
import edu.cmu.hcii.whyline.qa.Asker;
import edu.cmu.hcii.whyline.qa.Question;
import edu.cmu.hcii.whyline.qa.QuestionMenu;
import edu.cmu.hcii.whyline.qa.WhyDidEventOccur;
import edu.cmu.hcii.whyline.source.JavaSourceFile;
import edu.cmu.hcii.whyline.source.Line;
import edu.cmu.hcii.whyline.source.LineNumber;
import edu.cmu.hcii.whyline.source.Parameter;
import edu.cmu.hcii.whyline.source.ParseException;
import edu.cmu.hcii.whyline.source.Token;
import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.trace.Serializer;
import edu.cmu.hcii.whyline.trace.Value;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.components.WhylineMenu;
import edu.cmu.hcii.whyline.ui.components.WhylineMenuItem;
import edu.cmu.hcii.whyline.ui.components.WhylinePopup;
import edu.cmu.hcii.whyline.ui.events.AbstractUIEvent;
import edu.cmu.hcii.whyline.ui.events.LoggedAction;
import edu.cmu.hcii.whyline.ui.events.Note;
import edu.cmu.hcii.whyline.ui.io.BreakpointDebugger;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFileMenuFactory {
    public static void addQuestionsForToken(WhylineUI whylineUI, WhylinePopup popup, Token token) {
        SourceFileMenuFactory.addPrintQuestions(whylineUI, popup, token);
        SourceFileMenuFactory.addClassQuestions(whylineUI, popup, token);
        SourceFileMenuFactory.addParameterQuestions(whylineUI, popup, token);
        SourceFileMenuFactory.addInstructionQuestions(whylineUI, popup, token);
    }

    private static void addClassQuestions(final WhylineUI whylineUI, WhylinePopup popup, Token token) {
        QualifiedClassName classname = token.getFile().getClassnameFor(token);
        if (classname != null) {
            Classfile classfile;
            WhylineMenu menu = new WhylineMenu("class " + classname.getSimpleName());
            if (classname.isArray()) {
                classname = classname.getArrayElementClassname();
            }
            if ((classfile = whylineUI.getTrace().getClassfileByName(classname)) != null) {
                String name = "<b>" + classfile.getSimpleName() + "</b>.class";
                menu.add(new WhylineMenuItem("<html>show <b>declaration</b>", new LoggedAction(whylineUI){

                    @Override
                    protected AbstractUIEvent<?> act() {
                        return whylineUI.selectClass(classfile, true, "popup");
                    }
                }));
            }
            popup.add(menu);
        }
    }

    private static void addParameterQuestions(WhylineUI whylineUI, WhylinePopup popup, Token token) {
        CodeAttribute instructions;
        int localID;
        Question<?> q;
        Parameter parameter = token.getFile().getMethodParameterFor(token);
        if (parameter != null && parameter.getMethod().getCode() != null && (q = SourceFileMenuFactory.getLocalIDQuestion(whylineUI, localID = (instructions = parameter.getMethod().getCode()).getMethod().getLocalIDFromArgumentNumber(parameter.getNumber()), instructions.getLocalIDNameRelativeToInstruction(localID, instructions.getFirstInstruction()))) != null) {
            popup.add(new QuestionMenu.QuestionItem(q, null));
        }
    }

    public static void addPrintQuestions(final WhylineUI whylineUI, WhylinePopup popup, final Token token) {
        if (whylineUI.getMode() != WhylineUI.Mode.BREAKPOINT) {
            return;
        }
        Instruction code = token.getFile().getInstructionFor(token);
        if (code == null) {
            return;
        }
        if (whylineUI.getBreakpointDebugger().canPrint(token)) {
            BreakpointDebugger debugger = whylineUI.getBreakpointDebugger();
            boolean printSet = debugger.hasPrint(token);
            if (printSet) {
                popup.add(new WhylineMenuItem("<html><b>remove</b> print statement", new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        BreakpointDebugger debugger = whylineUI.getBreakpointDebugger();
                        debugger.removePrint(token);
                        whylineUI.getLinesUI().updateBreakpointLines(null);
                    }
                }));
            } else {
                popup.add(new WhylineMenuItem(code instanceof Invoke ? "<html>print  <b>return value</b> after executing" : "<html>print <b>value</b> after executing", new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        BreakpointDebugger debugger = whylineUI.getBreakpointDebugger();
                        debugger.addPrint(token, "");
                    }
                }));
            }
        }
    }

    private static void addInstructionQuestions(final WhylineUI whylineUI, WhylinePopup popup, final Token token) {
        WhylineMenu menu;
        String name;
        Question<?> q;
        int localID;
        Classfile classfile;
        MethodInfo method;
        FieldInfo field;
        final Instruction code = token.getFile().getInstructionFor(token);
        if (code == null) {
            return;
        }
        if (code instanceof Invoke) {
            field = null;
            method = whylineUI.getTrace().resolveMethodReference(((Invoke)code).getMethodInvoked().getClassName(), (Invoke)code);
            classfile = method == null ? null : method.getClassfile();
            localID = -1;
            q = null;
        } else if (code instanceof FieldrefContainer) {
            FieldrefInfo ref = ((FieldrefContainer)((Object)code)).getFieldref();
            field = whylineUI.getTrace().resolveFieldReference(ref);
            method = null;
            classfile = field == null ? null : field.getClassfile();
            localID = -1;
            q = SourceFileMenuFactory.getFieldQuestion(whylineUI, field);
        } else if (code instanceof GetLocal) {
            field = null;
            method = null;
            classfile = null;
            localID = ((GetLocal)code).getLocalID();
            q = SourceFileMenuFactory.getLocalIDQuestion(whylineUI, localID, code.getCode().getLocalIDNameRelativeToInstruction(localID, code.getNext()));
        } else if (code instanceof SetLocal) {
            field = null;
            method = null;
            localID = ((SetLocal)code).getLocalID();
            StackDependencies.Producers producers = code.getProducersOfArgument(0);
            Instruction producer = producers.getFirstProducer();
            if (producer instanceof Invoke) {
                QualifiedClassName returnType = ((Invoke)producer).getMethodInvoked().getReturnType();
                classfile = !returnType.isPrimitive() ? whylineUI.getTrace().getClassfileByName(returnType) : null;
            } else if (producer instanceof NEW) {
                QualifiedClassName type = ((NEW)producer).getClassnameOfTypeProduced();
                classfile = whylineUI.getTrace().getClassfileByName(type);
            } else {
                classfile = null;
            }
            q = SourceFileMenuFactory.getLocalIDQuestion(whylineUI, localID, code.getCode().getLocalIDNameRelativeToInstruction(localID, code.getNext()));
        } else {
            field = null;
            method = null;
            classfile = null;
            localID = -1;
            q = null;
        }
        if (q != null) {
            popup.add(new QuestionMenu.QuestionItem(q, null));
        }
        if (localID >= 0) {
            name = "<b>" + code.getCode().getLocalIDNameRelativeToInstruction(localID, code.getNext()) + "</b>";
            menu = new WhylineMenu("<html>local " + name);
            menu.add(new WhylineMenuItem("<html>show <b>uses</b>", new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    whylineUI.getLinesUI().addResults(new LocalUsesSearch(whylineUI, code, localID));
                }
            }));
            popup.add(menu);
        }
        if (field != null) {
            name = "<b>" + field.getName() + "</b>";
            menu = new WhylineMenu("<html>field " + name);
            menu.add(new WhylineMenuItem("<html>show <b>uses</b>", new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    whylineUI.getLinesUI().addResults(new FieldUsesSearch(whylineUI, field));
                }
            }));
            popup.add(menu);
        }
        if (method != null) {
            Invoke invoke = (Invoke)code;
            String methodNameHTML = "<b>" + invoke.getJavaMethodName() + "</b>()";
            WhylineMenu menu2 = new WhylineMenu("<html>method " + methodNameHTML);
            menu2.add(new WhylineMenuItem("<html>show <b>declaration</b>", new LoggedAction(whylineUI){

                @Override
                protected AbstractUIEvent<?> act() {
                    return whylineUI.selectMethod(method, true, "declaration");
                }

                public Instruction getInstruction() {
                    return token.getFile().getInstructionFor(token);
                }
            }));
            menu2.add(new WhylineMenuItem("<html>show <b>callers</b>", new LoggedAction(whylineUI){

                @Override
                protected AbstractUIEvent<?> act() {
                    whylineUI.getLinesUI().addResults(new MethodCallersSearch(whylineUI, method));
                    return new Note(Serializer.listToString("callers", Serializer.methodToString(method)));
                }

                public Instruction getInstruction() {
                    return token.getFile().getInstructionFor(token);
                }
            }));
            popup.add(menu2);
        }
        if (classfile != null) {
            name = "<b>" + classfile.getSimpleName() + "</b>";
            menu = new WhylineMenu("<html>class " + name);
            menu.add(new WhylineMenuItem("<html>show <b>declaration</b>", new LoggedAction(whylineUI){

                @Override
                protected AbstractUIEvent<?> act() {
                    return whylineUI.selectClass(classfile, true, "popup");
                }
            }));
            menu.add(new WhylineMenuItem("<html>show <b>uses</b>", new LoggedAction(whylineUI){

                @Override
                protected AbstractUIEvent<?> act() {
                    whylineUI.getLinesUI().addResults(new ClassUsesSearch(whylineUI, classfile));
                    return null;
                }
            }));
            popup.add(menu);
        }
    }

    public static void addQuestionsForLine(final WhylineUI whylineUI, WhylinePopup popup, final Line line) {
        Line nearestLine;
        WhylineMenu menu = new WhylineMenu("<html>line <b>" + line.getLineNumber().getNumber() + "</b>");
        if (whylineUI.getMode() == WhylineUI.Mode.SLICER) {
            menu.add(new WhylineMenuItem("<html>add <i>most recent</i> execution of this statement to slicing criterion", new LoggedAction(whylineUI){

                @Override
                protected AbstractUIEvent<?> act() {
                    whylineUI.addDynamicSlice(line, true);
                    return new Note(Serializer.listToString("slicerecent", Serializer.lineToString(line)));
                }
            }));
            menu.add(new WhylineMenuItem("<html> add <i>all executions</i> of this statement to slicing criterion", new LoggedAction(whylineUI){

                @Override
                protected AbstractUIEvent<?> act() {
                    whylineUI.addDynamicSlice(line, false);
                    return new Note(Serializer.listToString("sliceall", Serializer.lineToString(line)));
                }
            }));
        } else if (whylineUI.getMode() == WhylineUI.Mode.BREAKPOINT && (nearestLine = whylineUI.getBreakpointDebugger().getNearestBreakpointLine(line)) != null) {
            final BreakpointDebugger debugger = whylineUI.getBreakpointDebugger();
            boolean breakpointSet = debugger.hasBreakpoint(nearestLine);
            menu.add(new WhylineMenuItem("<html><b>" + (breakpointSet ? "remove" : "set") + "</b> breakpoint", new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    debugger.toggleBreakpoint(nearestLine);
                }
            }));
            menu.add(new WhylineMenuItem("<html><b>run</b> to", new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    debugger.toggleBreakpoint(nearestLine);
                    debugger.runToBreakpoint();
                    debugger.toggleBreakpoint(nearestLine);
                }
            }));
        }
        menu.add(new WhylineMenuItem("<html>bookmark", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                whylineUI.getPersistentState().addRelevantLine(line);
            }
        }));
        menu.add(new WhylineMenuItem("<html>copy to <b>clipboard</b>", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                systemClipboard.setContents(new StringSelection(String.valueOf(line.getLineNumber().getNumber()) + "\t" + line.getLineText()), null);
            }
        }));
        popup.add(menu);
    }

    public static void addQuestionsForMethod(final WhylineUI whylineUI, WhylinePopup popup, Line line) {
        if (line == null) {
            return;
        }
        if (!(line.getFile() instanceof JavaSourceFile)) {
            return;
        }
        final MethodInfo method = ((JavaSourceFile)line.getFile()).getMethodOfLine(line);
        if (method == null) {
            return;
        }
        String htmlName = "<b>" + method.getJavaName() + "()</b>";
        WhylineMenu menu = new WhylineMenu("<html>method " + htmlName);
        if (method.getPotentialCallers().isEmpty()) {
            WhylineMenuItem item = new WhylineMenuItem("<html><i>no callers</i>");
            item.setEnabled(false);
            menu.add(item);
        } else {
            menu.add(new WhylineMenuItem("<html>show <b>callers</b>", new LoggedAction(whylineUI){

                @Override
                protected AbstractUIEvent<?> act() {
                    whylineUI.getLinesUI().addResults(new MethodCallersSearch(whylineUI, method));
                    return new Note(Serializer.listToString("callers", Serializer.methodToString(method)));
                }
            }));
        }
        if (!method.getOverriders().isEmpty()) {
            menu.add(new WhylineMenuItem("<html>show <b>implementors/overriders</b>", new LoggedAction(whylineUI){

                @Override
                protected AbstractUIEvent<?> act() {
                    whylineUI.getLinesUI().addResults(new FindOverriders(whylineUI, method));
                    return new Note(Serializer.listToString("overriders", Serializer.methodToString(method)));
                }
            }));
        }
        if (method.getMethodOverriden() != null) {
            menu.add(new WhylineMenuItem("<html>show <b>overriden method</b>", new LoggedAction(whylineUI){

                @Override
                protected AbstractUIEvent<?> act() {
                    return whylineUI.selectMethod(method.getMethodOverriden(), true, "override");
                }
            }));
        }
        menu.add(new WhylineMenuItem("<html>copy  to <b>clipboard</b>", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    JavaSourceFile source = method.getClassfile().getSourceFile();
                    if (source != null) {
                        LineNumber first = source.getFirstTokenOfMethodHeader(method).getLineNumber();
                        LineNumber last = method.getCode().getLastLineNumber();
                        if (first != null && last != null) {
                            StringBuilder builder = new StringBuilder();
                            int i = first.getNumber();
                            while (i <= last.getNumber()) {
                                Line line = source.getLine(i);
                                builder.append(String.valueOf(line.getLineNumber().getNumber()) + "\t" + line.getLineText() + "\n");
                                ++i;
                            }
                            systemClipboard.setContents(new StringSelection(builder.toString()), null);
                        } else {
                            JOptionPane.showMessageDialog(whylineUI, "Couldn't copy method text because couldn't find its beginnging and end.");
                        }
                    } else {
                        JOptionPane.showMessageDialog(whylineUI, "Couldn't find source.");
                    }
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
            }
        }));
        menu.add(new WhylineMenuItem("<html>show <b>bytecode</b>", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                whylineUI.selectFile(method.getClassfile(), true, "menu");
            }
        }));
        popup.add(menu);
    }

    private static Question<?> getLocalIDQuestion(WhylineUI whylineUI, int localID, String name) {
        if (localID < 0) {
            return null;
        }
        if (whylineUI.isWhyline()) {
            int beforeID = whylineUI.getSelectedEventID();
            if (beforeID < 0) {
                return null;
            }
            int eventID = whylineUI.getTrace().findLocalIDAssignmentBefore(localID, beforeID);
            if (eventID >= 0) {
                String value = null;
                EventKind kind = whylineUI.getTrace().getKind(eventID);
                if (kind.isDefinition) {
                    Value v;
                    value = kind.isArgument ? whylineUI.getTrace().getArgumentValueDescription(eventID) : ((v = whylineUI.getTrace().getDefinitionValueSet(eventID)) == null ? "(unknown value" : v.getDisplayName(true));
                }
                return new WhyDidEventOccur((Asker)whylineUI, eventID, "why did <b>" + name + "</b> = <i>" + value + "<i>");
            }
        }
        return null;
    }

    private static Question<?> getFieldQuestion(WhylineUI whylineUI, FieldInfo field) {
        int definitionID;
        int beforeID;
        if (field != null && whylineUI.isWhyline() && field.isStatic() && (beforeID = whylineUI.getSelectedEventID()) >= 0 && (definitionID = whylineUI.getTrace().findGlobalAssignmentBefore(field.getQualifiedName(), beforeID)) >= 0) {
            Value value = whylineUI.getTrace().getDefinitionValueSet(definitionID);
            return new WhyDidEventOccur((Asker)whylineUI, definitionID, "<b>" + field.getName() + "<b> = " + (value == null ? "its current value" : value.getDisplayName(true)));
        }
        return null;
    }
}

