/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.qa;

import edu.cmu.hcii.whyline.analysis.AnalysisException;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.io.IOEvent;
import edu.cmu.hcii.whyline.qa.Answer;
import edu.cmu.hcii.whyline.qa.Asker;
import edu.cmu.hcii.whyline.qa.ExpectedObject;
import edu.cmu.hcii.whyline.qa.Scope;
import edu.cmu.hcii.whyline.qa.UnexecutedInstruction;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.util.Named;
import edu.cmu.hcii.whyline.util.Util;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Question<T extends Named>
implements Comparable<Question<?>> {
    protected final Asker asker;
    protected final Trace trace;
    protected final T subject;
    private final String descriptionOfEvent;
    protected final Scope scope;
    private boolean isAnswered = false;
    private Answer answer;
    private final Map<Instruction, UnexecutedInstruction> unexecutedInstructions = new HashMap<Instruction, UnexecutedInstruction>();

    public Question(Asker asker, T subject, String descriptionOfEvent) {
        this.asker = asker;
        this.trace = asker.getTrace();
        this.subject = subject;
        this.scope = asker.getCurrentScope();
        this.descriptionOfEvent = descriptionOfEvent;
    }

    public final String getDescriptionOfSubject() {
        return this.getDescriptionOfSubject(-1);
    }

    public final String getDescriptionOfSubject(int limit) {
        return this.subject.getDisplayName(false, limit);
    }

    public final String getDescriptionOfEvent() {
        return this.getDescriptionOfEvent(-1);
    }

    public final String getDescriptionOfEvent(int limit) {
        String truncatedEvent = Util.elide(this.descriptionOfEvent, limit);
        return truncatedEvent;
    }

    public final Trace getTrace() {
        return this.asker.getTrace();
    }

    public final int getInputEventID() {
        return this.scope.getInputEventID();
    }

    public final int getOutputEventID() {
        return this.scope.getOutputEventID();
    }

    public final IOEvent getInputEvent() {
        return this.trace.getIOHistory().getEventAtTime(this.getInputEventID());
    }

    public final T getSubject() {
        return this.subject;
    }

    public final void computeAnswer() {
        if (this.isAnswered) {
            return;
        }
        this.isAnswered = true;
        try {
            this.answer = this.answer();
            this.asker.doneAnswering();
        }
        catch (AnalysisException e) {
            this.asker.problemAnswering(this, e);
        }
    }

    public Answer getAnswer() {
        return this.answer;
    }

    protected abstract Answer answer() throws AnalysisException;

    public UnexecutedInstruction getUnexecutedInstruction(Instruction inst, ExpectedObject object) {
        UnexecutedInstruction ine = this.unexecutedInstructions.get(inst);
        if (ine == null) {
            ine = new UnexecutedInstruction(this, inst, object);
            this.unexecutedInstructions.put(inst, ine);
        }
        return ine;
    }

    public Asker getAsker() {
        return this.asker;
    }

    @Override
    public int compareTo(Question<?> question) {
        return this.getDescriptionOfEvent(-1).compareTo(question.getDescriptionOfEvent(-1));
    }

    public abstract String getQuestionExplanation();

    public abstract boolean isPhrasedNegatively();

    public final String toString() {
        return this.getQuestionText();
    }

    public final String getQuestionText() {
        String subject = "<b>" + this.subject.getDisplayName(true, -1) + "</b>";
        String event = "<b>" + this.getDescriptionOfEvent() + "</b>";
        if (this.isPhrasedNegatively()) {
            return "why didn't " + subject + " " + event + "?";
        }
        return "why did " + subject + " " + event + "?";
    }

    protected static class EventID
    implements Named {
        private final int eventID;

        public EventID(int eventID) {
            this.eventID = eventID;
        }

        public String getDisplayName(boolean html, int limit) {
            return "";
        }

        public int getEventID() {
            return this.eventID;
        }
    }
}

