/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.qa;

import edu.cmu.hcii.whyline.bytecode.FieldInfo;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.qa.Question;
import edu.cmu.hcii.whyline.qa.QuestionMenu;
import edu.cmu.hcii.whyline.qa.QuestionMenuMaker;
import edu.cmu.hcii.whyline.trace.nodes.ObjectState;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectQuestions {
    private final SortedMap<String, SortedSet<Object>> questions;
    private final ObjectState object;
    private final QuestionMenu menu;

    public ObjectQuestions(ObjectState object, QuestionMenu menu) {
        this.object = object;
        this.menu = menu;
        this.questions = new TreeMap<String, SortedSet<Object>>(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                boolean s1Lower = Character.isLowerCase(s1.charAt(0));
                boolean s2Lower = Character.isLowerCase(s2.charAt(0));
                if (s1Lower) {
                    if (s2Lower) {
                        return s1.compareTo(s2);
                    }
                    return -1;
                }
                if (s2Lower) {
                    return 1;
                }
                return s1.compareTo(s2);
            }
        });
    }

    public void addFieldQuestions(QuestionMenuMaker m, FieldInfo field, boolean important) {
        QualifiedClassName base = this.object.getTrace().getClassIDs().getBaseClassOf(field.getTypeName());
        String name = base.getSimpleName();
        int brackets = name.indexOf(91);
        if (brackets >= 0) {
            name = name.substring(0, brackets);
        }
        int latestHump = -1;
        int i = 0;
        while (i < name.length()) {
            if (Character.isUpperCase(name.charAt(i))) {
                latestHump = i;
            }
            ++i;
        }
        if (latestHump >= 0 && latestHump + 1 < name.length() && Character.isLowerCase(name.charAt(latestHump + 1))) {
            name = name.substring(latestHump);
        }
        if (!name.endsWith("s")) {
            name = String.valueOf(name) + "s";
        }
        this.getQuestionSet(name).add(m);
    }

    private SortedSet<Object> getQuestionSet(String type) {
        TreeSet set = (TreeSet)this.questions.get(type);
        if (set == null) {
            set = new TreeSet();
            this.questions.put(type, set);
        }
        return set;
    }

    public void addPrimitiveOutputQuestion(Question<?> q) {
        this.getQuestionSet("primitive").add(q);
    }

    public int getNumberOfQuestions() {
        int total = 0;
        for (SortedSet<Object> set : this.questions.values()) {
            total += set.size();
        }
        return total;
    }

    public QuestionMenu createMenu() {
        int count = this.getNumberOfQuestions();
        boolean group = count > 10;
        TreeSet<Object> singletons = new TreeSet<Object>();
        boolean lastLower = true;
        for (String type : this.questions.keySet()) {
            if (lastLower && Character.isUpperCase(type.charAt(0))) {
                this.menu.addSeparator();
            }
            lastLower = Character.isLowerCase(type.charAt(0));
            SortedSet set = (SortedSet)this.questions.get(type);
            if (set.size() == 1 && group) {
                singletons.add(set.first());
                continue;
            }
            this.add(set, "<i>" + type + "</i>", group);
        }
        if (singletons.size() > 0) {
            this.menu.addSeparator();
        }
        if (group) {
            this.add(singletons, "<b>other</b> fields", true);
        }
        return this.menu;
    }

    private void add(SortedSet<Object> set, String name, boolean group) {
        String description = "Questions about the <b>current value</b> of " + name + " of " + this.object.getDisplayName(true, -1);
        if (!set.isEmpty()) {
            QuestionMenu questions = group ? new QuestionMenu(this.menu.getAsker(), description, name) : this.menu;
            for (Object e : set) {
                if (e instanceof QuestionMenu) {
                    if (((QuestionMenu)e).getNumberOfItems() <= 0) continue;
                    questions.addMenu((QuestionMenu)e);
                    continue;
                }
                if (e instanceof Question) {
                    questions.addQuestion((Question)e);
                    continue;
                }
                if (!(e instanceof QuestionMenuMaker)) continue;
                questions.addMaker((QuestionMenuMaker)e);
            }
            if (questions != this.menu) {
                this.menu.addMenu(questions);
            }
        }
    }
}

