/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.qa;

import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.qa.Answer;
import edu.cmu.hcii.whyline.qa.Explanation;
import edu.cmu.hcii.whyline.qa.Question;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CauseAnswer
extends Answer {
    private final int eventID;
    private final String answerText;

    public CauseAnswer(Question<?> question, int eventID, String answerText) {
        super(question);
        int sourceID;
        this.answerText = answerText;
        Instruction inst = this.getTrace().getInstruction(eventID);
        if (inst.getClassfile().getSourceFile() == null && (sourceID = this.getTrace().getSourceOfValueID(eventID)) >= 0) {
            eventID = sourceID;
        }
        this.eventID = eventID;
        Explanation explanation = this.getExplanationFor(this.eventID);
        assert (explanation != null) : "Whaaa? Why couldn't we get an explanation for event " + this.eventID;
        explanation.explain();
    }

    public int getEventID() {
        return this.eventID;
    }

    @Override
    public String getKind() {
        return "Certain events occurred...";
    }

    @Override
    public int getPriority() {
        return 3;
    }

    @Override
    public String getAnswerText() {
        return "<html>" + this.answerText;
    }
}

