/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.io;

import edu.cmu.hcii.whyline.bytecode.INVOKEVIRTUAL;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.MethodrefInfo;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.io.ClearRectEvent;
import edu.cmu.hcii.whyline.io.ClipRectEvent;
import edu.cmu.hcii.whyline.io.ClipWithShapeEvent;
import edu.cmu.hcii.whyline.io.CopyAreaEvent;
import edu.cmu.hcii.whyline.io.Draw3DRectEvent;
import edu.cmu.hcii.whyline.io.DrawArcEvent;
import edu.cmu.hcii.whyline.io.DrawCharacterSequenceEvent;
import edu.cmu.hcii.whyline.io.DrawCharsEvent;
import edu.cmu.hcii.whyline.io.DrawEvent;
import edu.cmu.hcii.whyline.io.DrawImageWithLocationAndObserverEvent;
import edu.cmu.hcii.whyline.io.DrawImageWithLocationColorAndObserverEvent;
import edu.cmu.hcii.whyline.io.DrawImageWithLocationSizeAndObserverEvent;
import edu.cmu.hcii.whyline.io.DrawImageWithLocationSizeColorAndObserverEvent;
import edu.cmu.hcii.whyline.io.DrawImageWithSizeAndColorWithinAreaEvent;
import edu.cmu.hcii.whyline.io.DrawImageWithSizeWithinAreaEvent;
import edu.cmu.hcii.whyline.io.DrawLineEvent;
import edu.cmu.hcii.whyline.io.DrawOvalEvent;
import edu.cmu.hcii.whyline.io.DrawRectEvent;
import edu.cmu.hcii.whyline.io.DrawRoundRectEvent;
import edu.cmu.hcii.whyline.io.DrawStringEvent;
import edu.cmu.hcii.whyline.io.Fill3DRectEvent;
import edu.cmu.hcii.whyline.io.FillArcEvent;
import edu.cmu.hcii.whyline.io.FillEvent;
import edu.cmu.hcii.whyline.io.FillOvalEvent;
import edu.cmu.hcii.whyline.io.FillRectEvent;
import edu.cmu.hcii.whyline.io.FillRoundRectEvent;
import edu.cmu.hcii.whyline.io.GraphicalOutputEvent;
import edu.cmu.hcii.whyline.io.RenderEvent;
import edu.cmu.hcii.whyline.io.RotateAroundOriginEvent;
import edu.cmu.hcii.whyline.io.RotateEvent;
import edu.cmu.hcii.whyline.io.ScaleEvent;
import edu.cmu.hcii.whyline.io.SetBackgroundEvent;
import edu.cmu.hcii.whyline.io.SetClipEvent;
import edu.cmu.hcii.whyline.io.SetClipWithShapeEvent;
import edu.cmu.hcii.whyline.io.SetColorEvent;
import edu.cmu.hcii.whyline.io.SetCompositeEvent;
import edu.cmu.hcii.whyline.io.SetFontEvent;
import edu.cmu.hcii.whyline.io.SetPaintEvent;
import edu.cmu.hcii.whyline.io.SetPaintModeEvent;
import edu.cmu.hcii.whyline.io.SetStrokeEvent;
import edu.cmu.hcii.whyline.io.SetTransformEvent;
import edu.cmu.hcii.whyline.io.SetXORModeEvent;
import edu.cmu.hcii.whyline.io.ShearEvent;
import edu.cmu.hcii.whyline.io.TransformEvent;
import edu.cmu.hcii.whyline.io.TranslateEvent;
import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.trace.ExecutionEventParser;
import edu.cmu.hcii.whyline.trace.Trace;

public class GraphicalOutputParser
extends ExecutionEventParser {
    public GraphicalOutputParser(Trace trace) {
        super(trace);
    }

    public static boolean handles(Instruction inst) {
        if (!(inst instanceof INVOKEVIRTUAL)) {
            return false;
        }
        QualifiedClassName classname = ((INVOKEVIRTUAL)inst).getMethodInvoked().getClassName();
        if (!classname.equals(QualifiedClassName.get("java/awt/Graphics")) && !classname.equals(QualifiedClassName.get("java/awt/Graphics2D"))) {
            return false;
        }
        MethodrefInfo methodRef = ((INVOKEVIRTUAL)inst).getMethodInvoked();
        Object output = null;
        return !methodRef.getMethodName().startsWith("get") && !methodRef.getMethodName().equals("toString") && !methodRef.getMethodName().equals("hitClip") && !methodRef.getMethodName().equals("hit") && !methodRef.getMethodName().equals("finalize") && !methodRef.getMethodName().equals("dispose") && !methodRef.getMethodName().equals("addRenderingHints") && !methodRef.getMethodName().equals("setRenderingHint") && !methodRef.getMethodName().equals("setRenderingHints");
    }

    public static boolean invokesOutput(Instruction inst) {
        if (!(inst instanceof INVOKEVIRTUAL)) {
            return false;
        }
        MethodrefInfo methodRef = ((INVOKEVIRTUAL)inst).getMethodInvoked();
        String methodName = methodRef.getMethodName();
        return methodName.startsWith("draw") || methodName.startsWith("fill") || methodName.startsWith("copy") || methodName.startsWith("clear");
    }

    public boolean handle(int id) {
        if (this.trace.getKind(id) != EventKind.INVOKE_VIRTUAL) {
            return false;
        }
        INVOKEVIRTUAL invoke = (INVOKEVIRTUAL)this.trace.getInstruction(id);
        if (!GraphicalOutputParser.handles(invoke)) {
            return false;
        }
        MethodrefInfo methodRef = invoke.getMethodInvoked();
        GraphicalOutputEvent output = null;
        if (!(methodRef.getMethodName().startsWith("get") || methodRef.matchesNameAndDescriptor("toString", "()Ljava/lang/String;") || methodRef.matchesNameAndDescriptor("hitClip", "(IIII)Z") || methodRef.matchesNameAndDescriptor("hit", "(Ljava/awt/Rectangle;Ljava/awt/Shape;Z)Z") || methodRef.matchesNameAndDescriptor("finalize", "()V") || methodRef.matchesNameAndDescriptor("dispose", "()V") || methodRef.matchesNameAndDescriptor("create", "()Ljava/awt/Graphics;") || methodRef.matchesNameAndDescriptor("create", "(IIII)Ljava/awt/Graphics;"))) {
            if (methodRef.matchesNameAndDescriptor("clearRect", "(IIII)V")) {
                output = new ClearRectEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("copyArea", "(IIIIII)V")) {
                output = new CopyAreaEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("setColor", "(Ljava/awt/Color;)V")) {
                output = new SetColorEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("setBackground", "(Ljava/awt/Color;)V")) {
                output = new SetBackgroundEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("clipRect", "(IIII)V")) {
                output = new ClipRectEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("clip", "(Ljava/awt/Shape;)V")) {
                output = new ClipWithShapeEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("setClip", "(IIII)V")) {
                output = new SetClipEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("setClip", "(Ljava/awt/Shape;)V")) {
                output = new SetClipWithShapeEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("drawRect", "(IIII)V")) {
                output = new DrawRectEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("drawRoundRect", "(IIIIII)V")) {
                output = new DrawRoundRectEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("draw3DRect", "(IIIIZ)V")) {
                output = new Draw3DRectEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("fillRect", "(IIII)V")) {
                output = new FillRectEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("fillRoundRect", "(IIIIII)V")) {
                output = new FillRoundRectEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("fill3DRect", "(IIIIZ)V")) {
                output = new Fill3DRectEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("setFont", "(Ljava/awt/Font;)V")) {
                output = new SetFontEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("drawBytes", "([BIIII)V")) {
                output = new DrawCharsEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("drawChars", "([CIIII)V")) {
                output = new DrawCharsEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("drawString", "(Ljava/lang/String;II)V")) {
                output = new DrawStringEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("drawString", "(Ljava/lang/String;FF)V")) {
                output = new DrawStringEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("drawGlyphVector", "(Ljava/awt/font/GlyphVector;FF)V")) {
                output = new DrawCharacterSequenceEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("drawString", "(Ljava/text/AttributedCharacterIterator;II)V")) {
                output = new DrawCharacterSequenceEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("drawString", "(Ljava/text/AttributedCharacterIterator;FF)V")) {
                output = new DrawCharacterSequenceEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("drawLine", "(IIII)V")) {
                output = new DrawLineEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("rotate", "(D)V")) {
                output = new RotateEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("rotate", "(DDD)V")) {
                output = new RotateAroundOriginEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("scale", "(DD)V")) {
                output = new ScaleEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("setTransform", "(Ljava/awt/geom/AffineTransform;)V")) {
                output = new SetTransformEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("shear", "(DD)V")) {
                output = new ShearEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("transform", "(Ljava/awt/geom/AffineTransform;)V")) {
                output = new TransformEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("translate", "(DD)V")) {
                output = new TranslateEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("translate", "(II)V")) {
                output = new TranslateEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("setPaintMode", "()V")) {
                output = new SetPaintModeEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("setXORMode", "(Ljava/awt/Color;)V")) {
                output = new SetXORModeEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("setComposite", "(Ljava/awt/Composite;)V")) {
                output = new SetCompositeEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("setPaint", "(Ljava/awt/Paint;)V")) {
                output = new SetPaintEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("setStroke", "(Ljava/awt/Stroke;)V")) {
                output = new SetStrokeEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("drawImage", "(Ljava/awt/Image;IILjava/awt/image/ImageObserver;)Z")) {
                output = new DrawImageWithLocationAndObserverEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("drawImage", "(Ljava/awt/Image;IILjava/awt/Color;Ljava/awt/image/ImageObserver;)Z")) {
                output = new DrawImageWithLocationColorAndObserverEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("drawImage", "(Ljava/awt/Image;IIIILjava/awt/Color;Ljava/awt/image/ImageObserver;)Z")) {
                output = new DrawImageWithLocationSizeColorAndObserverEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("drawImage", "(Ljava/awt/Image;IIIILjava/awt/image/ImageObserver;)Z")) {
                output = new DrawImageWithLocationSizeAndObserverEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("drawImage", "(Ljava/awt/Image;IIIIIIIILjava/awt/image/ImageObserver;)Z")) {
                output = new DrawImageWithSizeWithinAreaEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("drawImage", "(Ljava/awt/Image;IIIIIIIILjava/awt/Color;Ljava/awt/image/ImageObserver;)Z")) {
                output = new DrawImageWithSizeAndColorWithinAreaEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("drawArc", "(IIIIII)V")) {
                output = new DrawArcEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("fillArc", "(IIIIII)V")) {
                output = new FillArcEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("drawOval", "(IIII)V")) {
                output = new DrawOvalEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("fillOval", "(IIII)V")) {
                output = new FillOvalEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("draw", "(Ljava/awt/Shape;)V")) {
                output = new DrawEvent(this.trace, id);
            } else if (methodRef.matchesNameAndDescriptor("fill", "(Ljava/awt/Shape;)V")) {
                output = new FillEvent(this.trace, id);
            } else if (!methodRef.matchesNameAndDescriptor("addRenderingHints", "(Ljava/util/Map;)V") && !methodRef.matchesNameAndDescriptor("setRenderingHint", "(Ljava/awt/RenderingHints$Key;Ljava/lang/Object;)V")) {
                methodRef.matchesNameAndDescriptor("setRenderingHints", "(Ljava/awt/RenderingHints;)V");
            }
        }
        if (output != null) {
            if (output instanceof RenderEvent) {
                this.trace.getRenderHistory().add((RenderEvent)output);
            } else {
                this.trace.getGraphicsHistory().add(output);
            }
            return true;
        }
        return false;
    }
}

