/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.io;

import edu.cmu.hcii.whyline.io.RenderEvent;
import edu.cmu.hcii.whyline.trace.Trace;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;

public final class DrawRectEvent
extends RenderEvent {
    private static final String[] ARGUMENT_NAMES = new String[]{"graphics", "x", "y", "width", "height"};

    public String getArgumentName(int index) {
        return ARGUMENT_NAMES[index];
    }

    public DrawRectEvent(Trace trace, int eventID) {
        super(trace, eventID);
    }

    public void paint(Graphics2D g) {
        g.drawRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    protected Shape makeShape() {
        int x1 = this.getX() + this.paintState.getOriginX();
        int x2 = this.getX() + this.paintState.getOriginX() + this.getWidth();
        int y1 = this.getY() + this.paintState.getOriginY();
        int y2 = this.getY() + this.paintState.getOriginY() + this.getHeight();
        int thickness = 2;
        Polygon p = new Polygon();
        p.addPoint(x1 - thickness, y1 - thickness);
        p.addPoint(x2 + thickness, y1 - thickness);
        p.addPoint(x2 + thickness, y2 + thickness);
        p.addPoint(x1 + thickness, y2 + thickness);
        p.addPoint(x1 + thickness, y2 - thickness);
        p.addPoint(x2 - thickness, y2 - thickness);
        p.addPoint(x2 - thickness, y1 + thickness);
        p.addPoint(x1 + thickness, y1 + thickness);
        p.addPoint(x1 + thickness, y2 + thickness);
        p.addPoint(x1 - thickness, y2 + thickness);
        p.addPoint(x1 - thickness, y1 - thickness);
        return p;
    }

    public int getX() {
        return this.getInteger(1);
    }

    public int getY() {
        return this.getInteger(2);
    }

    public int getWidth() {
        return this.getInteger(3);
    }

    public int getHeight() {
        return this.getInteger(4);
    }

    public String getHumanReadableName() {
        return "rectangle";
    }

    public boolean canOcclude() {
        return false;
    }

    public String toString() {
        return String.valueOf(super.toString()) + this.getGraphicsID() + "\tdrawRect " + this.getX() + " " + this.getY() + " " + this.getWidth() + " " + this.getHeight();
    }
}

