/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.io;

import edu.cmu.hcii.whyline.io.RenderEvent;
import edu.cmu.hcii.whyline.io.SetStrokeEvent;
import edu.cmu.hcii.whyline.trace.Trace;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;

public final class DrawLineEvent
extends RenderEvent {
    private static final String[] ARGUMENT_NAMES = new String[]{"graphics", "x1", "y1", "x2", "y2"};

    public String getArgumentName(int index) {
        return ARGUMENT_NAMES[index];
    }

    public DrawLineEvent(Trace trace, int eventID) {
        super(trace, eventID);
    }

    public void paint(Graphics2D g) {
        g.drawLine(this.getX1(), this.getY1(), this.getX2(), this.getY2());
    }

    protected Shape makeShape() {
        int x1 = this.getX1() + this.paintState.getOriginX();
        int x2 = this.getX2() + this.paintState.getOriginX();
        int y1 = this.getY1() + this.paintState.getOriginY();
        int y2 = this.getY2() + this.paintState.getOriginY();
        double angle = Math.atan2(y2 - y1, x2 - x1);
        SetStrokeEvent event = this.paintState.getLatestStrokeChange();
        Stroke stroke = event == null ? null : event.getStroke();
        float strokeWidth = Math.max(2.0f, stroke == null ? 1.0f : ((BasicStroke)stroke).getLineWidth());
        double xAlong = Math.cos(angle) * (double)strokeWidth;
        double yAlong = Math.sin(angle) * (double)strokeWidth;
        double xClock = Math.cos(angle + 1.5707963267948966) * (double)strokeWidth;
        double yClock = Math.sin(angle + 1.5707963267948966) * (double)strokeWidth;
        double xCounter = Math.cos(angle - 1.5707963267948966) * (double)strokeWidth;
        double yCounter = Math.sin(angle - 1.5707963267948966) * (double)strokeWidth;
        Polygon p = new Polygon();
        p.addPoint((int)((double)x1 + xCounter), (int)((double)y1 + yCounter));
        p.addPoint((int)((double)x1 - xAlong), (int)((double)y1 - yAlong));
        p.addPoint((int)((double)x1 + xClock), (int)((double)y1 + yClock));
        p.addPoint((int)((double)x2 + xClock), (int)((double)y2 + yClock));
        p.addPoint((int)((double)x2 + xAlong), (int)((double)y2 + yAlong));
        p.addPoint((int)((double)x2 + xCounter), (int)((double)y2 + yCounter));
        return p;
    }

    public int getX1() {
        return this.getInteger(1);
    }

    public int getY1() {
        return this.getInteger(2);
    }

    public int getX2() {
        return this.getInteger(3);
    }

    public int getY2() {
        return this.getInteger(4);
    }

    public boolean canOcclude() {
        return false;
    }

    public String getHumanReadableName() {
        return "line";
    }

    public String toString() {
        return String.valueOf(super.toString()) + this.getGraphicsID() + "\tdrawLine " + this.getX1() + " " + this.getY1() + " " + this.getX2() + " " + this.getY2();
    }
}

