/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.io;

import edu.cmu.hcii.whyline.io.RenderEvent;
import edu.cmu.hcii.whyline.trace.NoValueException;
import edu.cmu.hcii.whyline.trace.Trace;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;

public final class DrawEvent
extends RenderEvent {
    private static final String[] ARGUMENT_NAMES = new String[]{"graphics", "shape"};
    private Shape shape;

    public String getArgumentName(int index) {
        return ARGUMENT_NAMES[index];
    }

    public DrawEvent(Trace trace, int eventID) {
        super(trace, eventID);
    }

    public void paint(Graphics2D g) {
        g.draw(this.getShape());
    }

    protected Shape makeShape() {
        Rectangle r = this.getShape().getBounds();
        r.translate(this.paintState.getOriginX(), this.paintState.getOriginY());
        return r;
    }

    public Shape getShape() {
        if (this.shape == null) {
            try {
                this.shape = (Shape)this.trace.getOperandStackValue(this.eventID, 1).getImmutable();
            }
            catch (NoValueException noValueException) {
                // empty catch block
            }
        }
        return this.shape;
    }

    public boolean canOcclude() {
        return true;
    }

    public String getHumanReadableName() {
        return "shape";
    }

    public String toString() {
        return String.valueOf(super.toString()) + this.getGraphicsID() + "\tdraw " + this.getShape();
    }
}

