/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.io;

import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.io.RenderEvent;
import edu.cmu.hcii.whyline.io.SetFontEvent;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.ui.UI;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public final class DrawCharacterSequenceEvent
extends RenderEvent {
    private static final String[] ARGUMENT_NAMES = new String[]{"graphics", "iterator", "x", "y"};
    private Graphics2D renderContext;
    private final boolean usesFloats;
    private static final String UNKNOWN_TEXT = "unknown text";

    public String getArgumentName(int index) {
        return ARGUMENT_NAMES[index];
    }

    public DrawCharacterSequenceEvent(Trace trace, int eventID) {
        super(trace, eventID);
        String descriptor = ((Invoke)trace.getInstruction(eventID)).getMethodInvoked().getMethodDescriptor();
        this.usesFloats = descriptor.equals("(Ljava/text/AttributedCharacterIterator;FF)V") || descriptor.equals("(Ljava/awt/font/GlyphVector;FF)V");
    }

    public void paint(Graphics2D g) {
        if (this.renderContext == null) {
            this.renderContext = g;
        }
        g = (Graphics2D)g.create();
        g.setColor(UI.getHighlightColor());
        g.drawString(UNKNOWN_TEXT, this.getX(), this.getY());
    }

    protected Shape makeShape() {
        if (this.renderContext == null) {
            return null;
        }
        SetFontEvent setFont = this.paintState == null ? null : this.paintState.getLatestFontChange();
        Font font = setFont == null ? UI.getFixedFont() : setFont.getFont();
        FontMetrics metrics = this.renderContext.getFontMetrics(font);
        Rectangle2D r = metrics.getStringBounds(UNKNOWN_TEXT, this.renderContext);
        int ascent = metrics.getAscent();
        return new Rectangle(this.getX() + this.paintState.getOriginX(), this.getY() - ascent + this.paintState.getOriginY(), (int)r.getWidth(), (int)r.getHeight());
    }

    public int getX() {
        return this.usesFloats ? (int)this.getFloat(2) : this.getInteger(2);
    }

    public int getY() {
        return this.usesFloats ? (int)this.getFloat(3) : this.getInteger(3);
    }

    public String getHumanReadableName() {
        return "text";
    }

    public boolean canOcclude() {
        return false;
    }

    public String toString() {
        return String.valueOf(super.toString()) + this.getGraphicsID() + "\tdrawString <iterator> " + this.getX() + " " + this.getY();
    }
}

