/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.bytecode.Branch;
import edu.cmu.hcii.whyline.bytecode.CodeAttribute;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.trace.EventKind;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnconditionalBranch
extends Branch {
    private int offset;
    private Instruction destination = null;

    public UnconditionalBranch(CodeAttribute method, int offset) {
        super(method);
        this.offset = offset;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    public Instruction getDestination() {
        return this.destination;
    }

    public int getOffset() {
        return this.destination.getByteIndex() - this.getByteIndex();
    }

    @Override
    public Instruction getTarget() {
        return this.destination;
    }

    @Override
    public void resolveTargets(Instruction[] instructionsByByteIndex) {
        this.destination = instructionsByByteIndex[this.getByteIndex() + this.offset];
        this.code.addIncomingBranchToInstruction(this, this.destination);
    }

    @Override
    public void replaceTarget(Instruction oldTarget, Instruction newTarget) {
        if (this.destination != oldTarget) {
            throw new RuntimeException("Didn't pass in the old target!");
        }
        this.destination = newTarget;
    }

    @Override
    public SortedSet<Instruction> createSuccessorsCache() {
        TreeSet<Instruction> successors = new TreeSet<Instruction>();
        successors.add(this.destination);
        return successors;
    }

    @Override
    public boolean couldJumpTo(Instruction instruction) {
        return instruction == this.destination;
    }

    @Override
    protected boolean determineIfLoop() {
        return this.destination.getIndex() < this.getIndex() && this.canReachInMethod(this);
    }

    @Override
    public String getTypeDescriptorOfArgument(int argIndex) {
        return null;
    }

    @Override
    public EventKind getTypeProduced() {
        return null;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " " + this.getTarget().getIndex();
    }
}

