/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.analysis.AnalysisException;
import edu.cmu.hcii.whyline.analysis.Cancelable;
import edu.cmu.hcii.whyline.bytecode.AbstractReturn;
import edu.cmu.hcii.whyline.bytecode.Attribute;
import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.CodeAttribute;
import edu.cmu.hcii.whyline.bytecode.ConstantPool;
import edu.cmu.hcii.whyline.bytecode.ExceptionsAttribute;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.bytecode.JavaSpecificationViolation;
import edu.cmu.hcii.whyline.bytecode.MethodDescriptor;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.bytecode.SyntheticAttribute;
import edu.cmu.hcii.whyline.bytecode.UTF8Info;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.util.Named;
import edu.cmu.hcii.whyline.util.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodInfo
implements Comparable<MethodInfo>,
Named {
    private final Classfile classfile;
    private final int access;
    private final UTF8Info nameInfo;
    private final String name;
    private final UTF8Info descriptorInfo;
    private final String descriptor;
    private final String nameAndDescriptor;
    private MethodDescriptor parsedDescriptor;
    private CodeAttribute code;
    private ExceptionsAttribute exceptions;
    private Attribute[] attributes;
    private ArrayList<Invoke> potentialCallers;
    private Set<Invoke> actualCallers;
    private final ArrayList<MethodInfo> overriders = new ArrayList(1);
    private MethodInfo methodOverriden = null;
    private int flags = 0;
    private static final int IS_MAIN = 2;
    private static final int IS_RUN = 3;
    private static final int IS_CLINIT = 4;
    private static final int IS_INIT = 5;
    private static final int IS_SYNTHETIC = 7;
    private final int firstInstructionID;
    private final int declarationIndex;
    private int localIDOfFirstNonArgument = -1;

    private boolean getFlag(int flag) {
        return (this.flags & 1 << flag) != 0;
    }

    private void setFlag(int flag) {
        this.flags |= 1 << flag;
    }

    public MethodInfo(DataInputStream data, Classfile classfile, int instructionID, int declarationIndex) throws IOException, JavaSpecificationViolation, AnalysisException {
        ConstantPool pool = classfile.getConstantPool();
        this.classfile = classfile;
        this.firstInstructionID = instructionID;
        this.declarationIndex = declarationIndex;
        this.access = data.readUnsignedShort();
        this.nameInfo = (UTF8Info)pool.get(data.readUnsignedShort());
        this.name = this.nameInfo.toString();
        this.descriptorInfo = (UTF8Info)pool.get(data.readUnsignedShort());
        this.descriptor = this.descriptorInfo.toString();
        this.nameAndDescriptor = (String.valueOf(this.name) + this.descriptor).intern();
        boolean isPublic = this.isPublic();
        if (this.name.startsWith("<cl")) {
            this.setFlag(4);
        } else if (this.name.equals("<init>")) {
            this.setFlag(5);
        } else if (isPublic && this.name.equals("main") && this.isStatic() && this.getDescriptor().equals("([Ljava/lang/String;)V")) {
            this.setFlag(2);
        } else if (this.name.startsWith("access$")) {
            this.setFlag(7);
        } else if (isPublic && this.name.equals("run") && this.getDescriptor().equals("()V") && (this.getClassfile().isSubclassOf(QualifiedClassName.JAVA_LANG_THREAD) || this.getClassfile().implementsInterface(QualifiedClassName.JAVA_LANG_RUNNABLE))) {
            this.setFlag(3);
        }
        this.getClassfile().forgetSuperclasses();
        int attributeCount = data.readUnsignedShort();
        this.attributes = new Attribute[attributeCount];
        int i = 0;
        while (i < attributeCount) {
            Attribute attr;
            this.attributes[i] = attr = Attribute.read(this, pool, data);
            if (attr instanceof CodeAttribute) {
                this.code = (CodeAttribute)attr;
            } else if (attr instanceof ExceptionsAttribute) {
                this.exceptions = (ExceptionsAttribute)attr;
            } else if (attr instanceof SyntheticAttribute) {
                this.setFlag(7);
            }
            ++i;
        }
    }

    public void toBytes(DataOutputStream bytes) throws IOException {
        bytes.writeShort(this.access);
        bytes.writeShort(this.nameInfo.getIndexInConstantPool());
        bytes.writeShort(this.descriptorInfo.getIndexInConstantPool());
        bytes.writeShort(this.attributes.length);
        Attribute[] attributeArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attr = attributeArray[n2];
            attr.toBytes(bytes);
            ++n2;
        }
    }

    public int getDeclarationIndex() {
        return this.declarationIndex;
    }

    public boolean isSynthetic() {
        return this.getFlag(7);
    }

    public Iterable<AbstractReturn> getReturns() {
        if (this.code == null) {
            return new ArrayList<AbstractReturn>(1);
        }
        return this.code.getReturns();
    }

    public String getInternalName() {
        return this.name;
    }

    public String getJavaName() {
        if (this.isInstanceInitializer()) {
            return this.getClassfile().getSimpleName();
        }
        if (this.isClassInitializer()) {
            return "static";
        }
        return this.name;
    }

    @Override
    public String getDisplayName(boolean html, int lengthLimit) {
        return String.valueOf(Util.elide(this.getJavaName(), lengthLimit)) + "()";
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String getMethodNameAndDescriptor() {
        return this.nameAndDescriptor;
    }

    public String getQualifiedNameAndDescriptor() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.classfile.getInternalName().getText());
        builder.append(".");
        builder.append(this.nameAndDescriptor);
        return builder.toString();
    }

    public String getSimpleDescriptor() {
        return this.getParsedDescriptor().getSimpleDescriptor();
    }

    public String getJavaDocURL() {
        StringBuilder url = new StringBuilder(this.getClassfile().getJavaDocURL());
        url.append("#");
        url.append(this.getJavaName());
        url.append(this.getParsedDescriptor().getJavaDocURL());
        return url.toString();
    }

    public int getFirstArgumentAppearingInSource() {
        if (this.isInstanceInitializer() && this.getClassfile().getInternalName().isInner() && !this.getClassfile().isStatic()) {
            if (this.getClassfile().isInnerClass()) {
                return 3;
            }
            return 2;
        }
        return 1;
    }

    public int getArgumentNumberOfLocalID(int localID) {
        return this.getParsedDescriptor().getArgumentNumberFromLocalID(localID);
    }

    public int getLocalIDFromArgumentNumber(int argumentNumber) {
        return this.getParsedDescriptor().getLocalIDFromArgumentNumber(argumentNumber);
    }

    public Classfile getClassfile() {
        return this.classfile;
    }

    public boolean matchesNameAndDescriptor(String name, String descriptor) {
        return this.getInternalName().equals(name) && this.getDescriptor().equals(descriptor);
    }

    public boolean matchesClassAndName(QualifiedClassName classname, String methodname) {
        return classname.equals(this.classfile.getInternalName()) && methodname.equals(this.name);
    }

    public boolean matchesClassNameAndDescriptor(QualifiedClassName classname, String name, String descriptor) {
        return this.classfile.getInternalName().equals(classname) && this.name.equals(name) && this.descriptor.equals(descriptor);
    }

    public MethodDescriptor getParsedDescriptor() {
        if (this.parsedDescriptor == null) {
            this.parsedDescriptor = MethodDescriptor.get(this.isStatic(), this.descriptor);
        }
        return this.parsedDescriptor;
    }

    public int getNumberOfArguments() {
        return this.getParsedDescriptor().getNumberOfParameters();
    }

    public int getLocalIDOfFirstNonArgument() {
        if (this.localIDOfFirstNonArgument == -1) {
            int index = this.isStatic() ? 0 : 1;
            for (String type : this.getParsedDescriptor()) {
                index += type.equals("J") || type.equals("D") ? 2 : 1;
            }
            this.localIDOfFirstNonArgument = index;
        }
        return this.localIDOfFirstNonArgument;
    }

    public void addOverrider(MethodInfo overrider) {
        this.overriders.add(overrider);
        overrider.setMethodOverriden(this);
    }

    public List<MethodInfo> getOverriders() {
        return Collections.unmodifiableList(this.overriders);
    }

    private void setMethodOverriden(MethodInfo methodOverriden) {
        this.methodOverriden = methodOverriden;
    }

    public MethodInfo getMethodOverriden() {
        return this.methodOverriden;
    }

    public void addPotentialCaller(Invoke invocation) {
        if (this.potentialCallers == null) {
            this.potentialCallers = new ArrayList(2);
        }
        this.potentialCallers.add(invocation);
    }

    public Collection<Invoke> getPotentialCallers() {
        return this.potentialCallers == null ? (ArrayList<Invoke>)((Object)Collections.emptySet()) : this.potentialCallers;
    }

    public Set<Invoke> getPreciseCallers(Trace trace, Cancelable cancelable) {
        if (this.actualCallers == null) {
            this.actualCallers = new HashSet<Invoke>(this.getPotentialCallers().size() / 2);
            block0: for (Invoke caller : this.getPotentialCallers()) {
                MethodInfo[] methods = caller.getPreciseMethodsCalled(trace, cancelable);
                if (cancelable != null && cancelable.wasCanceled()) {
                    return null;
                }
                MethodInfo[] methodInfoArray = methods;
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    MethodInfo m = methodInfoArray[n2];
                    if (m == this) {
                        this.actualCallers.add(caller);
                        continue block0;
                    }
                    ++n2;
                }
            }
        }
        return this.actualCallers;
    }

    public int getAccessFlags() {
        return this.access;
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.access);
    }

    public boolean isNative() {
        return Modifier.isNative(this.access);
    }

    public boolean isVirtual() {
        return !this.isStatic();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.access);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.access);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.access);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.access);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.access);
    }

    public boolean isClassInitializer() {
        return this.getFlag(4);
    }

    public boolean isInstanceInitializer() {
        return this.getFlag(5);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.access);
    }

    public boolean isStrict() {
        return Modifier.isStrict(this.access);
    }

    public boolean isMain() {
        return this.getFlag(2);
    }

    public boolean isRun() {
        return this.getFlag(3);
    }

    public boolean isImplicitlyInvoked() {
        return this.isMain() || this.isClassInitializer() || this.isRun();
    }

    public boolean isAccessibleFrom(Classfile type) {
        if (this.classfile == type) {
            return true;
        }
        if (type.isSubclassOf(this.classfile.getInternalName())) {
            return this.isPublic() || this.isProtected();
        }
        return false;
    }

    public boolean isStateAffecting() {
        return this.code == null ? false : this.code.isStateAffecting();
    }

    public int getFirstInstructionID() {
        return this.firstInstructionID;
    }

    @Override
    public int compareTo(MethodInfo o) {
        return this.getQualifiedNameAndDescriptor().compareTo(o.getQualifiedNameAndDescriptor());
    }

    public CodeAttribute getCode() {
        return this.code;
    }

    public void trimToSize() {
        if (this.potentialCallers != null) {
            this.potentialCallers.trimToSize();
        }
        this.overriders.trimToSize();
    }

    public boolean callsSuper() {
        return this.code != null && this.code.getCallToSuper() != null;
    }

    public String toString() {
        return this.getQualifiedNameAndDescriptor();
    }
}

