/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.bytecode.CodeAttribute;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.TableBranch;
import edu.cmu.hcii.whyline.trace.EventKind;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LOOKUPSWITCH
extends TableBranch {
    private final int defaultOffset;
    private Instruction defaultTarget;
    private final Pair[] pairs;
    private final Vector<Instruction> targets;

    public LOOKUPSWITCH(CodeAttribute method, int defaultOffset, int numberOfPairs) {
        super(method);
        this.defaultOffset = defaultOffset;
        this.pairs = new Pair[numberOfPairs];
        this.targets = new Vector(numberOfPairs);
    }

    @Override
    public SortedSet<Instruction> createSuccessorsCache() {
        TreeSet<Instruction> successors = new TreeSet<Instruction>();
        successors.addAll(this.targets);
        successors.add(this.defaultTarget);
        return successors;
    }

    @Override
    public final int getOpcode() {
        return 171;
    }

    @Override
    public int getNumberOfOperandsConsumed() {
        return 1;
    }

    @Override
    public int getNumberOfOperandsProduced() {
        return 0;
    }

    @Override
    public int getNumberOfOperandsPeekedAt() {
        return 0;
    }

    public void setPair(int index, int key, int offset) {
        this.pairs[index] = new Pair(key, offset);
    }

    @Override
    public void toBytes(DataOutputStream code) throws IOException {
        code.write(this.getOpcode());
        int numberOfZeroedBytesToWrite = this.numberOfPaddedBytes();
        int i = 0;
        while (i < numberOfZeroedBytesToWrite) {
            code.writeByte(0);
            ++i;
        }
        code.writeInt(this.defaultTarget.getByteIndex() - this.getByteIndex());
        code.writeInt(this.pairs.length);
        i = 0;
        while (i < this.pairs.length) {
            code.writeInt(this.pairs[i].key);
            code.writeInt(this.targets.get(i).getByteIndex() - this.getByteIndex());
            ++i;
        }
    }

    @Override
    public void resolveTargets(Instruction[] instructionsByByteIndex) {
        this.defaultTarget = instructionsByByteIndex[this.getByteIndex() + this.defaultOffset];
        this.code.addIncomingBranchToInstruction(this, this.defaultTarget);
        int i = 0;
        while (i < this.pairs.length) {
            Instruction target = instructionsByByteIndex[this.getByteIndex() + this.pairs[i].offset];
            this.code.addIncomingBranchToInstruction(this, target);
            this.targets.add(target);
            ++i;
        }
    }

    @Override
    public void replaceTarget(Instruction oldTarget, Instruction newTarget) {
        if (oldTarget == this.defaultTarget) {
            this.defaultTarget = newTarget;
        }
        int i = 0;
        while (i < this.targets.size()) {
            if (this.targets.get(i) == oldTarget) {
                this.targets.set(i, newTarget);
            }
            ++i;
        }
    }

    @Override
    public int byteLength() {
        return 1 + this.numberOfPaddedBytes() + 4 + 4 + this.pairs.length * 8;
    }

    private int numberOfPaddedBytes() {
        int bytesOff = (this.getByteIndex() + 1) % 4;
        return bytesOff == 0 ? 0 : 4 - bytesOff;
    }

    @Override
    public Iterable<Instruction> getNonDefaultTargets() {
        return this.targets;
    }

    @Override
    public Instruction getTarget() {
        return this.defaultTarget;
    }

    @Override
    public int getNumberOfNonDefaultTargets() {
        return this.targets.size();
    }

    @Override
    public EventKind getTypeProduced() {
        return null;
    }

    @Override
    public String toString() {
        String prefix = super.toString();
        String postfix = " default => " + this.defaultTarget.getIndex() + ", ";
        int i = 0;
        while (i < this.pairs.length) {
            postfix = String.valueOf(postfix) + this.pairs[i].key + " => " + this.targets.get(i).getIndex() + ", ";
            ++i;
        }
        return String.valueOf(prefix) + postfix;
    }

    @Override
    public String getReadableDescription() {
        return "switch";
    }

    @Override
    public String getKeyword() {
        return "switch";
    }

    private class Pair {
        public final int key;
        public final int offset;

        public Pair(int key, int offset) {
            this.key = key;
            this.offset = offset;
        }
    }
}

