/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.analysis.AnalysisException;
import edu.cmu.hcii.whyline.bytecode.Attribute;
import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.ConstantPool;
import edu.cmu.hcii.whyline.bytecode.Definition;
import edu.cmu.hcii.whyline.bytecode.JavaSpecificationViolation;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.bytecode.UTF8Info;
import edu.cmu.hcii.whyline.bytecode.Use;
import edu.cmu.hcii.whyline.util.Named;
import edu.cmu.hcii.whyline.util.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldInfo
implements Comparable<FieldInfo>,
Named {
    private final Classfile classfile;
    private final int access;
    private final UTF8Info nameInfo;
    private final UTF8Info descriptorInfo;
    private final String qualifiedName;
    private Attribute[] attributes;
    private ConstantPool pool;
    private final int declarationIndex;
    private ArrayList<Definition> definitions = new ArrayList(2);
    private ArrayList<Use> uses = new ArrayList(2);
    private ArrayList<MethodInfo> setters;

    public FieldInfo(Classfile classfile, DataInputStream data, ConstantPool pool, int declarationIndex) throws IOException, JavaSpecificationViolation, AnalysisException {
        this.classfile = classfile;
        this.pool = pool;
        this.declarationIndex = declarationIndex;
        this.access = data.readUnsignedShort();
        this.nameInfo = (UTF8Info)pool.get(data.readUnsignedShort());
        this.descriptorInfo = (UTF8Info)pool.get(data.readUnsignedShort());
        StringBuilder builder = new StringBuilder(classfile.getInternalName().getText());
        builder.append('.');
        builder.append(this.nameInfo.toString());
        this.qualifiedName = builder.toString();
        int attributeCount = data.readUnsignedShort();
        this.attributes = new Attribute[attributeCount];
        int i = 0;
        while (i < attributeCount) {
            this.attributes[i] = Attribute.read(this, pool, data);
            ++i;
        }
    }

    public void toBytes(DataOutputStream stream) throws IOException {
        stream.writeShort(this.access);
        stream.writeShort(this.nameInfo.getIndexInConstantPool());
        stream.writeShort(this.descriptorInfo.getIndexInConstantPool());
        stream.writeShort(this.attributes.length);
        Attribute[] attributeArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attr = attributeArray[n2];
            attr.toBytes(stream);
            ++n2;
        }
    }

    public int getDeclarationIndex() {
        return this.declarationIndex;
    }

    public List<MethodInfo> getSetters() {
        if (this.setters == null) {
            this.setters = new ArrayList(1);
            for (Definition put : this.definitions) {
                MethodInfo method = put.getMethod();
                if (!method.isPublic()) continue;
                this.setters.add(method);
            }
            this.setters.trimToSize();
        }
        return Collections.unmodifiableList(this.setters);
    }

    public void addDefinition(Definition putfield) {
        this.definitions.add(putfield);
    }

    public List<Definition> getDefinitions() {
        return Collections.unmodifiableList(this.definitions);
    }

    public void addUse(Use inst) {
        this.uses.add(inst);
    }

    public List<Use> getUses() {
        return Collections.unmodifiableList(this.uses);
    }

    public Classfile getClassfile() {
        return this.classfile;
    }

    public int getAccessFlags() {
        return this.access;
    }

    public String getTypeDescriptor() {
        return this.descriptorInfo.toString();
    }

    public QualifiedClassName getTypeName() {
        return QualifiedClassName.getFromTypeDescriptor(this.getTypeDescriptor());
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String getName() {
        return this.nameInfo.toString();
    }

    @Override
    public String getDisplayName(boolean html, int limit) {
        return Util.elide(this.getName(), limit);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.access);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.access);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.access);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.access);
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.access);
    }

    public boolean isVolatile() {
        return Modifier.isVolatile(this.access);
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.access);
    }

    @Override
    public int compareTo(FieldInfo o) {
        return this.getQualifiedName().compareTo(o.getQualifiedName());
    }

    public char getTypeDescriptorCharacter() {
        return this.getTypeDescriptor().charAt(0);
    }

    public Object getDefaultValue() {
        return FieldInfo.getDefaultValueForDescriptor(this.getTypeDescriptorCharacter());
    }

    public String toString() {
        return this.getClassfile().getInternalName() + " " + Modifier.toString(this.access) + " " + this.getTypeDescriptor() + " " + this.getName();
    }

    public static Object getDefaultValueForDescriptor(char descriptor) {
        switch (descriptor) {
            case 'B': {
                return (byte)0;
            }
            case 'C': {
                return Character.valueOf('\u0000');
            }
            case 'D': {
                return 0.0;
            }
            case 'F': {
                return Float.valueOf(0.0f);
            }
            case 'I': {
                return 0;
            }
            case 'J': {
                return 0L;
            }
            case 'L': {
                return null;
            }
            case 'S': {
                return (short)0;
            }
            case 'Z': {
                return false;
            }
            case '[': {
                return null;
            }
        }
        return "unknown type represented by " + descriptor;
    }

    public void trimToSize() {
        this.definitions.trimToSize();
    }

    public boolean isReference() {
        char type = this.getTypeDescriptorCharacter();
        return type == 'L' || type == '[';
    }

    public boolean isBoolean() {
        return this.getTypeDescriptorCharacter() == 'Z';
    }
}

