/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.analysis.AnalysisException;
import edu.cmu.hcii.whyline.bytecode.AnonymousAttribute;
import edu.cmu.hcii.whyline.bytecode.CodeAttribute;
import edu.cmu.hcii.whyline.bytecode.ConstantPool;
import edu.cmu.hcii.whyline.bytecode.ConstantPoolInfo;
import edu.cmu.hcii.whyline.bytecode.ExceptionsAttribute;
import edu.cmu.hcii.whyline.bytecode.IOAttribute;
import edu.cmu.hcii.whyline.bytecode.InnerClassesAttribute;
import edu.cmu.hcii.whyline.bytecode.JavaSpecificationViolation;
import edu.cmu.hcii.whyline.bytecode.LineNumberTableAttribute;
import edu.cmu.hcii.whyline.bytecode.LocalVariableTableAttribute;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.SourceFileAttribute;
import edu.cmu.hcii.whyline.bytecode.UTF8Info;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class Attribute {
    public static Attribute read(Object owner, ConstantPool pool, DataInputStream data) throws IOException, JavaSpecificationViolation, AnalysisException {
        int attributeNameIndex = data.readUnsignedShort();
        int length = data.readInt();
        ConstantPoolInfo info = pool.get(attributeNameIndex);
        UTF8Info attributeName = (UTF8Info)info;
        String name = attributeName.toString();
        if (name.equals("Code")) {
            return new CodeAttribute(attributeName, (MethodInfo)owner, pool, data, length);
        }
        if (name.equals("Exceptions")) {
            return new ExceptionsAttribute(attributeName, pool, data, length);
        }
        if (name.equals("InnerClasses")) {
            return new InnerClassesAttribute(attributeName, pool, data, length);
        }
        if (name.equals("SourceFile")) {
            return new SourceFileAttribute(attributeName, pool, data, length);
        }
        if (name.equals("LineNumberTable")) {
            return new LineNumberTableAttribute(attributeName, (CodeAttribute)owner, pool, data, length);
        }
        if (name.equals("LocalVariableTable")) {
            return new LocalVariableTableAttribute((CodeAttribute)owner, attributeName, length, pool, data);
        }
        if (name.equals("InputOutput")) {
            return new IOAttribute(attributeName, pool, data, length);
        }
        return new AnonymousAttribute(attributeName, pool, data, length);
    }

    public abstract int getTotalAttributeLength();

    public int getAttributeLengthWithoutNameAndLength() {
        return this.getTotalAttributeLength() - 2 - 4;
    }

    public abstract void toBytes(DataOutputStream var1) throws IOException;
}

