/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.analysis;

import edu.cmu.hcii.whyline.analysis.DynamicValueSource;
import edu.cmu.hcii.whyline.analysis.UnexecutedInstructionAnalyzer;
import edu.cmu.hcii.whyline.analysis.ValueSource;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.qa.Answer;
import edu.cmu.hcii.whyline.qa.ExpectedObject;
import edu.cmu.hcii.whyline.qa.Question;
import edu.cmu.hcii.whyline.qa.ThisCodeDidExecuteAnswer;
import edu.cmu.hcii.whyline.qa.ValueOverriddenAnswer;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.util.IntegerVector;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhyNotValueAnalyzer {
    public static Answer compare(Question<?> question, ValueSource source, Trace trace, ExpectedObject objectExpectation, int eventID) {
        int actualIndex;
        IntegerVector actualPathEvents = DynamicValueSource.getPathToSource(trace, eventID);
        ArrayList<Instruction> actualPath = new ArrayList<Instruction>(actualPathEvents.size());
        int i = 0;
        while (i < actualPathEvents.size()) {
            actualPath.add(trace.getInstruction(actualPathEvents.get(i)));
            ++i;
        }
        ArrayList<Instruction> expectedPath = new ArrayList<Instruction>(source.path);
        Instruction firstCommonInstruction = null;
        for (Instruction actual : actualPath) {
            int index = expectedPath.indexOf(actual);
            if (index < 0) continue;
            firstCommonInstruction = actual;
            break;
        }
        if (firstCommonInstruction == null) {
            return UnexecutedInstructionAnalyzer.explain(question, new Instruction[]{expectedPath.get(0).getConsumers().getFirstConsumer()}, objectExpectation);
        }
        int expectedIndex = expectedPath.indexOf(firstCommonInstruction);
        Instruction expectedDeviation = null;
        Instruction actualDeviation = null;
        for (actualIndex = actualPath.indexOf(firstCommonInstruction); expectedIndex < expectedPath.size() && actualIndex < actualPath.size(); ++actualIndex, ++expectedIndex) {
            if (expectedPath.get(expectedIndex) == actualPath.get(actualIndex)) continue;
            expectedDeviation = expectedPath.get(expectedIndex);
            actualDeviation = (Instruction)actualPath.get(actualIndex);
            break;
        }
        if (expectedDeviation == null) {
            IntegerVector executions = new IntegerVector(1);
            executions.append(eventID);
            return new ThisCodeDidExecuteAnswer(question, executions);
        }
        IntegerVector executions = trace.findExecutionsOfInstructionAfter(expectedDeviation, 0L, question.getInputEventID());
        if (executions.isEmpty()) {
            return UnexecutedInstructionAnalyzer.explain(question, new Instruction[]{expectedDeviation}, objectExpectation);
        }
        int actualDeviationEventID = actualPathEvents.get(actualIndex);
        int i2 = 0;
        while (i2 < executions.size()) {
            if (executions.get(i2) > actualDeviationEventID) {
                return new ThisCodeDidExecuteAnswer(question, executions);
            }
            ++i2;
        }
        return new ValueOverriddenAnswer(question, executions.lastValue(), actualDeviationEventID);
    }
}

