/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.analysis;

import edu.cmu.hcii.whyline.analysis.SearchResultsInterface;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.source.Token;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodCallersSearch
implements SearchResultsInterface {
    private final WhylineUI whylineUI;
    private final MethodInfo method;

    public MethodCallersSearch(WhylineUI whylineUI, MethodInfo method) {
        this.whylineUI = whylineUI;
        this.method = method;
    }

    @Override
    public String getCurrentStatus() {
        return "Done.";
    }

    @Override
    public SortedSet<Token> getResults() {
        TreeSet<Token> lines = new TreeSet<Token>();
        for (Invoke caller : this.method.getPotentialCallers()) {
            lines.addAll(caller.getLine().getTokensAfterFirstNonWhitespaceToken());
        }
        return lines;
    }

    @Override
    public String getResultsDescription() {
        return "callers of " + this.method.getJavaName() + "()";
    }

    @Override
    public boolean isDone() {
        return true;
    }
}

