/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.analysis;

import edu.cmu.hcii.whyline.bytecode.GETFIELD;
import edu.cmu.hcii.whyline.bytecode.GETSTATIC;
import edu.cmu.hcii.whyline.bytecode.GetLocal;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.util.IntegerVector;

public class DynamicValueSource {
    public static IntegerVector getPathToSource(Trace trace, int eventID) {
        IntegerVector path = new IntegerVector(10);
        int e = eventID;
        while (e >= 0) {
            EventKind kind = trace.getKind(e);
            if (!kind.isArgument) {
                path.append(e);
            }
            if (kind.isArgument) {
                e = trace.getHeapDependency(e);
                continue;
            }
            if (kind == EventKind.PUTFIELD) {
                e = trace.getOperandStackValue(e, 1).getEventID();
                continue;
            }
            if (kind == EventKind.PUTSTATIC) {
                e = trace.getOperandStackValue(e, 0).getEventID();
                continue;
            }
            if (kind == EventKind.SETLOCAL) {
                e = trace.getOperandStackValue(e, 0).getEventID();
                continue;
            }
            if (kind == EventKind.RETURN) {
                e = trace.getOperandStackValue(e, 0).getEventID();
                continue;
            }
            if (!kind.isValueProduced) break;
            Instruction i = trace.getInstruction(e);
            if (i instanceof GETFIELD) {
                e = trace.getHeapDependency(e);
                continue;
            }
            if (i instanceof GETSTATIC) {
                e = trace.getHeapDependency(e);
                continue;
            }
            if (i instanceof GetLocal) {
                e = trace.getHeapDependency(e);
                continue;
            }
            if (!(i instanceof Invoke)) break;
            e = trace.getHeapDependency(e);
        }
        return path;
    }
}

