package edu.cmu.hcii.problemreports;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class WordQuery extends Analyzer {

	// The word x list of words table
	private Hashtable<Word, Vector<Word>> table = new Hashtable<Word, Vector<Word>>();
	private Vector<FieldExpression> expressions;
	private int totalWords = 0;
	private HashSet<Sentence> sentences = new HashSet<Sentence>();
	private int totalWordsInQuery = 0;
	
	public WordQuery(Vector<FieldExpression> expressions) {

		this.expressions = expressions;
		
	}
	
	public void analyze(Sentence s, Word w) {

		sentences.add(s);
		
		totalWords++;

		// Does it match the query?
		for(FieldExpression expression : expressions) {

			if(expression.fieldName.equals("word")) {
				if(!expression.pattern.matcher(w.word).matches()) return;
			}
			else if(expression.fieldName.equals("tag")) {
				if(!expression.pattern.matcher(w.tag).matches()) return;
			}
						
		}

		totalWordsInQuery++;
		Vector<Word> list = null;
		if(table.containsKey(w)) list = table.get(w);
		else {
			list = new Vector<Word>();
			table.put(w, list);
		}		
		list.add(w);
		
	}
	
	public QueryTable getResult(String sortBy, boolean expand) {

		QueryTable result = new QueryTable(sortBy, expand, sentences.size(), totalWords, totalWordsInQuery);
		
		for(Word key : table.keySet()) {

			Vector<Word> words = table.get(key);
			result.addRow(words);

		}

		return result;
		
	}
		
}
