package edu.cmu.hcii.problemreports;

// A text/tag pair, for which each pair is unique.
public class Word {

	public String word, tag;
	public Sentence sentence;
	
	public Word(Sentence s, String wordTag) {

		sentence = s;

		// Split the / delimited word into word and tag
		String[] split = wordTag.trim().split("/");
		if(split.length < 2) {
			word = wordTag;
			tag = "";
		}
		else {
			tag = split[split.length - 1];
			word = split[0];
			for(int i = 1; i < split.length - 1; i++) word = word + "/" + split[i];
			if(!tag.matches("NN.*")) word = word.toLowerCase();
		}
		
	}

	public String toString() {
		
		return word + "/" + tag;
		
	}
	
	public Sentence getSentence() { return sentence; }
	
	public boolean equals(Object o) {
		
		if(!(o instanceof Word)) return false;
		else if(!word.equalsIgnoreCase(((Word)o).word)) return false;
		else if(!tag.equalsIgnoreCase(((Word)o).tag)) return false;
		return true;
		
	}
	
	public int hashCode() {
		
		return word.hashCode() *32 + tag.hashCode();
		
	}
	
}
