package edu.cmu.hcii.problemreports;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class Table implements Iterable<Row> {

	private Vector<String> columns;
	private Hashtable<String,Integer> columnsByName;
	private Vector<Row> rows;
	
	public Table(File newFile) {
		
		rows = new Vector<Row>(300000);

		addRows(newFile);

	}
	public Table(Vector<String> columns, Vector<Row> rows) {
		
		this.rows = rows;
		this.columns = columns;
		columnsByName = new Hashtable<String,Integer>();
		int columnNumber = 0;
		for(String s : columns) {
			columnsByName.put(s, columnNumber++);
		}
		
		
	}
	
	public Table filter(Vector<FieldExpression> expressions) {
		
		Vector<Row> filteredRows = new Vector<Row>();
		
		for(Row row : rows) {
			boolean matches = true;
			for(FieldExpression expression : expressions) {
				String value = row.getValueInColumnNamed(expression.fieldName);
				if(value != null && !expression.pattern.matcher(value).matches()) { matches = false; break; }
			}
			if(matches) filteredRows.add(row);
		}

		return new Table(columns, filteredRows);
		
	}
	
	public void addRows(File file) {
		
		System.err.print("Reading " + file.getName());
		try {
			BufferedReader reader = new BufferedReader(new FileReader(file));

			String columnString = reader.readLine();
			if(columns == null) {
				columns = new Vector<String>();
				columnsByName = new Hashtable<String,Integer>();
				int columnNumber = 0;
				for(String s : columnString.split(",")) {
					columns.add(s);
					columnsByName.put(s, columnNumber++);
				}
			}
			else {

				// Should be checking to make sure rows match
			}
			
			int lineNumber = 0;
			String line = null;
			do {

				lineNumber++;
				if(lineNumber % 1000 == 0) System.err.print(".");
				line = reader.readLine();
				if(line != null) addRow(line);

			} while(line != null);
			
		} catch (FileNotFoundException e) {
			System.err.println("Couldn't find a file named " + file.getAbsolutePath());
			System.exit(0);
		} catch (IOException e) {
			System.err.println("Couldn't read the file.");
			e.printStackTrace();
			System.exit(0);
		}
		System.err.println("done.");
		
	}
	
	public int getColumnCount() { return columns.size(); }
	public int getRowCount() { return rows.size(); }
	
	public int getNumberOfColumnNamed(String name) { 
		
		Integer i = columnsByName.get(name); 
		if(i == null) return -1;
		else return i.intValue();
		
	}
	
	public Iterator<String> getColumns() { return columns.iterator(); }

	public String getCommaSeparatedColumns() {
		
		String string = "";
		for(int i = 0; i < columns.size() - 1; i++)
			string = string + columns.get(i) + ",";
		string = string + columns.lastElement();
		return string;
		
	}
	
	public void addRow(String rowString) {
		
		rows.add(new Row(this, rowString));
		
	}

	public Row getRow(int i) {
		
		return rows.get(i);
		
	}
	
	public Iterator<Row> iterator() {
		return rows.iterator();
	}
	
	public static Table constructTableFromFile(File newFile) {

		Table table = null;
		
		
		return table;
		
	}

	
}