package edu.cmu.hcii.problemreports;

import java.util.Vector;

public class Sentence {

	private Vector<Word> words = new Vector<Word>();
	private Row row;
	private String tagSequence = null;

	public Sentence(Row row, String line) {

		this.row = row;
		
		if(line.startsWith("\"") && line.endsWith("\""))
			line = line.substring(1, line.length() - 1);
		line = line.replaceAll("\"\"", "\"");
		
		// Split the last column value into words
		String[] wordTags = line.split("\\s");
		for(String word : wordTags) words.add(new Word(this, word));
		
	}

	public String toString() {
		
		String result = "";
		for(Word word : words) result = result + word + " ";
		// Remove that last space.
		return result.trim();
		
	}
	
	public String toUntaggedString() {
		
		String result = "";
		for(Word word : words) result = result + word.word + " ";
		// Remove that last space that we added.
		return result.trim();
		
	}
	
	public String toTagSequence() {
		
		String tags = "";
		for(Word word : words)
			tags = tags + word.tag + "-";
		return tags;
		
	}

	public void analyze(Analyzer a) {
		
		for(Word word : words) a.analyze(this, word);
		
	}
	
	public Row getRow() { return row; }
	
}
