package edu.cmu.hcii.problemreports;

public class Row {

	private Table table;
	private String[] values;
	private Sentence sentence = null;
	
	public Row(Table table, String valueString) {
		
		this.table = table;

		values = new String[table.getColumnCount()];

//		char[] characters = valueString.toCharArray();
		
		int startIndex = 0;
		int characterIndex = 0;
		int valueIndex = 0;
		while(characterIndex < valueString.length() && valueIndex < values.length) {

			// If we find a quote, read over the whole quoted thing.
			if(valueString.charAt(characterIndex) == '\"') {

				characterIndex++;
				while(characterIndex < valueString.length() && valueString.charAt(characterIndex) != '\"')
					characterIndex++;
				if(characterIndex < valueString.length())
					characterIndex++;

			}
			else if(characterIndex < valueString.length() && valueString.charAt(characterIndex) == ',') {

				String value = valueString.substring(startIndex, characterIndex);
				
				characterIndex++;
				if(value.startsWith("\"") && value.endsWith("\"")) value = value.substring(1, value.length() - 1);
				values[valueIndex++] = value;
				startIndex = characterIndex;
				
			}
			else if(characterIndex < valueString.length())
				characterIndex++;

		}
		
		// Add the last value, as long as its not too many. This handles the case of an extra trailing ',' that
		// actually doesn't indicate a value.
		if(valueIndex < values.length) {
			
			String value = valueString.substring(startIndex, characterIndex);
			if(value.startsWith("\"") && value.endsWith("\"")) value = value.substring(1, value.length() - 1);
			values[valueIndex++] = value;
		}
		
		if(valueIndex < values.length) {
			
			System.err.println("Not enough values in the row\n\n" + valueString + "\n\nExpected " + table.getColumnCount() + " but found only " + valueIndex);
			System.exit(0);
			
		}
		else if(valueIndex > values.length) {

			System.err.println("Too many values in the row\n\n" + valueString + "\n\nExpected " + table.getColumnCount() + " found " + valueIndex + " or more.");
			System.exit(0);
			
		}		
		
	}

	public String getValueInColumn(int column) {
		
		return values[column];
		
	}
	
	public String getValueInColumnNamed(String name) {
		
		// Handle pretend columns
		if(name.equals("tagseq")) {
			return getSentence().toTagSequence();
		}
		
		int column = table.getNumberOfColumnNamed(name);
		if(column < 0) return null;
		else return values[column];
		
	}

	public void setValueInColumnNamed(String name, String value) {
		
		int column = table.getNumberOfColumnNamed(name);
		if(column < 0) return;
		else values[column] = value;
		
	}
	
	public Sentence getSentence() { 
	
		if(sentence == null)
			sentence = new Sentence(this, values[values.length - 1]);
		return sentence;
	
	}
	
}