import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

import edu.cmu.hcii.problemreports.*;

import edu.stanford.nlp.tagger.maxent.MaxentTagger;

public class Tag {

	public static final void main(String[] args) {

		PrintStream out = System.out;
		
		if(args.length == 0) {

			System.err.println("");
			System.err.println("Accepts a comma separated values file, with a natural language sentence in the last column, and tags the sentence's parts of speech");
			System.err.println("The arguments following the file should be the columns desired in the output.");
			System.err.println("This always outputs the last column tagged, which is assumed to be the problem description.");
			System.err.println("\nUsage:");
			System.err.println("");
			System.err.println("\tjava Tag file.csv column1 column2 ... columnN");
			System.err.println("");
			System.err.println("I've done my best to make sure that even if the last column has commas, they get parsed correctly.");
			System.err.println("HOWEVER: I didn't handle other columns!");
			System.exit(0);
			
		}
		
		// Read in the table
		System.err.println("Reading " + args[0]);
		File inputFile = new File(args[0]);
		Table table = new Table(inputFile);
		System.err.println("Done.");
		
		String outputFileName = inputFile.getName() + ".tagged";
		System.err.println("Writing file named " + outputFileName);
		try {
			FileOutputStream writer = new FileOutputStream(new File(outputFileName));
			out = new PrintStream(writer);
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		System.err.println("Adding a project column that has value " + args[1]);
		
		System.err.println("Initializing tagger...");
		MaxentTagger.init("left3words/wsj3t0-18.holder");
		System.err.println("Done initializing.");

		System.err.println("Generating tagged CSV file...");
			
		System.err.println("Tagging " + table.getRowCount() + " sentences.");
		System.err.println("0%------20--------40--------60--------80------100%");

		final int firstColumnName = 2;
		
		// Print out the desired columns
		out.print("project,");
		for(int i = firstColumnName; i < args.length; i++) {
			out.print(args[i] + ",");
		}
		out.println("description");
		
		// Go through each row, tag the sentence, and print the new row
		int rowNumber = 0;
		for(Row row : table) {
			
			String untaggedString = row.getSentence().toUntaggedString();
			if(untaggedString.startsWith("\"") && untaggedString.endsWith("\""))
				untaggedString = untaggedString.substring(1, untaggedString.length() - 1);
			String taggedSummary = MaxentTagger.tagString(untaggedString).trim();
			
			out.print("\"" + args[1] + "\",");
			
			for(int i = firstColumnName; i < args.length; i++) {

				String value = row.getValueInColumnNamed(args[i]);
				if(value == null) value = "\"\"";

				if(!value.startsWith("\""))
					value = "\"" + value + "\"";
				out.print(value + ",");
				
			}
			if(!taggedSummary.matches("\".*\""))
				taggedSummary = "\"" + taggedSummary + "\"";
			out.println(taggedSummary);

			rowNumber++;
			if(table.getRowCount() > 50 && rowNumber % (table.getRowCount() / 50) == 0) System.err.print("*");
			
		}
		
		System.err.println("\nDone generating.");
		
	}

}
