% Poisson inference example

fname = 'Poisson_pdf.eps';
printflag = 0;
opts = struct('color','rgb','FontMode','fixed','FontSize',18,'height',5);

lambda = 2;
n = 0:10;
y = poisspdf(n, lambda);
bar(n,y); 
box off; xlabel('n = count'); ylabel('p(n|\lambda)');

if printflag == 1
    fprintf('Printing to figure to %s\n', fname);
    exportfig(gcf, fname, opts);
    fprintf('Converting to pdf and removing eps file.\n');
    system(sprintf('pstopdf %s', fname));
    system(sprintf('rm %s', fname));
end