% Plot the ratio estimate

fname = 'binomial_ratio_estimate.eps';
printflag = 1;

opts = struct('color','rgb','FontMode','fixed','FontSize',18, ...
    'width',7, 'height', 4);

theta = 0:0.002:1;
n=50;
y=17;
x = binopdf(y, n, theta);
plot(theta, x, 'black', 'LineWidth', 2); hold on;

ratio_est = y/n;

plot(ratio_est, 0, '*'); hold off;

set(gca,'XLim',[0,1], 'YTickLabel', []);
box off;
xlabel('\theta');
ylabel(sprintf('p(\\theta | y=%d, n=%d)', y, n));

if printflag == 1
    fprintf('Printing to figure to %s\n', fname);
    exportfig(gcf, fname, opts);
    fprintf('Converting to pdf and removing eps file.\n');
    system(sprintf('pstopdf %s', fname));
    system(sprintf('rm %s', fname));
end
