% Plot a binomial pdf

vals = {[0.5, 10], [0.25, 10], [0.25, 20]};
opts = struct('color','rgb','FontMode','fixed','FontSize',18, ...
    'width',7, 'height', 3);

for i=1:length(vals)
    theta = vals{i}(1); n = vals{i}(2);
    x = 1:15;
    y = binopdf(x, n, theta);
    bar(x,y); box off; 
    xlabel('y');
    ylabel(sprintf('p(y|\\theta=%g, n=%d)', theta, n));

    fname = sprintf('binomial_pdf_theta=%g_n=%d.eps', theta, n);

    fprintf('Printing to figure to %s\n', fname);
    exportfig(gcf, fname, opts);
    fprintf('Converting to pdf\n');
    system(sprintf('pstopdf %s', fname));
end
