% Plot the expected value estimate

fname = 'binomial_expected_value.eps';
printflag = 1;

opts = struct('color','rgb','FontMode','fixed','FontSize',18, ...
    'width',7, 'height', 4);

theta = 0:0.002:1;
n=1;
y=0;
x = binopdf(y, n, theta);
plot(theta, x, 'black', 'LineWidth', 2); hold on;

expected_val = (y+1)/(n+2);
val = binopdf(y,n,expected_val);

plot([expected_val, expected_val], [0,val], '-', 'LineWidth', 2);
plot(expected_val,val, '*'); hold off;

set(gca,'XLim',[0,1], 'YTickLabel', []);
box off;
xlabel('\theta');
ylabel(sprintf('p(\\theta | y=%d, n=%d)', y, n));

fprintf('E(theta | y=%d, n=%d) = %g\n', y,n,expected_val);

if printflag == 1
    fprintf('Printing to figure to %s\n', fname);
    exportfig(gcf, fname, opts);
    fprintf('Converting to pdf and removing eps file.\n');
    system(sprintf('pstopdf %s', fname));
    system(sprintf('rm %s', fname));
end
