/*
 * watch.h
 * author: Kevin Waugh (waugh@cs.cmu.edu)
 */

#ifndef _WATCH_H_
#define _WATCH_H_

#include <sys/time.h>

#include "attributes.h"

#include "verify.h"

typedef struct {
  struct timeval when;
  int every_i;
  double every_t;
  int first, last;
} watch_t;

void init_watch(watch_t * restrict watch, const char * restrict params) NONNULL(1,2);
static inline int watch_tick(watch_t * restrict watch, int first, int last, int iteration) NONNULL(1);

static inline int watch_tick(watch_t * restrict watch, int first, int last, int iteration) {
  assert(watch);
  if (first) {
    if (watch->every_t) {
      gettimeofday(&watch->when, NULL);
    }
    return watch->first;
  }
  if (iteration >= watch->every_i && (iteration%watch->every_i) == 0) {
    return 1;
  }
  if (watch->every_t > 0.) {
    struct timeval now;
    gettimeofday(&now, NULL);
    if (now.tv_sec - watch->when.tv_sec + 1e-6*(now.tv_usec - watch->when.tv_usec) > watch->every_t) {
      watch->when = now;
      return 1;
    }
  }
  if (last && watch->last) {
    return 1;
  }
  return 0;
}

#endif /* _WATCH_H_ */
