/*
 * watch.c
 * author: Kevin Waugh (waugh@cs.cmu.edu)
 */

#include <stdio.h>
#include <string.h>
#include <sys/time.h>

#include "util.h"
#include "verify.h"

#include "watch.h"

void init_watch(watch_t * restrict watch, const char * restrict params) {
  const char * p;
  char units[16];

  assert(watch);
  assert(params);

  watch->first   = 0;
  watch->last    = 0;
  watch->every_i = 0;
  watch->every_t = 0.;
  for(;;) {
    if (!strncmp(params, "first", 5)) {
      watch->first = 1;
    } else if (!strncmp(params, "last", 4)) {
      watch->last = 1;
    } else if (!strncmp(params, "iter", 4)) {
      verify(sscanf(params+4, "%d", &watch->every_i) == 1);
      verify(watch->every_i > 0);
    } else if (!strncmp(params, "time", 4)) {
      verify(sscanf(params+4, "%lf%[^, ]", &watch->every_t, units) == 2);
      verify(watch->every_t > 0);
      if (!strcmp(units, "ms")) {
	watch->every_t /= 1000.;
      } else if (!strcmp(units, "s")) {
      } else if (!strcmp(units, "m")) {
	watch->every_t *= 60.;
      } else if (!strcmp(units, "h")) {
	watch->every_t *= 3600.;
      } else {
	verify(0);
      }
    } else {
      verify(0);
    }
    p = strchr(params, ',');
    if (p) {
      params = p+1;
    } else {
      break;
    }
  }
}
