/*
 * verify.h
 * author: Kevin Waugh (waugh@cs.cmu.edu)
 */

#ifndef _VERIFY_H_
#define _VERIFY_H_

#ifdef assert
#undef assert
#endif /* assert */

#ifndef __STRING
#define __STRING(a) #a
#endif /* __STRING */

#include "attributes.h"

#define __MY_FUNCTION__ __PRETTY_FUNCTION__

/* verify is assert that is always enabled */
#define verify(expr)          ((expr)?(void)0:_fail("Verification", __FILE__, __LINE__,\
						    __MY_FUNCTION__,\
						    __STRING(expr)))
#define verifym(expr,msg)     ((expr)?(void)0:_failm("Verification", __FILE__, __LINE__,\
						     __MY_FUNCTION__,\
						     __STRING(expr), msg))
#define verifyf(expr,msg,...) ((expr)?(void)0:_failf("Verification", __FILE__, __LINE__, \
						     __MY_FUNCTION__,\
						     __STRING(expr), msg, __VA_ARGS__))

#ifndef NDEBUG
/* nassert - will evaluate the expression when disabled */
#define nassert(expr)           ((expr)?(void)0:_fail("Assertion", __FILE__, __LINE__, \
						      __MY_FUNCTION__,\
						     __STRING(expr)))
#define nassertm(expr,msg)      ((expr)?(void)0:_failm("Assertion", __FILE__, __LINE__, \
						       __MY_FUNCTION__,\
						      __STRING(expr), msg))
#define nassertf(expr,msg,...)  ((expr)?(void)0:_failf("Assertion", __FILE__, __LINE__, \
						       __MY_FUNCTION__,\
						      __STRING(expr), msg, __VA_ARGS__))
/* assert - will not evaluate expression when disabled */
#define assert(expr)          nassert(expr)
#define assertm(expr,msg)     nassertm(expr, msg)
#define assertf(expr,msg,...) nassertf(expr, msg, __VA_ARGS__)
#else
/* nassert - always evaluates the expression */
#define nassert(expr)           (expr)
#define nassertm(expr,msg)      (expr)
#define nassertf(expr,msg,...)  (expr)
/* assert - will not evaluate expression when disabled */
#define assert(expr)          do {} while(0)
#define assertm(expr,msg)     do {} while(0)
#define assertf(expr,msg,...) do {} while(0)
#endif /* NDEBUG */

void _fail(const char * type, const char * file, int line, const char * function, 
	   const char * expr) NORETURN;
void _failm(const char * type, const char * file, int line, const char * function, const char * expr,
	    const char * msg) NORETURN;
void _failf(const char * type, const char * file, int line, const char * function, const char * expr,
	    const char * format, ...) NORETURN PRINTF(6,7);

#endif /* _VERIFY_H_ */
