/*
 * verify.c
 * author: Kevin Waugh (waugh@cs.cmu.edu)
 */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

#include "verify.h"

#ifdef LINUX
extern char * program_invocation_short_name;
#define PROGRAM_NAME program_invocation_short_name
#else
#define PROGRAM_NAME getprogname()
#endif /* _GNU_SOURCE */

void _fail(const char * type, const char * file, int line, const char * function, const char * expr) {
  fprintf(stderr, "%s: %s:%d %s: %s `%s' failed.\n", PROGRAM_NAME, file, line, function, type, expr);
  
  abort();
}

void _failm(const char * type, const char * file, int line, const char * function, const char * expr,
	    const char * msg) {
  fprintf(stderr, "%s: %s:%d %s: %s `%s' failed.\n", PROGRAM_NAME, file, line, function, type, expr);
  
  fputs(msg, stderr);
  
  abort();
}

void _failf(const char * type, const char * file, int line, const char * function, const char * expr,
	    const char * format, ...) {
  va_list args;

  fprintf(stderr, "%s: %s:%d %s: %s `%s' failed.\n", PROGRAM_NAME, file, line, function, type, expr);
  
  va_start(args, format);
  vfprintf(stderr, format, args);
  va_end(args);
  
  abort();
}
