/*
 * util.h
 * author: Kevin Waugh (waugh@cs.cmu.edu)
 */

#ifndef _UTIL_H_
#define _UTIL_H_

#include <stdlib.h>
#include <stdio.h>

#include "attributes.h"
#include "verify.h"

char * xstrdup(const char * restrict str) MALLOC;
void * xmalloc(size_t size) MALLOC;
void * xcalloc(size_t n, size_t size) MALLOC;
void * xrealloc(void * restrict ptr, size_t size);
#define xfree(ptr) do { if (ptr) { free((void*)ptr); ptr = NULL; } } while(0)

int remove_comment(FILE * restrict stream);
FILE * open_stream(const char * restrict path, const char * restrict mode);
void close_stream(const char * restrict path, FILE * restrict stream);

char * static_sprintf(const char * format, ...);

static inline int mini(int a, int b) CONST;
static inline int maxi(int a, int b) CONST;
static inline void normalize(double * restrict a, int n, double alpha) NONNULL(1);
static inline int sample(const double * restrict a, int n, double u) NONNULL(1);

static inline int mini(int a, int b) {
  return a<b?a:b;
}

static inline int maxi(int a, int b) {
  return a>b?a:b;
}

static inline void normalize(double * restrict a, int n, double alpha) {
  double sum;
  int i;

  assert(a);

  sum = 0.;
  for(i=0; i<n; ++i) {
    if (a[i] > 0.) {
      sum += a[i];
    }
  }
  if (sum > 1e-10) {
    sum = alpha/sum;
    for(i=0; i<n; ++i) {
      if (a[i] > 0.) {
	a[i] *= sum;
      } else {
	a[i] = 0.;
      }
    }
  } else {
    sum = alpha/n;
    for(i=0; i<n; ++i) {
      a[i] = sum;
    }
  }
}

static inline int sample(const double * restrict a, int n, double u) {
  int i;

  assert(a);
  for(i=0; i<n; ++i) {
    if (u < a[i]) {
      return i;
    }
    u -= a[i];
  }

  return n;
}

#endif /* _UTIL_H_ */
