/*
 * timer.c
 * author: Kevin Waugh (waugh@cs.cmu.edu)
 */

#include <math.h>
#include <stdio.h>

#include "verify.h"

#include "timer.h"

const char * format_elapsed(double elapsed, char * restrict buffer) {
  static char internal[64];
  char * p;
  int n, m;

  assert(elapsed >= 0);

  if (buffer) {
    p = buffer;
  } else {
    p = internal;
  }
  *p = 0;
  
  n = 0;
  if (elapsed > 3600.) {
    sprintf(p+n, n?" %.0lfh%n":"%.0lfh%n", floor(elapsed/3600.), &m);
    elapsed -= 3600.*floor(elapsed/3600.); n += m;
  }
  if (elapsed > 60.) {
    sprintf(p+n, n?" %.0lfm%n":"%.0lfm%n", floor(elapsed/60.), &m);
    elapsed -= 60.*floor(elapsed/60.); n += m;
  }
  if (elapsed >= 0.) {
    sprintf(p+n, n?" %.2lfs%n":"%.2lfs%n", elapsed, &m);
  }

  return p;
}
