/*
 * strategy_player.h
 * author: Kevin Waugh (waugh@cs.cmu.edu)
 */

#ifndef _STRATEGY_PLAYER_H_
#define _STRATEGY_PLAYER_H_

#include "sequence_form.h"

typedef struct {
  sequence_form_t * sequence_form;
  double * sigma;
} strategy_player_t;

void * create_strategy(sequence_form_t * restrict sequence_form, int who, int T, 
		       const char * restrict params);
void free_strategy(strategy_player_t * restrict player);
const double * get_strategy_strategy(strategy_player_t * restrict player);
void update_strategy_full_strategy(strategy_player_t * restrict player, 
				   double * restrict payoffs);

#endif /* _STRATEGY_PLAYER_H_ */
