/*
 * strategy_player.c
 * author: Kevin Waugh (waugh@cs.cmu.edu)
 */

#include <stdio.h>
#include <string.h>

#include "args.h"
#include "game.h"
#include "sequence_form.h"
#include "strategy.h"
#include "util.h"
#include "verify.h"

#include "strategy_player.h"

void * create_strategy(sequence_form_t * restrict sequence_form, int who, int T, 
		       const char * restrict params) {
  strategy_player_t * player;
  FILE * stream;
  double epsilon;
  char strategy_path[128];
  sequences_t * sequences;
  int i, j;
  arg_t args[] = {
    {"strategy", "[^,]", strategy_path},
    {"epsilon", "lf", &epsilon},
    {NULL},
  };

  assert(sequence_form);
  assert(valid_player(who));
  assert(T >= 0);
  
  strcpy(strategy_path, "null");
  epsilon = 0.;
  parse_args(args, params);
  verify(strcmp(strategy_path, "null"));
  
  sequences = sequence_form_sequences(sequence_form, who);

  player = xmalloc(sizeof(strategy_player_t));
  player->sequence_form = sequence_form;
  player->sigma         = new_strategy(sequences);

  stream = open_stream(strategy_path, "rt");
  read_strategy(sequence_form_sequences(sequence_form, who), stream, player->sigma);
  close_stream(strategy_path, stream);

  for(i=0; i<abstract_info_sets(sequences_abstraction(sequences)); ++i) {
    normalize(player->sigma+first_sequence(sequences, i), num_sequences(sequences, i), 1.);
    for(j=first_sequence(sequences, i); j<=last_sequence(sequences, i); ++j) {
      if (player->sigma[j] < epsilon) {
	player->sigma[j] = 0.;
      }
    }
  }
  normalize_strategy(sequence_form_sequences(sequence_form, who), player->sigma, 1.);

  return player;
}

void free_strategy(strategy_player_t * restrict player) {
  assert(player);
  xfree(player->sigma);
  xfree(player);
}

const double * get_strategy_strategy(strategy_player_t * restrict player) {
  assert(player);
  return player->sigma;
}

void update_strategy_full_strategy(strategy_player_t * restrict player,
				   double * restrict payoffs) {
  assert(player);
  assert(payoffs);
}
