/*
 * player.c
 * author: Kevin Waugh (waugh@cs.cmu.edu)
 */

#include <string.h>

#include "game.h"
#include "sequence_form.h"

#include "player.h"

#include "cfr_player.h"
#include "chump_player.h"
#include "strategy_player.h"

struct player_entry_s {
  const char * name;
  void * create;
  void * free;
  void * get;
  void * update_full;
} players[] = {
  {"chump", create_chump, free_chump, get_strategy_chump, update_strategy_chump},
  {"cfr", create_cfr, free_cfr, get_strategy_cfr, update_strategy_full_cfr},
  {"strategy", create_strategy, free_strategy, get_strategy_cfr, update_strategy_full_strategy},
  {NULL},
};

void create_player(const char * restrict player_name, sequence_form_t * restrict sequence_form,
		   int who, int T, const char * params, player_t * restrict player) {
  struct player_entry_s * entry;
  
  assert(player_name);
  assert(sequence_form);
  assert(valid_player(who));
  assert(T >= 0);
  assert(player);

  for(entry=players; entry->name; ++entry) {
    if (!strcmp(player_name, entry->name)) {
      player->create_player          = entry->create;
      player->free_player            = entry->free;
      player->get_strategy           = entry->get;
      player->update_full_strategy   = entry->update_full;
      player->data                   = player->create_player(sequence_form, who, T, params);
      break;
    }
  }
  verify(entry->name);
}
