/*
 * lp_eqm.h
 * author: Kevin Waugh (waugh@cs.cmu.edu)
 */

#ifndef _LP_EQM_H_
#define _LP_EQM_H_

#include "attributes.h"

#include "sequence_form.h"
#include "verify.h"

double lp_eqm(sequence_form_t * restrict sequence_form,
	      double * restrict sigma1, double * restrict sigma2,
	      double * restrict ev2, double * restrict ev1) NONNULL(1);

int lp_E(sequences_t * restrict sequences, int row_offset, int column_offset, int * restrict row,
	 int * restrict col, double * restrict element);
int lp_A(sequence_form_t * restrict sequence_form, int row_offset, int column_offset,
	 int negate, int * restrict row, int * restrict col, double * restrict element);

static inline int lp_E_size(sequences_t * restrict sequences) PURE;
static inline int lp_A_size(sequence_form_t * restrict sequences) PURE;

static inline int lp_E_size(sequences_t * restrict sequences) {
  assert(sequences);
  return sequences_n(sequences)+abstract_info_sets(sequences_abstraction(sequences));
}

static inline int lp_A_size(sequence_form_t * restrict sequence_form) {
  assert(sequence_form);
  return sequences_n(sequence_form_sequences(sequence_form, 0))*
    sequences_n(sequence_form_sequences(sequence_form, 1));
}

#endif /* _LP_EQM_H_ */
